/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.util.Config;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ImapConfig
extends MailConfig {
    private int maxLiteralMemSize = 0x800000;
    private int maxLiteralTraceSize = 80;
    private File literalDataDir = new File(System.getProperty("java.io.tmpdir"));
    private boolean useLiteralPlus = true;
    public static final String PROTOCOL = "imap";
    public static final int DEFAULT_PORT = 143;
    public static final int DEFAULT_SSL_PORT = 993;
    public static final int DEFAULT_MAX_LITERAL_MEM_SIZE = 0x800000;
    public static final int DEFAULT_MAX_LITERAL_TRACE_SIZE = 80;
    public static final boolean DEFAULT_USE_LITERAL_PLUS = true;

    public static ImapConfig load(File file) throws IOException {
        Properties props = Config.loadProperties(file);
        ImapConfig config = new ImapConfig();
        config.applyProperties(props);
        return config;
    }

    public ImapConfig() {
    }

    public ImapConfig(String host) {
        super(host);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public int getPort() {
        int port = super.getPort();
        if (port != -1) {
            return port;
        }
        return this.getSecurity() == MailConfig.Security.SSL ? 993 : 143;
    }

    public int getMaxLiteralMemSize() {
        return this.maxLiteralMemSize;
    }

    public void setMaxLiteralMemSize(int size) {
        this.maxLiteralMemSize = size;
    }

    public int getMaxLiteralTraceSize() {
        return this.maxLiteralTraceSize;
    }

    public void setMaxLiteralTraceSize(int size) {
        this.maxLiteralTraceSize = size;
    }

    public File getLiteralDataDir() {
        return this.literalDataDir;
    }

    public void setLiteralDataDir(File dir) {
        this.literalDataDir = dir;
    }

    public void setUseLiteralPlus(boolean useLiteralPlus) {
        this.useLiteralPlus = useLiteralPlus;
    }

    public boolean isUseLiteralPlus() {
        return this.useLiteralPlus;
    }
}

