/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.MailClient;
import com.zimbra.cs.mailclient.imap.IDInfo;
import com.zimbra.cs.mailclient.imap.ImapCapabilities;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.Mailbox;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ListIterator;
import javax.security.auth.login.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapClient
extends MailClient {
    private String mailbox;
    private IDInfo idInfo;
    private static final String[] USAGE = new String[]{"Usage: java " + ImapClient.class.getName() + " [options] hostname", "  -p port  : port to use (default is 143 or 993 for SSL)", "  -u user  : authentication id to use", "  -z user  : authorization id to use", "  -w pass  : password to use", "  -r realm : authentication realm", "  -m mech  : SASL mechanism to use (\"login\" for IMAP LOGIN)", "  -k #     : Minimum QOP to use (0=auth, 1=auth-int, 2=auth-conf)", "  -l #     : Maximum QOP to use (0=auth, 1=auth-int, 2=auth-conf)", "  -s       : enable IMAP over SSL (imaps)", "  -t       : enable IMAP over TLS", "  -f mbox  : select specified mailbox", "  -d       : enable debug output", "  -q       : enable silent mode", "  -i id    : send ID info (name=value,...)", "  -h       : print this help message"};

    protected ImapClient() {
        super(new ImapConfig());
    }

    @Override
    protected void authenticate() throws LoginException, IOException {
        if (this.idInfo != null) {
            this.getImapConnection().id(this.idInfo);
        }
        super.authenticate();
        if (this.mailbox != null) {
            this.getImapConnection().select(this.mailbox);
        }
    }

    @Override
    protected boolean parseArgument(ListIterator<String> args) {
        String arg = args.next();
        if (arg.equals("-f") && args.hasNext()) {
            this.mailbox = args.next();
            return true;
        }
        if (arg.equals("-i") && args.hasNext()) {
            this.parseIDInfo(args.next());
            return true;
        }
        args.previous();
        return super.parseArgument(args);
    }

    private void parseIDInfo(String id) {
        if (this.idInfo == null) {
            this.idInfo = new IDInfo();
        }
        for (String s : id.split(",")) {
            int i = s.indexOf(61);
            if (i <= 0) continue;
            this.idInfo.put(s.substring(0, i), s.substring(i + 1));
        }
    }

    @Override
    protected void printUsage(PrintStream ps) {
        for (String line : USAGE) {
            ps.println(line);
        }
    }

    @Override
    protected boolean processCommand(String[] cmdLine) throws IOException {
        ImapConnection ic = this.getImapConnection();
        String cmd = cmdLine[0];
        if (ImapClient.isMatch(cmd, "SELect")) {
            Mailbox mbox = ic.select(cmdLine[1]);
            System.out.printf(">> Selected mailbox: %s\n", mbox);
        } else if (ImapClient.isMatch(cmd, "CAPability")) {
            ImapCapabilities cap = ic.capability();
            System.out.printf(">> Capabilities: %s\n", cap);
        } else {
            super.processCommand(cmdLine);
        }
        return true;
    }

    @Override
    protected boolean processShow(String[] cmdLine) throws IOException {
        ImapConnection ic = this.getImapConnection();
        String arg = cmdLine[1];
        if (ImapClient.isMatch(arg, "CAPability")) {
            System.out.printf(">> Current capabilities: %s\n", ic.getCapabilities());
        } else if (ImapClient.isMatch(arg, "MAILbox") || ImapClient.isMatch(arg, "MBox")) {
            System.out.printf(">> Current mailbox: %s\n", ic.getMailbox());
        } else {
            return false;
        }
        return true;
    }

    public ImapConnection getImapConnection() {
        return (ImapConnection)this.connection;
    }

    public static void main(String[] args) throws Exception {
        new ImapClient().run(args);
    }
}

