/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.Chars;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ImapCapabilities {
    private final Set<Atom> capabilities = new HashSet<Atom>();
    public static final String IMAP4REV1 = "IMAP4rev1";
    public static final String STARTTLS = "STARTTLS";
    public static final String LOGINDISABLED = "LOGINDISABLED";
    public static final String IMAP4 = "IMAP4";
    public static final String LITERAL_PLUS = "LITERAL+";
    public static final String SASL_IR = "SASL-IR";
    public static final String UIDPLUS = "UIDPLUS";
    public static final String ID = "ID";
    public static final String IDLE = "IDLE";
    public static final String AUTH_PLAIN = "AUTH=PLAIN";
    public static final String AUTH_GSSAPI = "AUTH=GSSAPI";

    public static ImapCapabilities read(ImapInputStream is) throws IOException {
        ImapCapabilities caps = new ImapCapabilities();
        caps.readCapabilities(is);
        return caps;
    }

    private void readCapabilities(ImapInputStream is) throws IOException {
        is.skipSpaces();
        while (Chars.isAtomChar(is.peekChar())) {
            this.addCapability(is.readAtom().getName());
            is.skipSpaces();
        }
    }

    private void addCapability(String cap) {
        this.capabilities.add(new Atom(cap));
    }

    public boolean hasCapability(String cap) {
        return this.capabilities.contains(new Atom(cap));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        Iterator<Atom> it = this.capabilities.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(' ').append(it.next());
            }
        }
        return sb.append('}').toString();
    }
}

