/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDInfo
extends TreeMap<String, String> {
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String OS = "os";
    private static final String OS_VERSION = "os-version";
    private static final String VENDOR = "vendor";
    private static final String SUPPORT_URL = "support-url";
    private static final String ADDRESS = "address";
    private static final String DATE = "date";
    private static final String COMMAND = "command";
    private static final String ARGUMENTS = "arguments";
    private static final String ENVIRONMENT = "environment";

    public static IDInfo read(ImapInputStream is) throws IOException {
        is.skipSpaces();
        if (!is.match('(')) {
            is.skipNil();
            return null;
        }
        IDInfo info = new IDInfo();
        while (!is.match(')')) {
            String name = is.readString();
            is.skipChar(' ');
            String value = is.readNString();
            info.put(name, value);
            is.skipSpaces();
        }
        return info;
    }

    public IDInfo() {
        super(String.CASE_INSENSITIVE_ORDER);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public String getVersion() {
        return (String)this.get(VERSION);
    }

    public String getOs() {
        return (String)this.get(OS);
    }

    public String getOsVersion() {
        return (String)this.get(OS_VERSION);
    }

    public String getVendor() {
        return (String)this.get(VENDOR);
    }

    public String getSupportUrl() {
        return (String)this.get(SUPPORT_URL);
    }

    public String getAddress() {
        return (String)this.get(ADDRESS);
    }

    public String getDate() {
        return (String)this.get(DATE);
    }

    public String getCommmand() {
        return (String)this.get(COMMAND);
    }

    public String getArguments() {
        return (String)this.get(ARGUMENTS);
    }

    public String getEnvironment() {
        return (String)this.get(ENVIRONMENT);
    }

    public void setName(String name) {
        this.put(NAME, name);
    }

    public void setVersion(String version) {
        this.put(VERSION, version);
    }

    public void setOs(String os) {
        this.put(OS, os);
    }

    public void setOsVersion(String version) {
        this.put(OS_VERSION, version);
    }

    public void setVendor(String vendor) {
        this.put(VENDOR, vendor);
    }

    public void setSupportUrl(String url) {
        this.put(SUPPORT_URL, url);
    }

    public void setAddress(String address) {
        this.put(ADDRESS, address);
    }

    public void setDate(String date) {
        this.put(DATE, date);
    }

    public void setCommand(String command) {
        this.put(COMMAND, command);
    }

    public void setArguments(String args) {
        this.put(ARGUMENTS, args);
    }

    public void setEnvironment(String env) {
        this.put(ENVIRONMENT, env);
    }

    public List<ImapData> toRequestParam() {
        ArrayList<ImapData> data = new ArrayList<ImapData>(this.size());
        for (Map.Entry e : this.entrySet()) {
            data.add(ImapData.asString((String)e.getKey()));
            data.add(ImapData.asNString((String)e.getValue()));
        }
        return data;
    }
}

