/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import com.zimbra.cs.mailclient.imap.ImapOutputStream;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Flags
extends AbstractSet<Atom> {
    private int flagMask;
    private Set<Atom> otherFlags;
    private static final int MASK_ANSWERED = 1;
    private static final int MASK_FLAGGED = 2;
    private static final int MASK_DELETED = 4;
    private static final int MASK_SEEN = 8;
    private static final int MASK_DRAFT = 16;
    private static final int MASK_RECENT = 32;
    private static final int MASK_STAR = 64;
    private static final int MASK_NOSELECT = 128;
    private static final int MASK_MARKED = 256;
    private static final int MASK_UNMARKED = 512;
    private static final int MASK_NOINFERIORS = 1024;
    private static final CAtom[] FLAG_ATOMS = new CAtom[]{CAtom.F_ANSWERED, CAtom.F_FLAGGED, CAtom.F_DELETED, CAtom.F_SEEN, CAtom.F_DRAFT, CAtom.F_RECENT, CAtom.F_STAR, CAtom.F_NOSELECT, CAtom.F_MARKED, CAtom.F_UNMARKED, CAtom.F_NOINFERIORS};

    public static Flags read(ImapInputStream is) throws IOException {
        Flags flags = new Flags();
        is.skipSpaces();
        is.skipChar('(');
        is.skipSpaces();
        while (!is.match(')')) {
            flags.set(is.readFlag());
            is.skipSpaces();
        }
        return flags;
    }

    public static Flags fromSpec(String spec) throws IOException {
        Flags flags = new Flags();
        for (int i = 0; i < spec.length(); ++i) {
            flags.set(Flags.getMask(spec.charAt(i)));
        }
        return flags;
    }

    private static int getMask(char c) {
        switch (c) {
            case 'a': {
                return 1;
            }
            case 'f': {
                return 2;
            }
            case 'd': {
                return 4;
            }
            case 's': {
                return 8;
            }
            case 'r': {
                return 32;
            }
            case 't': {
                return 64;
            }
            case 'x': {
                return 16;
            }
        }
        throw new IllegalArgumentException("Invalid flag spec char '" + c + "'");
    }

    public void setAnswered() {
        this.set(1);
    }

    public void setFlagged() {
        this.set(2);
    }

    public void setDeleted() {
        this.set(4);
    }

    public void setSeen() {
        this.set(8);
    }

    public void setDraft() {
        this.set(16);
    }

    public void setRecent() {
        this.set(32);
    }

    public void set(String flag) {
        this.set(new Atom(flag));
    }

    public void set(Atom flag) {
        this.add(flag);
    }

    @Override
    public boolean add(Atom flag) {
        int mask = this.getMask(CAtom.get(flag));
        if (mask != 0) {
            boolean b = this.isSet(mask);
            this.set(mask);
            return b;
        }
        if (this.otherFlags == null) {
            this.otherFlags = new HashSet<Atom>();
        }
        return this.otherFlags.add(flag);
    }

    public void unsetAnswered() {
        this.unset(1);
    }

    public void unsetFlagged() {
        this.unset(2);
    }

    public void unsetDeleted() {
        this.unset(4);
    }

    public void unsetSeen() {
        this.unset(8);
    }

    public void unsetDraft() {
        this.unset(16);
    }

    public void unsetRecent() {
        this.unset(32);
    }

    public void unset(String flag) {
        this.unset(new Atom(flag));
    }

    public void unset(Atom flag) {
        this.remove(flag);
    }

    @Override
    public boolean remove(Object obj) {
        if (!(obj instanceof Atom)) {
            return false;
        }
        Atom flag = (Atom)obj;
        int mask = this.getMask(CAtom.get(flag));
        if (mask != 0) {
            boolean b = !this.isSet(mask);
            this.unset(mask);
            return b;
        }
        return this.otherFlags.remove(flag);
    }

    public boolean isAnswered() {
        return this.isSet(1);
    }

    public boolean isFlagged() {
        return this.isSet(2);
    }

    public boolean isDeleted() {
        return this.isSet(4);
    }

    public boolean isSeen() {
        return this.isSet(8);
    }

    public boolean isDraft() {
        return this.isSet(16);
    }

    public boolean isRecent() {
        return this.isSet(32);
    }

    public boolean isStar() {
        return this.isSet(64);
    }

    public boolean isNoselect() {
        return this.isSet(128);
    }

    public boolean isMarked() {
        return this.isSet(256);
    }

    public boolean isUnmarked() {
        return this.isSet(512);
    }

    public boolean isNoinferiors() {
        return this.isSet(1024);
    }

    public boolean isSet(String flag) {
        return this.isSet(new Atom(flag));
    }

    public boolean isSet(Atom flag) {
        return this.contains(flag);
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof Atom)) {
            return false;
        }
        Atom flag = (Atom)obj;
        int mask = this.getMask(CAtom.get(flag));
        return mask != 0 ? this.isSet(mask) : this.otherFlags != null && this.otherFlags.contains(flag);
    }

    @Override
    public int size() {
        int size = this.otherFlags != null ? this.otherFlags.size() : 0;
        return size + Flags.bitcount(this.flagMask);
    }

    @Override
    public Iterator<Atom> iterator() {
        ArrayList<Atom> flags = new ArrayList<Atom>(this.size());
        for (CAtom catom : FLAG_ATOMS) {
            if (!this.isSet(this.getMask(catom))) continue;
            flags.add(catom.atom());
        }
        if (this.otherFlags != null) {
            flags.addAll(this.otherFlags);
        }
        assert (flags.size() == this.size());
        return flags.iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        Iterator<Atom> it = this.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(' ').append(it.next());
            }
        }
        return sb.append(')').toString();
    }

    public void write(ImapOutputStream os) throws IOException {
        os.write(40);
        Iterator<Atom> it = this.iterator();
        if (it.hasNext()) {
            it.next().write(os);
            while (it.hasNext()) {
                os.write(32);
                it.next().write(os);
            }
        }
        os.write(41);
    }

    private void set(int mask) {
        this.flagMask |= mask;
    }

    private void unset(int mask) {
        this.flagMask &= ~mask;
    }

    private boolean isSet(int mask) {
        return (this.flagMask & mask) != 0;
    }

    private int getMask(CAtom catom) {
        switch (catom) {
            case F_ANSWERED: {
                return 1;
            }
            case F_FLAGGED: {
                return 2;
            }
            case F_DELETED: {
                return 4;
            }
            case F_SEEN: {
                return 8;
            }
            case F_DRAFT: {
                return 16;
            }
            case F_RECENT: {
                return 32;
            }
            case F_STAR: {
                return 64;
            }
            case F_NOSELECT: {
                return 128;
            }
        }
        return 0;
    }

    private static int bitcount(int n) {
        long tmp = (long)n & 0xFFFFFFFFL;
        tmp = tmp - (tmp >> 1 & 0xDB6DB6DBL) - (tmp >> 2 & 0x49249249L);
        return (int)((tmp + (tmp >> 3) & 0xC71C71C7L) % 63L);
    }
}

