/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.ImapInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class Envelope {
    private String date;
    private String subject;
    private Address[] from;
    private Address[] sender;
    private Address[] replyTo;
    private Address[] to;
    private Address[] cc;
    private Address[] bcc;
    private String inReplyTo;
    private String messageId;

    public static Envelope read(ImapInputStream is) throws IOException {
        Envelope env = new Envelope();
        env.readEnvelope(is);
        return env;
    }

    private void readEnvelope(ImapInputStream is) throws IOException {
        is.skipSpaces();
        is.skipChar('(');
        this.date = is.readNString();
        is.skipChar(' ');
        this.subject = is.readNString();
        is.skipChar(' ');
        this.from = Envelope.readAList(is);
        is.skipChar(' ');
        this.sender = Envelope.readAList(is);
        is.skipChar(' ');
        this.replyTo = Envelope.readAList(is);
        is.skipChar(' ');
        this.to = Envelope.readAList(is);
        is.skipChar(' ');
        this.cc = Envelope.readAList(is);
        is.skipChar(' ');
        this.bcc = Envelope.readAList(is);
        is.skipChar(' ');
        this.inReplyTo = is.readNString();
        is.skipChar(' ');
        this.messageId = is.readNString();
        is.skipSpaces();
        is.skipChar(')');
    }

    private static Address[] readAList(ImapInputStream is) throws IOException {
        is.skipSpaces();
        if (is.match('(')) {
            ArrayList<Address> addrs = new ArrayList<Address>();
            is.skipSpaces();
            while (!is.match(')')) {
                addrs.add(Envelope.readAddress(is));
                is.skipSpaces();
            }
            return addrs.toArray(new Address[addrs.size()]);
        }
        is.skipNil();
        return null;
    }

    private static Address readAddress(ImapInputStream is) throws IOException {
        is.skipChar('(');
        Address addr = new Address();
        addr.name = is.readNString();
        is.skipChar(' ');
        addr.adl = is.readNString();
        is.skipChar(' ');
        addr.host = is.readNString();
        is.skipChar(' ');
        addr.mailbox = is.readNString();
        is.skipSpaces();
        is.skipChar(')');
        return addr;
    }

    public String getDate() {
        return this.date;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Address[] getFrom() {
        return this.from;
    }

    public Address[] getSender() {
        return this.sender;
    }

    public Address[] getReplyTo() {
        return this.replyTo;
    }

    public Address[] getTo() {
        return this.to;
    }

    public Address[] getCc() {
        return this.cc;
    }

    public Address[] getBcc() {
        return this.bcc;
    }

    public String getInReplyTo() {
        return this.inReplyTo;
    }

    public static class Address {
        private String name;
        private String adl;
        private String host;
        private String mailbox;

        public String getName() {
            return this.name;
        }

        public String getAdl() {
            return this.adl;
        }

        public String getHost() {
            return this.host;
        }

        public String getMailbox() {
            return this.mailbox;
        }
    }
}

