/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import com.zimbra.cs.mailclient.imap.ImapUtil;
import java.io.IOException;

public final class CopyResult {
    private final long uidValidity;
    private final long[] fromUids;
    private final long[] toUids;

    public static CopyResult parse(ImapInputStream is) throws IOException {
        is.skipChar(' ');
        long uidValidity = is.readNZNumber();
        is.skipChar(' ');
        is.skipSpaces();
        String fromSet = is.readText(" ");
        is.skipChar(' ');
        is.skipSpaces();
        String toSet = is.readText(" ]");
        try {
            return new CopyResult(uidValidity, fromSet, toSet);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Invalid COPYUID result");
        }
    }

    private CopyResult(long uidValidity, String fromUidSet, String toUidSet) {
        this.uidValidity = uidValidity;
        this.fromUids = ImapUtil.parseUidSet(fromUidSet);
        this.toUids = ImapUtil.parseUidSet(toUidSet);
        if (this.fromUids.length != this.toUids.length) {
            throw new IllegalArgumentException();
        }
    }

    public long getUidValidity() {
        return this.uidValidity;
    }

    public long[] getFromUids() {
        return this.fromUids;
    }

    public long[] getToUids() {
        return this.toUids;
    }
}

