/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

public final class Chars {
    public static final boolean[] ATOM_CHARS;
    public static final boolean[] ASTRING_CHARS;
    public static final boolean[] TAG_CHARS;
    public static final boolean[] FETCH_CHARS;
    public static final boolean[] NUMBER_CHARS;
    public static final boolean[] TEXT_CHARS;
    private static final String QUOTED_SPECIALS = "\"\\";
    private static final String ASTRING_SPECIALS = "(){%*\"\\";
    private static final String ATOM_SPECIALS = "(){%*\"\\]";

    private static void set(boolean[] ba, String chars, boolean b) {
        for (int i = 0; i < chars.length(); ++i) {
            ba[chars.charAt((int)i)] = b;
        }
    }

    public static boolean isNumber(char c) {
        return c < '\u0100' && NUMBER_CHARS[c];
    }

    public static boolean isTextChar(char c) {
        return c < '\u0100' && TEXT_CHARS[c];
    }

    public static boolean isAtomChar(char c) {
        return c < '\u0100' && ATOM_CHARS[c];
    }

    public static boolean isAStringChar(char c) {
        return c < '\u0100' && ASTRING_CHARS[c];
    }

    public static boolean isQuotedSpecialChar(char c) {
        return c == '\\' || c == '\"';
    }

    public static boolean isNumber(String s) {
        return Chars.isValid(s, NUMBER_CHARS);
    }

    public static boolean isTag(String s) {
        return Chars.isValid(s, TAG_CHARS);
    }

    public static boolean isAtom(String s) {
        return Chars.isValid(s, ATOM_CHARS);
    }

    public static boolean isText(String s) {
        return Chars.isValid(s, TEXT_CHARS);
    }

    public static long getNumber(String s) {
        long n = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Chars.isNumber(c)) {
                return -1L;
            }
            if ((n = n * 10L + (long)(c - 48)) <= 0xFFFFFFFFL) continue;
            return -1L;
        }
        return n;
    }

    public static boolean isValid(String s, boolean[] chars) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= '\u00ff' && chars[c]) continue;
            return false;
        }
        return true;
    }

    static {
        int i;
        ATOM_CHARS = new boolean[256];
        ASTRING_CHARS = new boolean[256];
        TAG_CHARS = new boolean[256];
        FETCH_CHARS = new boolean[256];
        NUMBER_CHARS = new boolean[256];
        TEXT_CHARS = new boolean[256];
        for (i = 33; i < 127; ++i) {
            Chars.FETCH_CHARS[i] = true;
            Chars.TAG_CHARS[i] = true;
            Chars.ASTRING_CHARS[i] = true;
            Chars.ATOM_CHARS[i] = true;
        }
        for (i = 1; i < 128; ++i) {
            Chars.TEXT_CHARS[i] = true;
        }
        Chars.set(ATOM_CHARS, ATOM_SPECIALS, false);
        Chars.set(ASTRING_CHARS, ASTRING_SPECIALS, false);
        Chars.set(TAG_CHARS, "(){%*\"\\+", false);
        Chars.set(FETCH_CHARS, "(){%*\"\\][]", false);
        Chars.set(NUMBER_CHARS, "0123456789", true);
        Chars.set(TEXT_CHARS, "\u0000\r\n", false);
    }
}

