/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.Envelope;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyStructure {
    private String type;
    private String subtype;
    private Map<String, String> params;
    private String id;
    private String description;
    private String encoding;
    private long size = -1L;
    private long lines = -1L;
    private Envelope envelope;
    private BodyStructure[] parts;
    private String md5;
    private String disposition;
    private Map<String, String> dispositionParams;
    private String[] language;
    private String location;

    public static BodyStructure read(ImapInputStream is, boolean ext) throws IOException {
        BodyStructure bs = new BodyStructure();
        is.skipSpaces();
        is.skipChar('(');
        is.skipSpaces();
        if (is.peek() == 40) {
            bs.readMPart(is, ext);
        } else {
            bs.read1Part(is, ext);
        }
        is.skipSpaces();
        is.skipChar(')');
        return bs;
    }

    private void read1Part(ImapInputStream is, boolean ext) throws IOException {
        this.type = is.readString().toUpperCase();
        is.skipChar(' ');
        this.subtype = is.readString().toUpperCase();
        is.skipChar(' ');
        this.readFields(is);
        if (this.type.equals("TEXT")) {
            is.skipChar(' ');
            this.lines = is.readNumber();
        } else if (this.type.equals("MESSAGE") && this.subtype.equals("RFC822")) {
            is.skipChar(' ');
            this.envelope = Envelope.read(is);
            is.skipChar(' ');
            this.parts = new BodyStructure[]{BodyStructure.read(is, ext)};
            is.skipChar(' ');
            this.lines = is.readNumber();
        }
        if (ext && is.match(' ')) {
            this.md5 = is.readNString();
            if (is.match(' ')) {
                this.readExt(is);
            }
        }
    }

    private void readMPart(ImapInputStream is, boolean ext) throws IOException {
        this.type = "MULTIPART";
        ArrayList<BodyStructure> parts = new ArrayList<BodyStructure>();
        while (is.peekChar() == '(') {
            parts.add(BodyStructure.read(is, ext));
            is.skipSpaces();
        }
        this.subtype = is.readString().toUpperCase();
        if (ext && is.match(' ')) {
            this.params = BodyStructure.readParams(is);
            if (is.match(' ')) {
                is.skipSpaces();
                this.readExt(is);
            }
        }
        this.parts = parts.toArray(new BodyStructure[parts.size()]);
    }

    private void readExt(ImapInputStream is) throws IOException {
        is.skipSpaces();
        if (is.match('(')) {
            this.disposition = is.readString();
            is.skipChar(' ');
            is.skipSpaces();
            this.dispositionParams = BodyStructure.readParams(is);
            is.skipSpaces();
            is.skipChar(')');
        } else {
            is.skipNil();
        }
        if (is.match(' ')) {
            is.skipSpaces();
            this.language = BodyStructure.readLang(is);
            if (is.match(' ')) {
                this.location = is.readNString();
                while (is.match(' ')) {
                    BodyStructure.skipExtData(is);
                }
            }
        }
    }

    private void readFields(ImapInputStream is) throws IOException {
        this.params = BodyStructure.readParams(is);
        is.skipChar(' ');
        this.id = is.readNString();
        is.skipChar(' ');
        this.description = is.readNString();
        is.skipChar(' ');
        this.encoding = is.readString();
        is.skipChar(' ');
        this.size = is.readNumber();
    }

    private static Map<String, String> readParams(ImapInputStream is) throws IOException {
        is.skipSpaces();
        if (!is.match('(')) {
            is.skipNil();
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        is.skipSpaces();
        while (!is.match(')')) {
            String name = is.readString().toLowerCase();
            is.skipChar(' ');
            String value = is.readString();
            params.put(name, value);
        }
        return params;
    }

    private static void skipExtData(ImapInputStream is) throws IOException {
        if (is.match('(')) {
            is.skipSpaces();
            while (!is.match(')')) {
                BodyStructure.skipExtData(is);
                is.skipSpaces();
            }
        } else {
            is.readAStringData();
        }
    }

    private static String[] readLang(ImapInputStream is) throws IOException {
        if (is.peek() != 40) {
            String[] stringArray;
            String lang = is.readNString();
            if (lang != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = lang;
            } else {
                stringArray = null;
            }
            return stringArray;
        }
        is.skipChar('(');
        ArrayList<String> lang = new ArrayList<String>();
        is.skipSpaces();
        while (!is.match(')')) {
            lang.add(is.readString());
            is.skipSpaces();
        }
        return lang.toArray(new String[lang.size()]);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return this.params;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getSize() {
        return this.size;
    }

    public long getLines() {
        return this.lines;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public BodyStructure[] getParts() {
        return this.parts;
    }

    public String getMd5() {
        return this.md5;
    }

    public String[] getLanguage() {
        return this.language;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public Map<String, String> getDispositionParameters() {
        return this.dispositionParams;
    }

    public boolean isMultipart() {
        return "MULTIPART".equals(this.type);
    }

    public String toString() {
        Formatter fmt = new Formatter();
        this.toString(fmt, 0, 0);
        return fmt.toString();
    }

    private void toString(Formatter fmt, int depth, int count) {
        fmt.format("%s%d: type=%s/%s encoding=%s disposition=%s", this.spaces(depth), count, this.type, this.subtype, this.encoding, this.disposition);
        if (this.parts != null) {
            fmt.format(" count=%d\n", this.parts.length);
            for (int i = 0; i < this.parts.length; ++i) {
                this.toString(fmt, depth + 1, i);
            }
        } else {
            fmt.format(" size=%d\n", this.size);
        }
    }

    private String spaces(int depth) {
        char[] spaces = new char[depth * 4];
        Arrays.fill(spaces, ' ');
        return new String(spaces);
    }
}

