/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import java.io.IOException;
import java.util.ArrayList;

public final class Body {
    private String part;
    private CAtom section;
    private String[] fieldNames;
    private long origin = -1L;
    private Object data;

    public static Body read(ImapInputStream is) throws IOException {
        Body b = new Body();
        b.readBody(is);
        return b;
    }

    private void readBody(ImapInputStream is) throws IOException {
        is.skipSpaces();
        is.skipChar('[');
        is.skipSpaces();
        if (is.peekChar() != ']') {
            this.readSection(is);
        }
        is.skipSpaces();
        is.skipChar(']');
        is.skipSpaces();
        if (is.match('<')) {
            this.origin = is.readNZNumber();
            is.skipSpaces();
            is.skipChar('>');
        }
        this.data = is.readFetchData();
    }

    private void readSection(ImapInputStream is) throws IOException {
        if (is.isNumber()) {
            this.part = Body.readPart(is);
        }
        is.skipSpaces();
        if (is.peek() == 93) {
            return;
        }
        Atom sec = is.readAtom();
        this.section = sec.getCAtom();
        switch (this.section) {
            case HEADER: 
            case TEXT: {
                break;
            }
            case HEADER_FIELDS: 
            case HEADER_FIELDS_NOT: {
                is.skipChar(' ');
                is.skipSpaces();
                this.fieldNames = Body.readFieldNames(is);
                break;
            }
            case MIME: {
                if (this.part != null) break;
                throw new ParseException("BODY[MIME] response missing section part");
            }
            default: {
                throw new ParseException("Invalid BODY section type: " + sec);
            }
        }
    }

    private static String readPart(ImapInputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            sb.append(is.readNZNumber());
            if (is.peek() == 93) break;
            is.skipChar('.');
            if (!is.isNumber()) break;
            sb.append('.');
        }
        return sb.toString();
    }

    private static String[] readFieldNames(ImapInputStream is) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        is.skipChar('(');
        is.skipSpaces();
        while (!is.match(')')) {
            names.add(is.readAString());
            is.skipSpaces();
        }
        return names.toArray(new String[names.size()]);
    }

    public String getPart() {
        return this.part;
    }

    public CAtom getSection() {
        return this.section;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public long getOrigin() {
        return this.origin;
    }

    public Object getData() {
        return this.data;
    }

    public ImapData getImapData() {
        if (this.data != null && !(this.data instanceof ImapData)) {
            throw new UnsupportedOperationException();
        }
        return (ImapData)this.data;
    }

    public void dispose() {
        if (this.data instanceof ImapData) {
            ((ImapData)this.data).dispose();
        }
    }
}

