/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.Chars;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.util.Ascii;
import java.io.IOException;
import java.io.OutputStream;

public final class Atom
extends ImapData {
    private final String name;
    public static final Atom NIL = new Atom("nil");

    public Atom(String name) {
        this.name = name;
    }

    public ImapData.Type getType() {
        return ImapData.Type.ATOM;
    }

    public String getName() {
        return this.name;
    }

    public CAtom getCAtom() {
        return CAtom.get(this);
    }

    public boolean isNumber() {
        return Chars.isNumber(this.name);
    }

    public long getNumber() {
        return Chars.getNumber(this.name);
    }

    public int getSize() {
        return this.name.length();
    }

    public byte[] getBytes() {
        return Ascii.getBytes(this.name);
    }

    public void write(OutputStream os) throws IOException {
        Ascii.write(os, this.name);
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj.getClass() == Atom.class && this.name.equalsIgnoreCase(((Atom)obj).name);
    }

    public String toString() {
        return this.name;
    }
}

