/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import com.zimbra.cs.mailclient.imap.ImapUtil;
import java.io.IOException;

public final class AppendResult {
    private final long uidValidity;
    private final long[] uids;

    public static AppendResult parse(ImapInputStream is) throws IOException {
        is.skipChar(' ');
        long uidValidity = is.readNZNumber();
        is.skipChar(' ');
        is.skipSpaces();
        String uidSet = is.readText(" ]");
        try {
            return new AppendResult(uidValidity, uidSet);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Invalid APPENDUID result");
        }
    }

    private AppendResult(long uidValidity, String uidSet) {
        this.uidValidity = uidValidity;
        this.uids = ImapUtil.parseUidSet(uidSet);
    }

    public long getUidValidity() {
        return this.uidValidity;
    }

    public long[] getUids() {
        return this.uids;
    }

    public long getUid() {
        return this.uids[0];
    }
}

