/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.Quoted;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendMessage {
    private Flags flags;
    private Date date;
    private List<Object> parts = new ArrayList<Object>();

    public AppendMessage() {
    }

    public AppendMessage(Flags flags, Date date, Object ... parts) {
        this.flags(flags).date(date);
        for (Object part : parts) {
            this.part(part);
        }
    }

    public AppendMessage flags(Flags flags) {
        this.flags = flags;
        return this;
    }

    public AppendMessage date(Date date) {
        this.date = date;
        return this;
    }

    public AppendMessage part(Object obj) {
        if (!(obj instanceof String) && !(obj instanceof Literal)) {
            throw new IllegalArgumentException("APPEND part must be url or literal");
        }
        this.parts.add(obj);
        return this;
    }

    boolean isCatenate() {
        return this.parts.size() > 1 || !this.parts.isEmpty() && this.parts.get(0) instanceof String;
    }

    public Flags flags() {
        return this.flags;
    }

    public Date date() {
        return this.date;
    }

    public List<Object> parts() {
        return this.parts;
    }

    public List<Object> getData() {
        ArrayList<Object> data = new ArrayList<Object>();
        if (this.flags != null) {
            data.add(this.flags);
        }
        if (this.date != null) {
            data.add(this.date);
        }
        if (this.isCatenate()) {
            data.add((Object)CAtom.CATENATE);
            ArrayList<Object> list = new ArrayList<Object>(this.parts.size());
            for (Object part : this.parts) {
                if (part instanceof String) {
                    list.add((Object)CAtom.URL);
                    list.add(new Quoted((String)part));
                    continue;
                }
                list.add((Object)CAtom.TEXT);
                list.add(part);
            }
            data.add(list);
        } else {
            data.addAll(this.parts);
        }
        return data;
    }
}

