/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.auth;

import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.auth.Authenticator;
import com.zimbra.cs.security.sasl.SaslInputStream;
import com.zimbra.cs.security.sasl.SaslOutputStream;
import com.zimbra.cs.security.sasl.SaslSecurityLayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SaslAuthenticator
extends Authenticator {
    private MailConfig config;
    private String password;
    private LoginContext loginContext;
    private Subject subject;
    private SaslClient saslClient;
    public static final String MECHANISM_GSSAPI = "GSSAPI";
    public static final String MECHANISM_PLAIN = "PLAIN";
    public static final String MECHANISM_CRAM_MD5 = "CRAM-MD5";
    public static final String QOP_AUTH = "auth";
    public static final String QOP_AUTH_CONF = "auth-conf";
    public static final String QOP_AUTH_INT = "auth-int";
    private static final String LOGIN_MODULE_NAME = "com.sun.security.auth.module.Krb5LoginModule";

    public void init(MailConfig config, String password) throws LoginException, SaslException {
        this.config = config;
        this.password = password;
        String mechanism = config.getMechanism();
        SaslAuthenticator.checkRequired("mechanism", mechanism);
        SaslAuthenticator.checkRequired("host", config.getHost());
        SaslAuthenticator.checkRequired("protocol", config.getProtocol());
        SaslAuthenticator.checkRequired("authentication id", config.getAuthenticationId());
        this.saslClient = mechanism.equals(MECHANISM_GSSAPI) ? this.createGssSaslClient() : this.createSaslClient();
        Map<String, String> props = config.getSaslProperties();
        String qop = QOP_AUTH;
        if (props != null) {
            qop = props.get("javax.security.sasl.qop");
        }
        this.debug("Requested QOP is %s", qop != null ? qop : QOP_AUTH);
    }

    public String getMechanism() {
        return this.config.getMechanism();
    }

    private static void checkRequired(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Missing required " + name);
        }
    }

    private SaslClient createGssSaslClient() throws LoginException, SaslException {
        this.loginContext = this.getLoginContext();
        this.loginContext.login();
        this.subject = this.loginContext.getSubject();
        this.debug("GSS subject = %s", this.subject);
        try {
            return (SaslClient)Subject.doAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws SaslException {
                    return SaslAuthenticator.this.createSaslClient();
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.dispose();
            Exception cause = e.getException();
            if (cause instanceof SaslException) {
                throw (SaslException)cause;
            }
            if (cause instanceof LoginException) {
                throw (LoginException)cause;
            }
            throw new IllegalStateException("Error initialization GSS authenticator", e);
        }
    }

    private LoginContext getLoginContext() throws LoginException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("debug", Boolean.toString(this.config.isDebug()));
        options.put("principal", this.getPrincipal());
        final AppConfigurationEntry ace = new AppConfigurationEntry(LOGIN_MODULE_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        Configuration config = new Configuration(){

            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{ace};
            }

            public void refresh() {
            }
        };
        return new LoginContext("krb5", null, new SaslCallbackHandler(), config);
    }

    private String getPrincipal() {
        String realm = this.config.getRealm();
        String authenticationId = this.config.getAuthenticationId();
        return realm != null && authenticationId.indexOf(64) == -1 ? authenticationId + '@' + realm : authenticationId;
    }

    private SaslClient createSaslClient() throws SaslException {
        return Sasl.createSaslClient(new String[]{this.config.getMechanism()}, this.config.getAuthorizationId(), this.config.getProtocol(), this.config.getHost(), this.config.getSaslProperties(), new SaslCallbackHandler());
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.isComplete()) {
            throw new IllegalStateException("Authentication already completed");
        }
        return this.subject != null ? this.evaluateGssChallenge(challenge) : this.saslClient.evaluateChallenge(challenge);
    }

    private byte[] evaluateGssChallenge(final byte[] challenge) throws SaslException {
        try {
            return (byte[])Subject.doAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws SaslException {
                    return SaslAuthenticator.this.saslClient.evaluateChallenge(challenge);
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.dispose();
            Throwable cause = e.getCause();
            if (cause instanceof SaslException) {
                throw (SaslException)cause;
            }
            throw new IllegalStateException("Unknown authentication error", cause);
        }
    }

    public byte[] getInitialResponse() throws SaslException {
        if (!this.hasInitialResponse()) {
            throw new IllegalStateException("Mechanism does not support initial response");
        }
        return this.saslClient.evaluateChallenge(new byte[0]);
    }

    public boolean hasInitialResponse() {
        return this.saslClient.hasInitialResponse();
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    public boolean isEncryptionEnabled() {
        return SaslSecurityLayer.getInstance(this.saslClient).isEnabled();
    }

    public OutputStream wrap(OutputStream os) {
        return this.isEncryptionEnabled() ? new SaslOutputStream(os, this.saslClient) : os;
    }

    public InputStream unwrap(InputStream is) {
        return this.isEncryptionEnabled() ? new SaslInputStream(is, this.saslClient) : is;
    }

    public String getNegotiatedProperty(String name) {
        return (String)this.saslClient.getNegotiatedProperty(name);
    }

    public void dispose() throws SaslException {
        this.saslClient.dispose();
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException e) {
                e.printStackTrace();
            }
            this.loginContext = null;
        }
    }

    private void debug(String format, Object ... args) {
        if (this.config.isDebug()) {
            System.out.printf("[SaslAuthenticator] " + format + "\n", args);
        }
    }

    private class SaslCallbackHandler
    implements CallbackHandler {
        private SaslCallbackHandler() {
        }

        public void handle(Callback[] cbs) throws IOException, UnsupportedCallbackException {
            for (Callback cb : cbs) {
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(SaslAuthenticator.this.config.getAuthenticationId());
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    if (SaslAuthenticator.this.password == null) {
                        throw new IllegalStateException("Password missing but required");
                    }
                    ((PasswordCallback)cb).setPassword(SaslAuthenticator.this.password.toCharArray());
                    SaslAuthenticator.this.password = null;
                    continue;
                }
                if (cb instanceof RealmCallback) {
                    String realm = SaslAuthenticator.this.config.getRealm();
                    if (realm == null) {
                        throw new IllegalStateException("Realm missing but required");
                    }
                    ((RealmCallback)cb).setText(realm);
                    continue;
                }
                throw new UnsupportedCallbackException(cb);
            }
        }
    }
}

