/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.auth;

import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.auth.Authenticator;
import com.zimbra.cs.mailclient.auth.SaslAuthenticator;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticatorFactory {
    private Map<String, Info> authenticators = new HashMap<String, Info>();
    private static final AuthenticatorFactory DEFAULT = new AuthenticatorFactory();

    public static AuthenticatorFactory getDefault() {
        return DEFAULT;
    }

    public AuthenticatorFactory() {
        this.register("PLAIN", SaslAuthenticator.class);
        this.register("GSSAPI", SaslAuthenticator.class, false);
        this.register("CRAM-MD5", SaslAuthenticator.class);
    }

    public Authenticator newAuthenticator(MailConfig config, String password) throws LoginException, SaslException {
        Authenticator auth;
        String mechanism = config.getMechanism();
        if (mechanism == null) {
            throw new IllegalArgumentException("Missing required mechanism");
        }
        Info info = this.authenticators.get(mechanism);
        if (info == null) {
            return null;
        }
        try {
            auth = (Authenticator)info.clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate class: " + info.clazz, e);
        }
        auth.init(config, password);
        return auth;
    }

    public boolean isPasswordRequired(String mechanism) {
        Info info = this.authenticators.get(mechanism);
        return info != null && info.passwordRequired;
    }

    public Authenticator newAuthenticator(MailConfig config) throws LoginException, SaslException {
        return this.newAuthenticator(config, null);
    }

    public void register(String mechanism, Class<? extends Authenticator> clazz, boolean passwordRequired) {
        Info info = new Info();
        info.clazz = clazz;
        info.passwordRequired = passwordRequired;
        this.authenticators.put(mechanism, info);
    }

    public void register(String mechanism, Class<? extends Authenticator> clazz) {
        this.register(mechanism, clazz, true);
    }

    private static class Info {
        Class clazz;
        boolean passwordRequired;

        private Info() {
        }
    }
}

