/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class MailInputStream
extends InputStream {
    protected final InputStream in;
    protected final StringBuilder sbuf;
    private int nextByte = -1;

    public MailInputStream(InputStream is) {
        this.in = is;
        this.sbuf = new StringBuilder(132);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.nextByte != -1) {
            b[off++] = (byte)this.nextByte;
            this.nextByte = -1;
            return (len = this.in.read(b, off, len - 1)) != -1 ? len + 1 : 1;
        }
        return this.in.read(b, off, len);
    }

    public String readLine() throws IOException {
        this.sbuf.setLength(0);
        int c = this.read();
        if (c == -1) {
            return null;
        }
        while (c != 10 && c != -1) {
            this.sbuf.append((char)c);
            c = this.read();
        }
        int len = this.sbuf.length();
        if (len > 0 && this.sbuf.charAt(len - 1) == '\r') {
            this.sbuf.setLength(len - 1);
        }
        return this.sbuf.toString();
    }

    public int read() throws IOException {
        if (this.nextByte != -1) {
            int b = this.nextByte;
            this.nextByte = -1;
            return b;
        }
        return this.in.read();
    }

    public int peek() throws IOException {
        if (this.nextByte == -1) {
            this.nextByte = this.in.read();
        }
        return this.nextByte;
    }

    public char readChar() throws IOException {
        int c = this.read();
        if (c == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        return (char)c;
    }

    public char peekChar() throws IOException {
        int c = this.peek();
        if (c == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        return (char)c;
    }

    public boolean isEOF() throws IOException {
        return this.peek() == -1;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (this.nextByte != -1) {
            this.nextByte = -1;
            return this.in.skip(n - 1L) + 1L;
        }
        return this.in.skip(n);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

