/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient;

import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.MailInputStream;
import com.zimbra.cs.mailclient.MailOutputStream;
import com.zimbra.cs.mailclient.auth.Authenticator;
import com.zimbra.cs.mailclient.auth.AuthenticatorFactory;
import com.zimbra.cs.mailclient.util.Ascii;
import com.zimbra.cs.mailclient.util.TraceInputStream;
import com.zimbra.cs.mailclient.util.TraceOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class MailConnection {
    protected MailConfig config;
    protected Socket socket;
    protected Authenticator authenticator;
    protected TraceInputStream traceIn;
    protected TraceOutputStream traceOut;
    protected MailInputStream mailIn;
    protected MailOutputStream mailOut;
    protected State state = State.CLOSED;
    protected String greeting;

    protected MailConnection(MailConfig config) {
        this.config = config;
        if (config.isDebug()) {
            this.getLogger().setLevel(Level.DEBUG);
        }
    }

    public synchronized void connect() throws IOException {
        if (!this.isClosed()) {
            return;
        }
        try {
            this.socket = this.newSocket();
            this.initStreams(new BufferedInputStream(this.socket.getInputStream()), new BufferedOutputStream(this.socket.getOutputStream()));
            this.processGreeting();
            switch (this.config.getSecurity()) {
                case TLS: {
                    this.startTls();
                    break;
                }
                case TLS_IF_AVAILABLE: {
                    try {
                        this.startTls();
                        break;
                    }
                    catch (CommandFailedException e) {
                        this.getLogger().debug((Object)"STARTTLS failed", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private void startTls() throws IOException {
        this.checkState(State.NOT_AUTHENTICATED);
        this.sendStartTls();
        SSLSocket sock = this.newSSLSocket(this.socket);
        sock.startHandshake();
        this.initStreams(sock.getInputStream(), sock.getOutputStream());
    }

    private void initStreams(InputStream is, OutputStream os) throws IOException {
        if (this.config.isTrace()) {
            this.traceIn = this.newTraceInputStream(is);
            is = this.traceIn;
            this.traceOut = this.newTraceOutputStream(os);
            os = this.traceOut;
        }
        this.mailIn = this.newMailInputStream(is);
        this.mailOut = this.newMailOutputStream(os);
    }

    protected abstract void processGreeting() throws IOException;

    protected abstract void sendLogin(String var1, String var2) throws IOException;

    protected abstract void sendAuthenticate(boolean var1) throws IOException;

    protected abstract void sendStartTls() throws IOException;

    protected abstract MailInputStream newMailInputStream(InputStream var1);

    protected abstract MailOutputStream newMailOutputStream(OutputStream var1);

    public abstract Logger getLogger();

    public abstract void logout() throws IOException;

    public synchronized void login(String pass) throws IOException {
        if (pass == null) {
            throw new NullPointerException("password");
        }
        this.checkState(State.NOT_AUTHENTICATED);
        String user = this.config.getAuthenticationId();
        if (user == null) {
            throw new IllegalStateException("Authentication id missing");
        }
        this.sendLogin(user, pass);
        this.setState(State.AUTHENTICATED);
    }

    public synchronized void authenticate(String pass) throws LoginException, IOException {
        String mech = this.config.getMechanism();
        if (mech == null || mech.equalsIgnoreCase("LOGIN")) {
            this.login(pass);
        } else {
            this.authenticate(this.newAuthenticator(pass));
        }
    }

    public synchronized void authenticate(Authenticator auth) throws LoginException, IOException {
        this.authenticator = auth;
        this.checkState(State.NOT_AUTHENTICATED);
        this.sendAuthenticate(false);
        if (this.authenticator.isEncryptionEnabled()) {
            this.initStreams(this.authenticator.unwrap(this.socket.getInputStream()), this.authenticator.wrap(this.socket.getOutputStream()));
        }
        this.setState(State.AUTHENTICATED);
    }

    private Authenticator newAuthenticator(String pass) throws LoginException, SaslException {
        AuthenticatorFactory af = this.config.getAuthenticatorFactory();
        if (af == null) {
            af = AuthenticatorFactory.getDefault();
        }
        return af.newAuthenticator(this.config, pass);
    }

    public String getGreeting() {
        return this.greeting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContinuation(String s) throws IOException {
        byte[] decoded = Base64.decodeBase64((byte[])Ascii.getBytes(s));
        byte[] request = this.authenticator.evaluateChallenge(decoded);
        String data = Ascii.toString(Base64.encodeBase64((byte[])request));
        if (this.traceOut != null && this.traceOut.suspendTrace("<authentication data>\n")) {
            try {
                this.mailOut.writeLine(data);
                Object var6_5 = null;
                this.traceOut.resumeTrace();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.traceOut.resumeTrace();
                throw throwable;
            }
        } else {
            this.mailOut.writeLine(data);
        }
        this.mailOut.flush();
    }

    public String getNegotiatedQop() {
        return this.authenticator != null ? this.authenticator.getNegotiatedProperty("javax.security.sasl.qop") : null;
    }

    public void setTraceEnabled(boolean enabled) {
        if (this.traceIn != null) {
            this.traceIn.setEnabled(enabled);
        }
        if (this.traceOut != null) {
            this.traceOut.setEnabled(enabled);
        }
    }

    public MailInputStream getInputStream() {
        return this.mailIn;
    }

    public MailOutputStream getOutputStream() {
        return this.mailOut;
    }

    public MailConfig getConfig() {
        return this.config;
    }

    public void setReadTimeout(int readTimeout) throws SocketException {
        int timeout = (int)Math.min((long)readTimeout * 1000L, Integer.MAX_VALUE);
        if (this.socket != null && !this.isClosed()) {
            this.socket.setSoTimeout(timeout > 0 ? timeout : Integer.MAX_VALUE);
        }
    }

    public synchronized boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public synchronized boolean isAuthenticated() {
        return this.state == State.AUTHENTICATED;
    }

    public synchronized boolean isLogout() {
        return this.state == State.LOGOUT;
    }

    protected synchronized void setState(State state) {
        if (this.state != state) {
            this.getLogger().debug((Object)("setState: " + (Object)((Object)this.state) + " -> " + (Object)((Object)state)));
            this.state = state;
        }
    }

    protected void checkState(State expected) {
        if (this.state != expected) {
            throw new IllegalStateException("Operation not supported in " + (Object)((Object)this.state) + " state");
        }
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.setState(State.CLOSED);
        try {
            this.mailIn.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.mailOut.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.getLogger().info((Object)"Error while closing connection", (Throwable)e);
        }
        if (this.authenticator != null) {
            try {
                this.authenticator.dispose();
            }
            catch (SaslException e) {
                this.getLogger().debug((Object)"Error while deleting authenticator", (Throwable)e);
            }
        }
    }

    private Socket newSocket() throws IOException {
        SocketFactory sf = this.config.getSecurity() == MailConfig.Security.SSL ? this.getSSLSocketFactory() : SocketFactory.getDefault();
        Socket sock = sf.createSocket();
        int connectTimeout = (int)Math.min((long)this.config.getConnectTimeout() * 1000L, Integer.MAX_VALUE);
        sock.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), connectTimeout > 0 ? connectTimeout : Integer.MAX_VALUE);
        int readTimeout = (int)Math.min((long)this.config.getReadTimeout() * 1000L, Integer.MAX_VALUE);
        sock.setSoTimeout(readTimeout > 0 ? readTimeout : Integer.MAX_VALUE);
        return sock;
    }

    private SSLSocket newSSLSocket(Socket sock) throws IOException {
        return (SSLSocket)this.getSSLSocketFactory().createSocket(sock, sock.getInetAddress().getHostName(), sock.getPort(), false);
    }

    private SSLSocketFactory getSSLSocketFactory() {
        SSLSocketFactory ssf = this.config.getSSLSocketFactory();
        return ssf != null ? ssf : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    private TraceInputStream newTraceInputStream(InputStream is) {
        return new TraceInputStream(is, this.config.getTraceOut());
    }

    private TraceOutputStream newTraceOutputStream(OutputStream os) {
        return new TraceOutputStream(os, this.config.getTraceOut());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        CLOSED,
        NOT_AUTHENTICATED,
        AUTHENTICATED,
        SELECTED,
        LOGOUT;

    }
}

