/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient;

import com.zimbra.cs.mailclient.auth.AuthenticatorFactory;
import com.zimbra.cs.mailclient.util.Config;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailConfig {
    private String host;
    private int port = -1;
    private Security security;
    private String authorizationId;
    private String authenticationId;
    private String mechanism;
    private String realm;
    private Map<String, String> saslProperties;
    private boolean debug;
    private boolean trace;
    private PrintStream traceOut = System.out;
    private SSLSocketFactory sslSocketFactory;
    private AuthenticatorFactory authenticatorFactory;
    private int readTimeout;
    private int connectTimeout;

    protected MailConfig() {
        this.authenticationId = System.getProperty("user.name");
        this.security = Security.NONE;
    }

    protected MailConfig(String host) {
        this();
        this.host = host;
    }

    public abstract String getProtocol();

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        if (security == null) {
            throw new NullPointerException();
        }
        this.security = security;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sf) {
        this.sslSocketFactory = sf;
    }

    public String getAuthenticationId() {
        return this.authenticationId;
    }

    public void setAuthenticationId(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.authenticationId = id;
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setAuthorizationId(String id) {
        this.authorizationId = id;
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(String mech) {
        this.mechanism = mech;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Map<String, String> getSaslProperties() {
        return this.saslProperties;
    }

    public void setSaslProperties(Map<String, String> properties) {
        this.saslProperties = properties;
    }

    public AuthenticatorFactory getAuthenticatorFactory() {
        return this.authenticatorFactory;
    }

    public void setAuthenticatorFactory(AuthenticatorFactory factory) {
        this.authenticatorFactory = factory;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int secs) {
        this.readTimeout = secs;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int secs) {
        this.connectTimeout = secs;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean enabled) {
        this.debug = enabled;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean enabled) {
        this.trace = enabled;
    }

    public PrintStream getTraceOut() {
        return this.traceOut;
    }

    public void setTraceStream(PrintStream ps) {
        if (ps == null) {
            throw new NullPointerException();
        }
        this.traceOut = ps;
    }

    public Properties toProperties() {
        return Config.toProperties(this);
    }

    public void applyProperties(Properties props) {
        Config.applyProperties(this, props);
    }

    public void save(File file) throws IOException {
        Config.saveProperties(file, this.toProperties());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Security {
        NONE,
        SSL,
        TLS,
        TLS_IF_AVAILABLE;

    }
}

