/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient;

import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.MailConnection;
import com.zimbra.cs.mailclient.MailInputStream;
import com.zimbra.cs.mailclient.MailOutputStream;
import com.zimbra.cs.mailclient.auth.AuthenticatorFactory;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.pop3.Pop3Config;
import com.zimbra.cs.mailclient.pop3.Pop3Connection;
import com.zimbra.cs.mailclient.util.Password;
import com.zimbra.cs.mailclient.util.SSLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailClient {
    private MailConfig config;
    protected MailConnection connection;
    private StringBuilder sbuf;
    private String password;
    private boolean eof;

    protected MailClient(MailConfig config) {
        this.config = config;
        this.sbuf = new StringBuilder(132);
    }

    public void run(String[] args) throws LoginException, IOException {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        this.config.setTrace(true);
        this.parseArguments(args);
        this.connect();
        this.authenticate();
        this.startCommandLoop();
    }

    protected abstract void printUsage(PrintStream var1);

    protected void connect() throws IOException {
        this.config.setConnectTimeout(30);
        this.config.setTraceStream(System.out);
        this.config.setSSLSocketFactory(SSLUtil.getDummySSLContext().getSocketFactory());
        this.connection = MailClient.newConnection(this.config);
        this.connection.connect();
    }

    protected void authenticate() throws LoginException, IOException {
        if (this.password == null && this.isPasswordRequired()) {
            this.password = Password.read("Password: ");
        }
        if (this.config.getAuthenticationId() == null) {
            this.config.setAuthenticationId(System.getProperty("user.name"));
        }
        this.connection.authenticate(this.password);
        String qop = this.connection.getNegotiatedQop();
        if (qop != null) {
            System.out.printf("[Negotiated QOP is %s]\n", qop);
        }
    }

    private boolean isPasswordRequired() {
        String mech = this.config.getMechanism();
        if (mech == null) {
            return true;
        }
        AuthenticatorFactory af = this.config.getAuthenticatorFactory();
        return af != null && af.isPasswordRequired(mech);
    }

    private static MailConnection newConnection(MailConfig config) {
        if (config instanceof ImapConfig) {
            return new ImapConnection((ImapConfig)config);
        }
        if (config instanceof Pop3Config) {
            return new Pop3Connection((Pop3Config)config);
        }
        throw new IllegalArgumentException("Unsupported protocol: " + config.getProtocol());
    }

    private void startCommandLoop() throws IOException {
        block3: {
            this.connection.setTraceEnabled(false);
            ReaderThread t = new ReaderThread();
            t.setDaemon(true);
            t.start();
            MailInputStream is = this.connection.getInputStream();
            try {
                String line;
                while ((line = is.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                if (this.eof) break block3;
                e.printStackTrace();
            }
        }
    }

    private String readLine(InputStream is) throws IOException {
        int c;
        this.sbuf.setLength(0);
        while ((c = is.read()) != -1 && c != 10) {
            if (c == 13) continue;
            this.sbuf.append((char)c);
        }
        return c != -1 ? this.sbuf.toString() : null;
    }

    public void parseArguments(String[] args) {
        try {
            this.parseArguments(Arrays.asList(args).listIterator());
        }
        catch (IllegalArgumentException e) {
            System.err.printf("ERROR: %s\n", e);
            this.printUsage(System.err);
            System.exit(1);
        }
    }

    private void parseArguments(ListIterator<String> args) {
        while (args.hasNext() && this.parseArgument(args)) {
        }
        if (!args.hasNext()) {
            throw new IllegalArgumentException("Missing required host name");
        }
        this.config.setHost(args.next());
        if (args.hasNext()) {
            throw new IllegalArgumentException();
        }
    }

    protected boolean parseArgument(ListIterator<String> args) {
        String arg = args.next();
        if (!arg.startsWith("-")) {
            args.previous();
            return false;
        }
        if (arg.length() != 2) {
            throw new IllegalArgumentException("Illegal option: " + arg);
        }
        int minQop = -1;
        int maxQop = -1;
        try {
            switch (arg.charAt(1)) {
                case 'p': {
                    this.config.setPort(Integer.parseInt(args.next()));
                    break;
                }
                case 'u': {
                    this.config.setAuthenticationId(args.next());
                    break;
                }
                case 'z': {
                    this.config.setAuthorizationId(args.next());
                    break;
                }
                case 'w': {
                    this.password = args.next();
                    break;
                }
                case 'r': {
                    this.config.setRealm(args.next());
                    break;
                }
                case 'm': {
                    this.config.setMechanism(args.next().toUpperCase());
                    break;
                }
                case 'k': {
                    minQop = MailClient.parseQop(arg, args.next());
                    break;
                }
                case 'l': {
                    maxQop = MailClient.parseQop(arg, args.next());
                    break;
                }
                case 's': {
                    this.config.setSecurity(MailConfig.Security.SSL);
                    break;
                }
                case 't': {
                    this.config.setSecurity(MailConfig.Security.TLS_IF_AVAILABLE);
                    break;
                }
                case 'd': {
                    this.config.setDebug(true);
                    break;
                }
                case 'q': {
                    this.config.setTrace(false);
                    break;
                }
                case 'h': {
                    this.printUsage(System.out);
                    System.exit(0);
                }
                default: {
                    throw new IllegalArgumentException("Illegal option: " + arg);
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Option requires argument: " + arg);
        }
        if (this.config.getSecurity() != MailConfig.Security.SSL) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("javax.security.sasl.qop", MailClient.getQop(minQop, maxQop));
            this.config.setSaslProperties(props);
        }
        return true;
    }

    private static int parseQop(String arg, String value) {
        if (value.equalsIgnoreCase("auth") || value.equals("0")) {
            return 0;
        }
        if (value.equalsIgnoreCase("auth-int") || value.equals("1")) {
            return 1;
        }
        if (value.equalsIgnoreCase("auth-conf") || value.equals("2")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid value for option '" + arg + "'");
    }

    private static String getQop(int minQop, int maxQop) {
        if (minQop == -1) {
            minQop = 0;
        }
        if (maxQop == -1) {
            maxQop = 2;
        }
        if (minQop > maxQop) {
            maxQop = minQop;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = maxQop; i >= minQop; --i) {
            switch (i) {
                case 0: {
                    sb.append("auth");
                    break;
                }
                case 1: {
                    sb.append("auth-int");
                    break;
                }
                case 2: {
                    sb.append("auth-conf");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (i <= minQop) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private boolean processCommand(String line) throws IOException {
        if (!line.startsWith("!")) {
            return false;
        }
        line = line.substring(1);
        String[] cmdLine = line.split(" ");
        boolean success = false;
        try {
            success = this.processCommand(cmdLine);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (!success) {
            System.out.println(">> ERROR: Invalid command: " + line);
        }
        return true;
    }

    protected boolean processCommand(String[] cmdLine) throws IOException {
        String cmd = cmdLine[0];
        if (MailClient.isMatch(cmd, "SHow")) {
            return this.processShow(cmdLine);
        }
        if (MailClient.isMatch(cmd, "SET")) {
            return this.processSet(cmdLine);
        }
        return false;
    }

    protected boolean processShow(String[] cmdLine) throws IOException {
        return false;
    }

    protected boolean processSet(String[] cmdLine) throws IOException {
        return false;
    }

    protected static boolean isMatch(String word, String fullword) {
        if (word.length() > fullword.length()) {
            return false;
        }
        boolean enough = false;
        for (int i = 0; i < fullword.length(); ++i) {
            char c = fullword.charAt(i);
            if (Character.isLowerCase(c)) {
                enough = true;
            } else {
                c = Character.toLowerCase(c);
            }
            if (i >= word.length()) {
                return enough;
            }
            if (Character.toLowerCase(word.charAt(i)) == c) continue;
            return false;
        }
        return word.length() == fullword.length();
    }

    private class ReaderThread
    extends Thread {
        private ReaderThread() {
        }

        public void run() {
            try {
                String line;
                MailOutputStream os = MailClient.this.connection.getOutputStream();
                while ((line = MailClient.this.readLine(System.in)) != null) {
                    if (MailClient.this.processCommand(line)) continue;
                    os.writeLine(line);
                    os.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            MailClient.this.eof = true;
            MailClient.this.connection.close();
        }
    }
}

