/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient;

import com.zimbra.cs.mailclient.MailException;
import com.zimbra.cs.mailclient.ParseException;
import java.net.SocketTimeoutException;

public class CommandFailedException
extends MailException {
    private final String cmd;
    private final String error;
    private String request;

    public CommandFailedException(String cmd, String error) {
        this.cmd = cmd;
        this.error = error;
    }

    public String getCommand() {
        return this.cmd;
    }

    public String getError() {
        return this.error;
    }

    public void setRequest(String req) {
        this.request = req;
    }

    public String getRequest() {
        return this.request;
    }

    public boolean canContinue() {
        Throwable e = this.getCause();
        return e == null || e instanceof MailException && !(e instanceof ParseException);
    }

    public boolean isTimeout() {
        return this.getCause() instanceof SocketTimeoutException;
    }

    public String getMessage() {
        return this.error != null ? this.cmd + " failed: " + this.error : this.cmd + " failed";
    }
}

