/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.util;

import com.zimbra.cs.mailbox.MailItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypedIdList
implements Iterable<Map.Entry<Byte, List<Integer>>> {
    private Map<Byte, List<Integer>> mIds = new HashMap<Byte, List<Integer>>(4);

    public TypedIdList() {
    }

    public TypedIdList(TypedIdList other) {
        this();
        if (other != null) {
            this.add(other);
        }
    }

    public void add(byte type, Integer id) {
        if (id == null) {
            return;
        }
        List<Integer> items = this.mIds.get(type);
        if (items == null) {
            items = new ArrayList<Integer>(1);
            this.mIds.put(type, items);
        }
        items.add(id);
    }

    public void add(byte type, List<Integer> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        List<Integer> items = this.mIds.get(type);
        if (items == null) {
            items = new ArrayList<Integer>(1);
            this.mIds.put(type, items);
        }
        items.addAll(ids);
    }

    public void add(TypedIdList other) {
        for (Map.Entry<Byte, List<Integer>> entry : other) {
            this.add((byte)entry.getKey(), entry.getValue());
        }
    }

    public boolean remove(byte type, Integer id) {
        if (id == null) {
            return false;
        }
        List<Integer> items = this.mIds.get(type);
        if (items != null && items.remove(id)) {
            if (items.isEmpty()) {
                this.mIds.remove(type);
            }
            return true;
        }
        return false;
    }

    public void remove(byte type) {
        this.mIds.remove(type);
    }

    public boolean contains(Integer id) {
        for (List<Integer> set : this.mIds.values()) {
            if (!set.contains(id)) continue;
            return true;
        }
        return false;
    }

    public Set<Byte> types() {
        return this.mIds.keySet();
    }

    public int getTypesMask() {
        int mask = 0;
        for (byte b : this.types()) {
            mask |= MailItem.typeToBitmask(b);
        }
        return mask;
    }

    public List<Integer> getIds(byte ... types) {
        ArrayList<Integer> ids = null;
        for (byte b : types) {
            List<Integer> typedIds = this.getIds(b);
            if (typedIds == null) continue;
            if (ids == null) {
                ids = new ArrayList<Integer>(typedIds.size());
            }
            ids.addAll(typedIds);
        }
        return ids;
    }

    public List<Integer> getIds(byte type) {
        return this.mIds.get(type);
    }

    public List<Integer> getAll() {
        ArrayList<Integer> marked = new ArrayList<Integer>();
        for (List<Integer> set : this.mIds.values()) {
            marked.addAll(set);
        }
        return marked;
    }

    public int size() {
        int size = 0;
        for (List<Integer> set : this.mIds.values()) {
            size += set.size();
        }
        return size;
    }

    @Override
    public Iterator<Map.Entry<Byte, List<Integer>>> iterator() {
        return this.mIds.entrySet().iterator();
    }

    public boolean isEmpty() {
        return this.mIds.isEmpty();
    }

    public void clear() {
        this.mIds.clear();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Byte, List<Integer>> entry : this.mIds.entrySet()) {
            sb.append(sb.length() == 0 ? "" : ",").append(MailItem.getNameForType(entry.getKey())).append('=').append(entry.getValue());
        }
        return sb.toString();
    }
}

