/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.store.file.Volume;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataDump {
    private static final String OPT_MAILBOX_ID = "mailboxId";
    private static final String OPT_ITEM_ID = "itemId";
    private static final String OPT_FILE = "file";
    private static final String OPT_HELP = "h";
    private static Options sOptions = new Options();
    private static final String METADATA_COLUMN = "metadata";

    private static void usage(String errmsg) {
        if (errmsg != null) {
            System.err.println(errmsg);
        }
        System.err.println("Usage: zmmetadump -m <mailbox id/email> -i <item id>");
        System.err.println("   or: zmmetadump -f <file containing encoded metadata>");
    }

    private static CommandLine parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(sOptions, args);
        }
        catch (ParseException pe) {
            MetadataDump.usage(pe.getMessage());
            System.exit(1);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getMailboxGroup(DbPool.Connection conn, long mboxId) throws SQLException {
        PreparedStatement stmt;
        long gid;
        block6: {
            gid = 0L;
            stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement("SELECT group_id FROM mailbox WHERE id = ?");
                stmt.setLong(1, mboxId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    gid = rs.getLong(1);
                }
                Object var8_5 = null;
                if (rs == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return gid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int lookupMailboxIdFromEmail(DbPool.Connection conn, String email) throws SQLException, ServiceException {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT id FROM mailbox WHERE comment=?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, email.toUpperCase());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw ServiceException.INVALID_REQUEST("Account " + email + " not found on this host", null);
            }
            n = rs.getInt(1);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return n;
    }

    private static Row getItemRow(DbPool.Connection conn, long groupId, long mboxId, int itemId) throws ServiceException {
        Row row;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT * FROM " + DbMailItem.getMailItemTableName(mboxId, groupId) + " WHERE mailbox_id = " + mboxId + " AND id = " + itemId;
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw ServiceException.INVALID_REQUEST("No such item: mbox=" + mboxId + ", item=" + itemId, null);
            }
            Row row2 = new Row();
            ResultSetMetaData rsMeta = rs.getMetaData();
            int cols = rsMeta.getColumnCount();
            for (int i = 1; i <= cols; ++i) {
                String colName = rsMeta.getColumnName(i);
                String colValue = rs.getString(i);
                if (rs.wasNull()) {
                    colValue = null;
                }
                row2.addColumn(colName, colValue);
            }
            row = row2;
            Object var16_15 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.INVALID_REQUEST("No such item: mbox=" + mboxId + ", item=" + itemId, e);
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return row;
    }

    private static List<Row> getRevisionRows(DbPool.Connection conn, long groupId, long mboxId, int itemId) throws ServiceException {
        ArrayList<Row> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT * FROM " + DbMailItem.getRevisionTableName(mboxId, groupId) + " WHERE mailbox_id = " + mboxId + " AND item_id = " + itemId + " ORDER BY mailbox_id, item_id, version DESC";
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            ArrayList<Row> rows = new ArrayList<Row>();
            while (rs.next()) {
                Row row = new Row();
                ResultSetMetaData rsMeta = rs.getMetaData();
                int cols = rsMeta.getColumnCount();
                for (int i = 1; i <= cols; ++i) {
                    String colName = rsMeta.getColumnName(i);
                    String colValue = rs.getString(i);
                    if (rs.wasNull()) {
                        colValue = null;
                    }
                    row.addColumn(colName, colValue);
                }
                rows.add(row);
            }
            arrayList = rows;
            Object var17_15 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.INVALID_REQUEST("No such item: mbox=" + mboxId + ", item=" + itemId, e);
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadFromFile(File file) throws ServiceException {
        try {
            String string;
            long length = file.length();
            byte[] buf = new byte[(int)length];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                int bytesRead = fis.read(buf);
                if ((long)bytesRead < length) {
                    throw ServiceException.FAILURE("Read " + bytesRead + " bytes when expecting " + length + " bytes, from file " + file.getAbsolutePath(), null);
                }
                string = new String(buf, "utf-8");
                Object var8_7 = null;
                if (fis == null) return string;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (fis != null) {
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
            return string;
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException while reading from " + file.getAbsolutePath(), e);
        }
    }

    private static void printBanner(PrintStream ps, String title) {
        ps.println("********************   " + title + "   ********************");
    }

    private static String getTimestampStr(long time) {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE yyyy/MM/dd HH:mm:ss z");
        return fmt.format(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String infileName;
            CliUtil.toolSetup();
            long mboxId = 0L;
            int itemId = 0;
            PrintStream out = new PrintStream((OutputStream)System.out, true, "utf-8");
            CommandLine cl = MetadataDump.parseArgs(args);
            if (cl.hasOption(OPT_HELP)) {
                MetadataDump.usage(null);
                System.exit(0);
            }
            if ((infileName = cl.getOptionValue(OPT_FILE)) != null) {
                File file = new File(infileName);
                if (file.exists()) {
                    String encoded = MetadataDump.loadFromFile(file);
                    Metadata md = new Metadata(encoded);
                    String pretty = md.prettyPrint();
                    out.println(pretty);
                    return;
                }
                System.err.println("File " + infileName + " does not exist");
                System.exit(1);
            }
            DbPool.startup();
            DbPool.Connection conn = null;
            try {
                String mboxIdStr = cl.getOptionValue(OPT_MAILBOX_ID);
                String itemIdStr = cl.getOptionValue(OPT_ITEM_ID);
                if (mboxIdStr == null || itemIdStr == null) {
                    MetadataDump.usage(null);
                    System.exit(1);
                }
                if (mboxIdStr.matches("\\d+")) {
                    try {
                        mboxId = Integer.parseInt(mboxIdStr);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid mailbox id " + mboxIdStr);
                        System.exit(1);
                    }
                } else {
                    conn = DbPool.getConnection();
                    mboxId = MetadataDump.lookupMailboxIdFromEmail(conn, mboxIdStr);
                }
                try {
                    itemId = Integer.parseInt(itemIdStr);
                }
                catch (NumberFormatException e) {
                    MetadataDump.usage(null);
                    System.exit(1);
                }
                if (conn == null) {
                    conn = DbPool.getConnection();
                }
                long groupId = MetadataDump.getMailboxGroup(conn, mboxId);
                boolean first = true;
                Row item = MetadataDump.getItemRow(conn, groupId, mboxId, itemId);
                List<Row> revs = MetadataDump.getRevisionRows(conn, groupId, mboxId, itemId);
                if (!revs.isEmpty()) {
                    MetadataDump.printBanner(out, "Current Revision");
                }
                item.print(out);
                first = false;
                for (Row rev : revs) {
                    String version = rev.get("version");
                    if (!first) {
                        out.println();
                        out.println();
                    }
                    MetadataDump.printBanner(out, "Revision " + version);
                    rev.print(out);
                    first = false;
                }
                Object var19_23 = null;
            }
            catch (Throwable throwable) {
                Object var19_24 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
            {
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println();
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        sOptions.addOption("m", OPT_MAILBOX_ID, true, "mailbox id");
        sOptions.addOption("i", OPT_ITEM_ID, true, "item id (required when --mailboxId is used)");
        sOptions.addOption("f", OPT_FILE, true, "Decode metadata value in a file (other options are ignored)");
        sOptions.addOption(OPT_HELP, "help", false, "Show help (this output)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Row {
        private Map<String, String> mMap = new LinkedHashMap<String, String>();

        private Row() {
        }

        public void addColumn(String colName, String value) {
            this.mMap.put(colName.toLowerCase(), value);
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return this.mMap.entrySet().iterator();
        }

        public String get(String colName) {
            return this.mMap.get(colName.toLowerCase());
        }

        public void print(PrintStream ps) throws ServiceException {
            short volId;
            Volume vol;
            ps.println("[Database Columns]");
            Iterator<Map.Entry<String, String>> iter = this.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                String col = entry.getKey();
                if (col.equalsIgnoreCase(MetadataDump.METADATA_COLUMN)) continue;
                String val = entry.getValue();
                if ((col.equalsIgnoreCase("date") || col.equalsIgnoreCase("change_date")) && val != null) {
                    long t = Long.parseLong(val) * 1000L;
                    val = val + " (" + MetadataDump.getTimestampStr(t) + ")";
                }
                ps.println("  " + col + ": " + (val != null ? val : "<null>"));
            }
            ps.println();
            if (this.mMap.get("blob_digest") != null && (vol = Volume.getById(volId = Short.parseShort(this.mMap.get("volume_id")))) != null) {
                long mboxId = Long.parseLong(this.mMap.get("mailbox_id"));
                String itemIdStr = this.mMap.get("id");
                if (itemIdStr == null) {
                    itemIdStr = this.mMap.get("item_id");
                }
                int itemId = Integer.parseInt(itemIdStr);
                String dir = vol.getBlobDir(mboxId, itemId);
                String modContent = this.mMap.get("mod_content");
                String blobPath = dir + File.separator + itemIdStr + "-" + modContent + ".msg";
                ps.println("[Blob Path]");
                ps.println(blobPath);
                ps.println();
            }
            ps.println("[Metadata]");
            Metadata md = new Metadata(this.mMap.get(MetadataDump.METADATA_COLUMN));
            ps.println(md.prettyPrint());
        }
    }
}

