/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.tzfixup;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.WellKnownTimeZones;
import com.zimbra.cs.mailbox.calendar.tzfixup.TimeZoneFixupRules;
import com.zimbra.cs.service.mail.CalendarUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFixupRules {
    public static final String E_TZFIXUP = "tzfixup";
    private static final String E_FIXUP_RULE = "fixupRule";
    private static final String E_MATCH = "match";
    private static final String E_ANY = "any";
    private static final String E_TZID = "tzid";
    private static final String E_NON_DST = "nonDst";
    private static final String E_RULES = "rules";
    private static final String E_DATES = "dates";
    private static final String E_STANDARD = "standard";
    private static final String E_DAYLIGHT = "daylight";
    private static final String E_REPLACE = "replace";
    private static final String E_TOUCH = "touch";
    private static final String E_WELL_KNOWN_TZ = "wellKnownTz";
    private static final String A_ID = "id";
    private static final String A_OFFSET = "offset";
    private static final String A_STDOFF = "stdoff";
    private static final String A_DAYOFF = "dayoff";
    private static final String A_MON = "mon";
    private static final String A_WEEK = "week";
    private static final String A_WKDAY = "wkday";
    private static final String A_MDAY = "mday";

    private static void parseMatchers(Element matchElem, ICalTimeZone replacementTZ, List<TimeZoneFixupRules.Matcher> matchers) throws ServiceException {
        Iterator<Element> elemIter = matchElem.elementIterator();
        while (elemIter.hasNext()) {
            int stdMon;
            Element stdElem;
            long dstOffset;
            Element elem = elemIter.next();
            String elemName = elem.getName();
            if (elemName.equals(E_ANY)) {
                matchers.add(new TimeZoneFixupRules.Matcher(replacementTZ));
                continue;
            }
            if (elemName.equals(E_TZID)) {
                String tzid = elem.getAttribute(A_ID);
                matchers.add(new TimeZoneFixupRules.Matcher(tzid, replacementTZ));
                continue;
            }
            if (elemName.equals(E_NON_DST)) {
                long offset = elem.getAttributeLong(A_OFFSET);
                matchers.add(new TimeZoneFixupRules.Matcher(offset, replacementTZ));
                continue;
            }
            if (elemName.equals(E_RULES)) {
                long stdOffset = elem.getAttributeLong(A_STDOFF);
                dstOffset = elem.getAttributeLong(A_DAYOFF);
                stdElem = elem.getElement(E_STANDARD);
                stdMon = (int)stdElem.getAttributeLong(A_MON);
                int stdWeek = (int)stdElem.getAttributeLong(A_WEEK);
                int stdWkday = (int)stdElem.getAttributeLong(A_WKDAY);
                Element dstElem = elem.getElement(E_DAYLIGHT);
                int dstMon = (int)dstElem.getAttributeLong(A_MON);
                int dstWeek = (int)dstElem.getAttributeLong(A_WEEK);
                int dstWkday = (int)dstElem.getAttributeLong(A_WKDAY);
                TimeZoneFixupRules.Matcher m = new TimeZoneFixupRules.Matcher(stdOffset, stdMon, stdWeek, stdWkday, dstOffset, dstMon, dstWeek, dstWkday, replacementTZ);
                matchers.add(m);
                continue;
            }
            if (!elemName.equals(E_DATES)) continue;
            long stdOffset = elem.getAttributeLong(A_STDOFF);
            dstOffset = elem.getAttributeLong(A_DAYOFF);
            stdElem = elem.getElement(E_STANDARD);
            stdMon = (int)stdElem.getAttributeLong(A_MON);
            int stdMday = (int)stdElem.getAttributeLong(A_MDAY);
            Element dstElem = elem.getElement(E_DAYLIGHT);
            int dstMon = (int)dstElem.getAttributeLong(A_MON);
            int dstMday = (int)dstElem.getAttributeLong(A_MDAY);
            TimeZoneFixupRules.Matcher m = new TimeZoneFixupRules.Matcher(stdOffset, stdMon, stdMday, dstOffset, dstMon, dstMday, replacementTZ);
            matchers.add(m);
        }
    }

    private static void parseFixupRule(Element fixupRuleElem, List<TimeZoneFixupRules.Matcher> matchers) throws ServiceException {
        ICalTimeZone replacementTZ;
        Element matchElem = fixupRuleElem.getElement(E_MATCH);
        Element touchElem = fixupRuleElem.getOptionalElement(E_TOUCH);
        Element replaceElem = fixupRuleElem.getOptionalElement(E_REPLACE);
        if (touchElem == null && replaceElem == null) {
            throw ServiceException.FAILURE("Neither <touch> nor <replace> found in <fixupRule>", null);
        }
        if (touchElem != null && replaceElem != null) {
            throw ServiceException.FAILURE("<fixupRule> must not have both <touch> and <replace>", null);
        }
        if (touchElem != null) {
            replacementTZ = null;
        } else {
            Element wellKnownTzElem = replaceElem.getOptionalElement(E_WELL_KNOWN_TZ);
            if (wellKnownTzElem != null) {
                String tzid = wellKnownTzElem.getAttribute(A_ID);
                replacementTZ = WellKnownTimeZones.getTimeZoneById(tzid);
                if (replacementTZ == null) {
                    throw ServiceException.FAILURE("Unknown TZID \"" + tzid + "\"", null);
                }
            } else {
                Element tzElem = replaceElem.getOptionalElement("tz");
                if (tzElem == null) {
                    throw ServiceException.FAILURE("Neither <tz> nor <wellKnownTz> found in <replace>", null);
                }
                replacementTZ = CalendarUtils.parseTzElement(tzElem);
            }
        }
        XmlFixupRules.parseMatchers(matchElem, replacementTZ, matchers);
    }

    public static List<TimeZoneFixupRules.Matcher> parseTzFixup(Element tzFixupElem) throws ServiceException {
        ArrayList<TimeZoneFixupRules.Matcher> matchers = new ArrayList<TimeZoneFixupRules.Matcher>();
        Iterator<Element> elemIter = tzFixupElem.elementIterator(E_FIXUP_RULE);
        while (elemIter.hasNext()) {
            Element fixupRuleElem = elemIter.next();
            XmlFixupRules.parseFixupRule(fixupRuleElem, matchers);
        }
        return matchers;
    }
}

