/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.tzfixup;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.tzfixup.XmlFixupRules;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeZoneFixupRules {
    private List<Matcher> mMatchers;

    public TimeZoneFixupRules(Element tzFixupElem) throws ServiceException {
        this.mMatchers = XmlFixupRules.parseTzFixup(tzFixupElem);
    }

    public TimeZoneFixupRules(Map<String, ICalTimeZone> replacements) {
        this.mMatchers = new ArrayList<Matcher>();
        for (Map.Entry<String, ICalTimeZone> entry : replacements.entrySet()) {
            String oldTZID = entry.getKey();
            ICalTimeZone replacementTZ = entry.getValue();
            Matcher m = new Matcher(oldTZID, replacementTZ);
            this.mMatchers.add(m);
        }
    }

    private ICalTimeZone fixTZ(ICalTimeZone oldTZ, Map<String, ICalTimeZone> replaced) {
        for (Matcher matcher : this.mMatchers) {
            if (!matcher.matches(oldTZ)) continue;
            String oldID = oldTZ.getID();
            if (matcher.isTouchOnly()) {
                ZimbraLog.calendar.info("Touching timezone: " + oldID);
                replaced.put(oldID, oldTZ);
                return oldTZ;
            }
            ICalTimeZone newTZ = matcher.getReplacementTZ();
            ZimbraLog.calendar.info("Found replacement timezone: old=" + oldID + ", new=" + newTZ.getID());
            replaced.put(oldID, newTZ);
            return newTZ.cloneWithNewTZID(oldID);
        }
        return null;
    }

    private int fixTZMap(TimeZoneMap tzmap, Map<String, ICalTimeZone> replaced) {
        int numFixed = 0;
        if (tzmap == null) {
            return 0;
        }
        ArrayList<ICalTimeZone> newTZList = new ArrayList<ICalTimeZone>();
        Iterator<ICalTimeZone> iter = tzmap.tzIterator();
        while (iter.hasNext()) {
            ICalTimeZone tz = iter.next();
            ICalTimeZone newTZ = this.fixTZ(tz, replaced);
            if (newTZ == null) continue;
            iter.remove();
            newTZList.add(newTZ);
        }
        for (ICalTimeZone newTZ : newTZList) {
            tzmap.add(newTZ);
            ++numFixed;
        }
        return numFixed;
    }

    public int fixCalendarItem(CalendarItem calItem, Map<String, ICalTimeZone> replaced) {
        Invite[] invites;
        int numFixed = 0;
        TimeZoneMap tzmap = calItem.getTimeZoneMap();
        numFixed += this.fixTZMap(tzmap, replaced);
        for (Invite inv : invites = calItem.getInvites()) {
            if (inv == null) continue;
            TimeZoneMap tzmapInv = inv.getTimeZoneMap();
            numFixed += this.fixTZMap(tzmapInv, replaced);
        }
        return numFixed;
    }

    public static class Matcher {
        private MatchBy mMatchBy;
        private String mTZID;
        private long mStandardOffset;
        private long mDaylightOffset;
        private ICalTimeZone.SimpleOnset mStandardOnset;
        private ICalTimeZone.SimpleOnset mDaylightOnset;
        private ICalTimeZone mReplacementTZ;

        public Matcher(ICalTimeZone replacementTZ) {
            this.mMatchBy = MatchBy.ANY;
            this.mReplacementTZ = replacementTZ;
        }

        public Matcher(String tzid, ICalTimeZone replacementTZ) {
            this.mMatchBy = MatchBy.TZID;
            this.mTZID = tzid != null ? tzid : "";
            this.mReplacementTZ = replacementTZ;
        }

        public Matcher(long offset, ICalTimeZone replacementTZ) {
            this.mMatchBy = MatchBy.OFFSET;
            this.mStandardOffset = this.mDaylightOffset = offset * 60000L;
            this.mReplacementTZ = replacementTZ;
        }

        public Matcher(long stdOffsetMins, int stdMonth, int stdWeek, int stdDayOfWeek, long dstOffsetMins, int dstMonth, int dstWeek, int dstDayOfWeek, ICalTimeZone replacementTZ) {
            this.mMatchBy = MatchBy.RULES;
            this.mStandardOffset = stdOffsetMins * 60000L;
            this.mStandardOnset = new ICalTimeZone.SimpleOnset(stdWeek, stdDayOfWeek, stdMonth, 0, 2, 0, 0, true);
            this.mDaylightOffset = dstOffsetMins * 60000L;
            this.mDaylightOnset = new ICalTimeZone.SimpleOnset(dstWeek, dstDayOfWeek, dstMonth, 0, 2, 0, 0, true);
            this.mReplacementTZ = replacementTZ;
        }

        public Matcher(long stdOffsetMins, int stdMonth, int stdDayOfMonth, long dstOffsetMins, int dstMonth, int dstDayOfMonth, ICalTimeZone replacementTZ) {
            this.mMatchBy = MatchBy.DATES;
            this.mStandardOffset = stdOffsetMins * 60000L;
            this.mStandardOnset = new ICalTimeZone.SimpleOnset(0, 0, stdMonth, stdDayOfMonth, 2, 0, 0, true);
            this.mDaylightOffset = dstOffsetMins * 60000L;
            this.mDaylightOnset = new ICalTimeZone.SimpleOnset(0, 0, dstMonth, dstDayOfMonth, 2, 0, 0, true);
            this.mReplacementTZ = replacementTZ;
        }

        private static boolean sameOnset(ICalTimeZone.SimpleOnset os1, ICalTimeZone.SimpleOnset os2) {
            if (os1 == null) {
                return os2 == null;
            }
            if (os2 == null) {
                return os1 == null;
            }
            if (os1.getMonth() != os2.getMonth()) {
                return false;
            }
            int week1 = os1.getWeek();
            if (week1 != 0) {
                return week1 == os2.getWeek() && os1.getDayOfWeek() == os2.getDayOfWeek();
            }
            return os1.getDayOfMonth() == os2.getDayOfMonth();
        }

        public boolean isTouchOnly() {
            return this.mReplacementTZ == null;
        }

        public ICalTimeZone getReplacementTZ() {
            return this.mReplacementTZ;
        }

        public boolean matches(ICalTimeZone tz) {
            switch (this.mMatchBy) {
                case ANY: {
                    return true;
                }
                case TZID: {
                    return this.mTZID.equalsIgnoreCase(tz.getID());
                }
                case OFFSET: {
                    return !tz.useDaylightTime() && (long)tz.getRawOffset() == this.mStandardOffset;
                }
                case RULES: 
                case DATES: {
                    if (!tz.useDaylightTime()) {
                        return false;
                    }
                    if ((long)tz.getStandardOffset() != this.mStandardOffset || (long)tz.getDaylightOffset() != this.mDaylightOffset) {
                        return false;
                    }
                    return Matcher.sameOnset(this.mStandardOnset, tz.getStandardOnset()) && Matcher.sameOnset(this.mDaylightOnset, tz.getDaylightOnset());
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchBy {
        ANY,
        TZID,
        OFFSET,
        RULES,
        DATES;

    }
}

