/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.util.Pair;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final int WEEEKS_IN_MONTH_VIEW = 6;

    static <T> boolean sameValues(T val1, T val2) {
        if (val1 != null) {
            return val1.equals(val2);
        }
        return val2 == null;
    }

    static Pair<Long, Long> getMonthsRange(long now, int monthFrom, int numMonths) {
        GregorianCalendar cal = new GregorianCalendar(ICalTimeZone.getUTC());
        cal.setTimeInMillis(now);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Calendar calStart = (Calendar)((Calendar)cal).clone();
        calStart.add(2, monthFrom);
        int moreDays = calStart.get(7) - 1;
        ++moreDays;
        calStart.add(6, -1 * (moreDays += 7));
        long start = calStart.getTimeInMillis();
        Calendar calEnd = (Calendar)((Calendar)cal).clone();
        calEnd.add(2, monthFrom + numMonths);
        calEnd.add(6, -1);
        int daysInFinalMonth = calEnd.getActualMaximum(5);
        int extraDaysToEndOfWeek = 7 - calEnd.get(7);
        int linesOccupied = (daysInFinalMonth + extraDaysToEndOfWeek + 6) / 7;
        int extraWeeks = Math.max(6 - linesOccupied, 0);
        moreDays = extraDaysToEndOfWeek;
        moreDays += extraWeeks * 7;
        ++moreDays;
        calEnd.add(6, ++moreDays);
        long end = Math.max(calEnd.getTimeInMillis(), start);
        return new Pair<Long, Long>(start, end);
    }

    static Long getTZOffsetForInvite(Invite inv, long instanceStart) {
        ICalTimeZone tz;
        ParsedDateTime dtStart;
        if (inv.isAllDayEvent() && (dtStart = inv.getStartTime()) != null && (tz = dtStart.getTimeZone()) != null) {
            return new Long(tz.getOffset(instanceStart));
        }
        return null;
    }
}

