/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.cache.Util;

public class InstanceData {
    private String mRecurIdZ;
    private Long mDtStart;
    private Long mDuration;
    private Long mAlarmAt;
    private Long mTZOffset;
    private String mPartStat;
    private String mFreeBusyActual;
    private String mPercentComplete;
    private static final String FN_RECURRENCE_ID_Z = "ridZ";
    private static final String FN_DTSTART = "st";
    private static final String FN_DURATION = "dur";
    private static final String FN_ALARM_AT = "alarm";
    private static final String FN_TZOFFSET = "tzo";
    private static final String FN_PARTSTAT = "ptst";
    private static final String FN_FREEBUSY_ACTUAL = "fba";
    private static final String FN_PERCENT_COMPLETE = "pctcomp";

    public String getRecurIdZ() {
        return this.mRecurIdZ;
    }

    public Long getDtStart() {
        return this.mDtStart;
    }

    public Long getDuration() {
        return this.mDuration;
    }

    public Long getAlarmAt() {
        return this.mAlarmAt;
    }

    public Long getTZOffset() {
        return this.mTZOffset;
    }

    public String getPartStat() {
        return this.mPartStat;
    }

    public String getFreeBusyActual() {
        return this.mFreeBusyActual;
    }

    public String getPercentComplete() {
        return this.mPercentComplete;
    }

    public InstanceData(String recurIdZ, Long dtStart, Long duration, Long alarmAt, Long tzOffset, String partStat, String freeBusyActual, String percentComplete) {
        this.init(recurIdZ, dtStart, duration, alarmAt, tzOffset, partStat, freeBusyActual, percentComplete);
    }

    private void init(String recurIdZ, Long dtStart, Long duration, Long alarmAt, Long tzOffset, String partStat, String freeBusyActual, String percentComplete) {
        this.mRecurIdZ = recurIdZ;
        this.mDtStart = dtStart != null && dtStart != 0L ? dtStart : null;
        this.mDuration = duration != null && duration != 0L ? duration : null;
        this.mAlarmAt = alarmAt != null && alarmAt != 0L ? alarmAt : null;
        this.mTZOffset = tzOffset;
        this.mPartStat = partStat;
        this.mFreeBusyActual = freeBusyActual;
        this.mPercentComplete = percentComplete;
    }

    public InstanceData(String recurIdZ, Long dtStart, Long duration, Long alarmAt, Long tzOffset, String partStat, String freeBusyActual, String percentComplete, InstanceData defaultInstance) {
        this(recurIdZ, dtStart, duration, alarmAt, tzOffset, partStat, freeBusyActual, percentComplete);
        this.clearUnchangedFields(defaultInstance);
    }

    protected void clearUnchangedFields(InstanceData other) {
        if (other != null) {
            if (Util.sameValues(this.mDuration, other.getDuration())) {
                this.mDuration = null;
            }
            if (Util.sameValues(this.mAlarmAt, other.getAlarmAt())) {
                this.mAlarmAt = null;
            }
            if (Util.sameValues(this.mTZOffset, other.getTZOffset())) {
                this.mTZOffset = null;
            }
            if (Util.sameValues(this.mPartStat, other.getPartStat())) {
                this.mPartStat = null;
            }
            if (Util.sameValues(this.mFreeBusyActual, other.getFreeBusyActual())) {
                this.mFreeBusyActual = null;
            }
            if (Util.sameValues(this.mPercentComplete, other.getPercentComplete())) {
                this.mPercentComplete = null;
            }
        }
    }

    InstanceData(Metadata meta) throws ServiceException {
        String recurIdZ = meta.get(FN_RECURRENCE_ID_Z, null);
        Long dtStart = null;
        Long duration = null;
        Long alarmAt = null;
        Long tzOffset = null;
        if (meta.containsKey(FN_DTSTART)) {
            dtStart = new Long(meta.getLong(FN_DTSTART));
        }
        if (meta.containsKey(FN_DURATION)) {
            duration = new Long(meta.getLong(FN_DURATION));
        }
        if (meta.containsKey(FN_ALARM_AT)) {
            alarmAt = new Long(meta.getLong(FN_ALARM_AT));
        }
        if (meta.containsKey(FN_TZOFFSET)) {
            tzOffset = new Long(meta.getLong(FN_TZOFFSET));
        }
        String ptst = meta.get(FN_PARTSTAT, null);
        String fba = meta.get(FN_FREEBUSY_ACTUAL, null);
        String pctComp = meta.get(FN_PERCENT_COMPLETE, null);
        this.init(recurIdZ, dtStart, duration, alarmAt, tzOffset, ptst, fba, pctComp);
    }

    Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_RECURRENCE_ID_Z, this.mRecurIdZ);
        if (this.mDtStart != null) {
            meta.put(FN_DTSTART, this.mDtStart);
        }
        if (this.mDuration != null) {
            meta.put(FN_DURATION, this.mDuration);
        }
        if (this.mAlarmAt != null) {
            meta.put(FN_ALARM_AT, this.mAlarmAt);
        }
        if (this.mTZOffset != null) {
            meta.put(FN_TZOFFSET, this.mTZOffset);
        }
        meta.put(FN_PARTSTAT, this.mPartStat);
        meta.put(FN_FREEBUSY_ACTUAL, this.mFreeBusyActual);
        meta.put(FN_PERCENT_COMPLETE, this.mPercentComplete);
        return meta;
    }
}

