/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.Geo;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mailbox.calendar.cache.InstanceData;
import com.zimbra.cs.mailbox.calendar.cache.Util;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullInstanceData
extends InstanceData {
    private int mInvId;
    private int mCompNum;
    private long mRecurrenceId;
    private int mSequence;
    private long mDtStamp;
    private ZOrganizer mOrganizer;
    private Boolean mIsOrganizer;
    private Integer mNumAttendees;
    private List<ZAttendee> mAttendees;
    private Boolean mHasAlarm;
    private Boolean mHasAttachment;
    private String mSummary;
    private String mLocation;
    private String mFragment;
    private String mDesc;
    private String mDescHtml;
    private Boolean mDescInMeta;
    private Boolean mIsAllDay;
    private String mStatus;
    private String mPriority;
    private String mClassProp;
    private List<String> mCategories;
    private Geo mGeo;
    private String mFreeBusyIntended;
    private String mTransparency;
    private static final String FN_IS_FULL_INSTANCE = "isFull";
    private static final String FN_INVID = "invId";
    private static final String FN_COMPNUM = "compNum";
    private static final String FN_RECURRENCE_ID = "rid";
    private static final String FN_SEQUENCE = "seq";
    private static final String FN_DTSTAMP = "dtstamp";
    private static final String FN_ORGANIZER = "org";
    private static final String FN_IS_ORGANIZER = "isOrg";
    private static final String FN_NUM_ATTENDEES = "numAt";
    private static final String FN_ATTENDEE = "at";
    private static final String FN_HAS_ALARM = "ha";
    private static final String FN_HAS_ATTACHMENT = "hAttach";
    private static final String FN_SUMMARY = "summ";
    private static final String FN_LOCATION = "loc";
    private static final String FN_FRAGMENT = "fr";
    private static final String FN_DESC_IN_META = "dinM";
    private static final String FN_DESC = "desc";
    private static final String FN_DESC_HTML = "descH";
    private static final String FN_IS_ALLDAY = "allDay";
    private static final String FN_STATUS = "status";
    private static final String FN_PRIORITY = "prio";
    private static final String FN_CLASS = "class";
    private static final String FN_FREEBUSY = "fb";
    private static final String FN_TRANSPARENCY = "transp";
    private static final String FN_NUM_CATEGORIES = "numCat";
    private static final String FN_CATEGORY = "cat";
    private static final String FN_GEO = "geo";

    public int getInvId() {
        return this.mInvId;
    }

    public int getCompNum() {
        return this.mCompNum;
    }

    public long getRecurrenceId() {
        return this.mRecurrenceId;
    }

    public int getSequence() {
        return this.mSequence;
    }

    public long getDtStamp() {
        return this.mDtStamp;
    }

    public ZOrganizer getOrganizer() {
        return this.mOrganizer;
    }

    public Boolean isOrganizer() {
        return this.mIsOrganizer;
    }

    public Integer getNumAttendees() {
        return this.mNumAttendees;
    }

    public List<ZAttendee> getAttendees() {
        return this.mAttendees;
    }

    public Boolean hasAlarm() {
        return this.mHasAlarm;
    }

    public Boolean hasAttachment() {
        return this.mHasAttachment;
    }

    public String getSummary() {
        return this.mSummary;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public Boolean descInMeta() {
        return this.mDescInMeta;
    }

    public String getDesc() {
        return this.mDesc;
    }

    public String getDescHtml() {
        return this.mDescHtml;
    }

    public Boolean isAllDay() {
        return this.mIsAllDay;
    }

    public String getStatus() {
        return this.mStatus;
    }

    public String getPriority() {
        return this.mPriority;
    }

    public String getClassProp() {
        return this.mClassProp;
    }

    public List<String> getCategories() {
        return this.mCategories;
    }

    public Geo getGeo() {
        return this.mGeo;
    }

    public String getFreeBusyIntended() {
        return this.mFreeBusyIntended;
    }

    public String getTransparency() {
        return this.mTransparency;
    }

    public boolean isPublic(FullInstanceData defaultInstance) {
        if (this.mClassProp != null) {
            return "PUB".equals(this.mClassProp);
        }
        if (defaultInstance != null) {
            return defaultInstance.isPublic(null);
        }
        return true;
    }

    public FullInstanceData(String recurIdZ, long dtStart, long duration, long alarmAt, long tzOffset, String partStat, String freeBusyActual, String percentComplete, int invId, int compNum, long recurrenceId, int sequence, long dtStamp, ZOrganizer organizer, Boolean isOrganizer, List<ZAttendee> attendees, Boolean hasAlarm, Boolean hasAttachment, String summary, String location, String fragment, Boolean descInMeta, String desc, String descHtml, Boolean isAllDay, String status, String priority, String classProp, String freeBusyIntended, String transparency, List<String> categories, Geo geo) {
        super(recurIdZ, dtStart, duration, alarmAt, tzOffset, partStat, freeBusyActual, percentComplete);
        this.init(invId, compNum, recurrenceId, sequence, dtStamp, organizer, isOrganizer, attendees, hasAlarm, hasAttachment, summary, location, fragment, descInMeta, desc, descHtml, isAllDay, status, priority, classProp, freeBusyIntended, transparency, categories, geo);
    }

    private void init(int invId, int compNum, long recurrenceId, int sequence, long dtStamp, ZOrganizer organizer, Boolean isOrganizer, List<ZAttendee> attendees, Boolean hasAlarm, Boolean hasAttachment, String summary, String location, String fragment, Boolean descInMeta, String desc, String descHtml, Boolean isAllDay, String status, String priority, String classProp, String freeBusyIntended, String transparency, List<String> categories, Geo geo) {
        this.mInvId = invId;
        this.mCompNum = compNum;
        this.mRecurrenceId = recurrenceId;
        this.mSequence = sequence;
        this.mDtStamp = dtStamp;
        this.mOrganizer = organizer;
        this.mIsOrganizer = isOrganizer;
        this.mAttendees = attendees;
        this.mNumAttendees = attendees != null ? Integer.valueOf(attendees.size()) : null;
        this.mHasAlarm = hasAlarm;
        this.mHasAttachment = hasAttachment;
        this.mSummary = summary;
        this.mLocation = location;
        this.mFragment = fragment;
        this.mDescInMeta = descInMeta;
        this.mDesc = desc;
        this.mDescHtml = descHtml;
        this.mIsAllDay = isAllDay;
        this.mStatus = status;
        this.mPriority = priority;
        this.mClassProp = classProp;
        this.mFreeBusyIntended = freeBusyIntended;
        this.mTransparency = transparency;
        this.mCategories = categories;
        this.mGeo = geo;
    }

    public FullInstanceData(Invite inv, String recurIdZ, Long dtStart, Long duration, String partStat, String freeBusyActual, Long alarmAt, FullInstanceData defaultInstance) throws ServiceException {
        super(recurIdZ, dtStart, duration, alarmAt, dtStart != null ? Util.getTZOffsetForInvite(inv, dtStart) : null, partStat, freeBusyActual, inv.getPercentComplete());
        long recurId = 0L;
        if (inv.hasRecurId()) {
            RecurId rid = inv.getRecurId();
            ParsedDateTime ridDt = rid.getDt();
            recurId = ridDt.getUtcTime();
        }
        List<ZAttendee> attendees = null;
        if (inv.hasOtherAttendees()) {
            attendees = inv.getAttendees();
        }
        String desc = null;
        String descHtml = null;
        boolean descInMeta = inv.descInMeta();
        if (descInMeta) {
            desc = inv.getDescription();
            descHtml = inv.getDescriptionHtml();
        }
        this.init(inv.getMailItemId(), inv.getComponentNum(), recurId, inv.getSeqNo(), inv.getDTStamp(), inv.getOrganizer(), inv.isOrganizer(), attendees, inv.hasAlarm(), inv.hasAttachment(), inv.getName(), inv.getLocation(), inv.getFragment(), descInMeta, desc, descHtml, inv.isAllDayEvent(), inv.getStatus(), inv.getPriority(), inv.getClassProp(), inv.getFreeBusy(), inv.getTransparency(), inv.getCategories(), inv.getGeo());
        this.clearUnchangedFields(defaultInstance);
    }

    protected void clearUnchangedFields(FullInstanceData other) {
        super.clearUnchangedFields(other);
        if (other != null) {
            if (Util.sameValues(this.mOrganizer, other.getOrganizer())) {
                this.mOrganizer = null;
            }
            if (Util.sameValues(this.mIsOrganizer, other.isOrganizer())) {
                this.mIsOrganizer = null;
            }
            if (Util.sameValues(this.mNumAttendees, other.getNumAttendees())) {
                this.mNumAttendees = null;
            }
            if (Util.sameValues(this.mHasAlarm, other.hasAlarm())) {
                this.mHasAlarm = null;
            }
            if (Util.sameValues(this.mHasAttachment, other.hasAttachment())) {
                this.mHasAttachment = null;
            }
            if (Util.sameValues(this.mSummary, other.getSummary())) {
                this.mSummary = null;
            }
            if (Util.sameValues(this.mLocation, other.getLocation())) {
                this.mLocation = null;
            }
            if (Util.sameValues(this.mFragment, other.getFragment())) {
                this.mFragment = null;
            }
            if (Util.sameValues(this.mDescInMeta, other.descInMeta())) {
                this.mDescInMeta = null;
            }
            if (Util.sameValues(this.mDesc, other.getDesc())) {
                this.mDesc = null;
            }
            if (Util.sameValues(this.mDescHtml, other.getDescHtml())) {
                this.mDescHtml = null;
            }
            if (Util.sameValues(this.mIsAllDay, other.isAllDay())) {
                this.mIsAllDay = null;
            }
            if (Util.sameValues(this.mStatus, other.getStatus())) {
                this.mStatus = null;
            }
            if (Util.sameValues(this.mPriority, other.getPriority())) {
                this.mPriority = null;
            }
            if (Util.sameValues(this.mClassProp, other.getClassProp())) {
                this.mClassProp = null;
            }
            if (Util.sameValues(this.mFreeBusyIntended, other.getFreeBusyIntended())) {
                this.mFreeBusyIntended = null;
            }
            if (Util.sameValues(this.mTransparency, other.getTransparency())) {
                this.mTransparency = null;
            }
            if (Util.sameValues(this.mCategories, other.getCategories())) {
                this.mCategories = null;
            }
            if (Util.sameValues(this.mGeo, other.getGeo())) {
                this.mGeo = null;
            }
        }
    }

    FullInstanceData(Metadata meta) throws ServiceException {
        super(meta);
        int num;
        int invId = (int)meta.getLong(FN_INVID);
        int compNum = (int)meta.getLong(FN_COMPNUM);
        long recurId = meta.getLong(FN_RECURRENCE_ID);
        int seq = (int)meta.getLong(FN_SEQUENCE);
        long dtStamp = meta.getLong(FN_DTSTAMP);
        ZOrganizer org = null;
        Metadata metaOrg = meta.getMap(FN_ORGANIZER, true);
        if (metaOrg != null) {
            org = new ZOrganizer(metaOrg);
        }
        Boolean isOrg = null;
        if (meta.containsKey(FN_IS_ORGANIZER)) {
            isOrg = new Boolean(meta.getBool(FN_IS_ORGANIZER));
        }
        ArrayList<ZAttendee> attendees = null;
        if (meta.containsKey(FN_NUM_ATTENDEES) && (num = (int)meta.getLong(FN_NUM_ATTENDEES)) > 0) {
            attendees = new ArrayList<ZAttendee>(num);
            for (int i = 0; i < num; ++i) {
                Metadata metaAt = meta.getMap(FN_ATTENDEE + i, true);
                if (metaAt == null) continue;
                attendees.add(new ZAttendee(metaAt));
            }
        }
        Boolean hasAlarm = null;
        if (meta.containsKey(FN_HAS_ALARM)) {
            hasAlarm = new Boolean(meta.getBool(FN_HAS_ALARM));
        }
        Boolean hasAttachment = null;
        if (meta.containsKey(FN_HAS_ATTACHMENT)) {
            hasAttachment = new Boolean(meta.getBool(FN_HAS_ATTACHMENT));
        }
        String summary = meta.get(FN_SUMMARY, null);
        String location = meta.get(FN_LOCATION, null);
        String fragment = meta.get(FN_FRAGMENT, null);
        Boolean descInMeta = null;
        if (meta.containsKey(FN_DESC_IN_META)) {
            descInMeta = new Boolean(meta.getBool(FN_DESC_IN_META));
        }
        String desc = meta.get(FN_DESC, null);
        String descHtml = meta.get(FN_DESC_HTML, null);
        Boolean isAllDay = null;
        if (meta.containsKey(FN_IS_ALLDAY)) {
            isAllDay = new Boolean(meta.getBool(FN_IS_ALLDAY));
        }
        String status = meta.get(FN_STATUS, null);
        String priority = meta.get(FN_PRIORITY, null);
        String classProp = meta.get(FN_CLASS, null);
        String fb = meta.get(FN_FREEBUSY, null);
        String transp = meta.get(FN_TRANSPARENCY, null);
        ArrayList<String> categories = null;
        int numCat = (int)meta.getLong(FN_NUM_CATEGORIES, 0L);
        if (numCat > 0) {
            categories = new ArrayList<String>();
            for (int i = 0; i < numCat; ++i) {
                String cat = meta.get(FN_CATEGORY + i, null);
                if (cat == null) continue;
                categories.add(cat);
            }
        }
        Geo geo = null;
        Metadata metaGeo = meta.getMap(FN_GEO, true);
        if (metaGeo != null) {
            geo = Geo.decodeMetadata(metaGeo);
        }
        this.init(invId, compNum, recurId, seq, dtStamp, org, isOrg, attendees, hasAlarm, hasAttachment, summary, location, fragment, descInMeta, desc, descHtml, isAllDay, status, priority, classProp, fb, transp, categories, geo);
    }

    @Override
    Metadata encodeMetadata() {
        int numCat;
        Metadata meta = super.encodeMetadata();
        meta.put(FN_IS_FULL_INSTANCE, true);
        meta.put(FN_INVID, this.mInvId);
        meta.put(FN_COMPNUM, this.mCompNum);
        meta.put(FN_RECURRENCE_ID, this.mRecurrenceId);
        meta.put(FN_SEQUENCE, this.mSequence);
        meta.put(FN_DTSTAMP, this.mDtStamp);
        if (this.mOrganizer != null) {
            meta.put(FN_ORGANIZER, this.mOrganizer.encodeMetadata());
        }
        if (this.mIsOrganizer != null) {
            meta.put(FN_IS_ORGANIZER, this.mIsOrganizer);
        }
        if (this.mAttendees != null) {
            meta.put(FN_NUM_ATTENDEES, this.mAttendees.size());
            int i = 0;
            for (ZAttendee at : this.mAttendees) {
                meta.put(FN_ATTENDEE + i, at.encodeAsMetadata());
                ++i;
            }
        }
        if (this.mHasAlarm != null) {
            meta.put(FN_HAS_ALARM, this.mHasAlarm);
        }
        if (this.mHasAttachment != null) {
            meta.put(FN_HAS_ATTACHMENT, this.mHasAttachment);
        }
        meta.put(FN_SUMMARY, this.mSummary);
        meta.put(FN_LOCATION, this.mLocation);
        meta.put(FN_FRAGMENT, this.mFragment);
        if (this.mDescInMeta != null) {
            meta.put(FN_DESC_IN_META, this.mDescInMeta);
        }
        meta.put(FN_DESC, this.mDesc);
        meta.put(FN_DESC_HTML, this.mDescHtml);
        if (this.mIsAllDay != null) {
            meta.put(FN_IS_ALLDAY, this.mIsAllDay);
        }
        meta.put(FN_STATUS, this.mStatus);
        meta.put(FN_PRIORITY, this.mPriority);
        meta.put(FN_CLASS, this.mClassProp);
        meta.put(FN_FREEBUSY, this.mFreeBusyIntended);
        meta.put(FN_TRANSPARENCY, this.mTransparency);
        if (this.mCategories != null && (numCat = this.mCategories.size()) > 0) {
            meta.put(FN_NUM_CATEGORIES, numCat);
            int i = 0;
            for (String cat : this.mCategories) {
                meta.put(FN_CATEGORY + i, cat);
                ++i;
            }
        }
        if (this.mGeo != null) {
            meta.put(FN_GEO, this.mGeo.encodeMetadata());
        }
        return meta;
    }

    public static boolean isFullInstanceMeta(Metadata meta) throws ServiceException {
        return meta.getBool(FN_IS_FULL_INSTANCE, false);
    }
}

