/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.cache.CalendarData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FileStore {
    private static final String FILE_EXT = ".dat";
    private static final int MBOX_GROUP_BITS = 8;
    private static final int MBOX_BITS = 12;
    private static final int FILE_GROUP_BITS = 8;
    private static final int FILE_BITS = 12;
    private static final int CURRENT_VERSION = 3;
    private static final String FN_VERSION = "ver";
    private static final String FN_CALDATA = "calData";
    private static final String FN_MODSEQ = "modSeq";
    private static final long MAX_CACHE_FILE_LEN = 0x6400000L;

    private static File getMailboxDir(long mboxId) {
        long mdir = mboxId >> 12;
        StringBuilder sb = new StringBuilder(LC.calendar_cache_directory.value());
        sb.append(File.separator).append(mdir &= 8L).append(File.separator).append(mboxId);
        return new File(sb.toString());
    }

    private static File getCalFolderFile(long mboxId, int folderId) {
        long mdir = mboxId >> 12;
        long fdir = folderId >> 12;
        fdir &= 8L;
        StringBuilder sb = new StringBuilder(LC.calendar_cache_directory.value());
        sb.append(File.separator).append(mdir &= 8L).append(File.separator).append(mboxId);
        sb.append(File.separator).append(mdir).append(File.separator).append(folderId).append(FILE_EXT);
        return new File(sb.toString());
    }

    static void deleteCalendarData(long mboxId, int folderId) throws ServiceException {
        File file = FileStore.getCalFolderFile(mboxId, folderId);
        if (file.exists()) {
            file.delete();
        }
    }

    static void saveCalendarData(long mboxId, CalendarData calData) throws ServiceException {
        File file = FileStore.getCalFolderFile(mboxId, calData.getFolderId());
        try {
            FileUtil.ensureDirExists(file.getParentFile());
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to create directory " + file.getParentFile().getAbsolutePath(), e);
        }
        Metadata meta = new Metadata();
        meta.put(FN_VERSION, 3L);
        meta.put(FN_MODSEQ, calData.getModSeq());
        meta.put(FN_CALDATA, calData.encodeMetadata());
        String encoded = meta.toString();
        FileStore.saveToFile(file, encoded);
    }

    static CalendarData loadCalendarData(long mboxId, int folderId, int modSeq) throws ServiceException {
        File file = FileStore.getCalFolderFile(mboxId, folderId);
        String encoded = FileStore.loadFromFile(file);
        if (encoded == null) {
            return null;
        }
        Metadata meta = new Metadata(encoded);
        if (!meta.containsKey(FN_VERSION)) {
            ZimbraLog.calendar.warn("Cache file missing version field: path=" + file.getAbsolutePath());
            return null;
        }
        int ver = (int)meta.getLong(FN_VERSION);
        if (ver < 3) {
            if (ZimbraLog.calendar.isDebugEnabled()) {
                ZimbraLog.calendar.debug("Cached data's version is too old: cached=" + ver + ", expected=" + 3 + ", path=" + file.getAbsolutePath());
            }
            return null;
        }
        int modSeqSaved = (int)meta.getLong(FN_MODSEQ);
        if (modSeqSaved > modSeq) {
            ZimbraLog.calendar.warn("Ignoring cached data in the future: saved modseq=" + modSeqSaved + ", needed modseq=" + modSeq + ", path=" + file.getAbsolutePath());
            return null;
        }
        Metadata metaCalData = meta.getMap(FN_CALDATA, true);
        if (metaCalData == null) {
            ZimbraLog.calendar.warn("Cache file missing actual data: path=" + file.getAbsolutePath());
            return null;
        }
        return new CalendarData(metaCalData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveToFile(File file, String str) throws ServiceException {
        File tmpFile = new File(file.getAbsolutePath() + ".tmp");
        try {
            block9: {
                FileOutputStream fos;
                block8: {
                    Writer writer = null;
                    fos = null;
                    try {
                        fos = new FileOutputStream(tmpFile);
                        writer = new OutputStreamWriter((OutputStream)fos, "utf-8");
                        writer.write(str);
                        Object var6_6 = null;
                        if (writer == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (writer != null) {
                            writer.close();
                        } else if (fos != null) {
                            fos.close();
                        }
                        throw throwable;
                    }
                    writer.close();
                    break block9;
                }
                if (fos != null) {
                    fos.close();
                }
            }
            tmpFile.renameTo(file);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException while saving to " + file.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadFromFile(File file) throws ServiceException {
        if (!file.exists()) {
            return null;
        }
        try {
            String string;
            long length = file.length();
            if (length > 0x6400000L) {
                ZimbraLog.calendar.warn("Cache file too big: %d bytes (%d max): path=%s", length, 0x6400000L, file.getAbsolutePath());
                return null;
            }
            byte[] buf = new byte[(int)length];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                int bytesRead = fis.read(buf);
                if ((long)bytesRead < length) {
                    throw ServiceException.FAILURE("Read " + bytesRead + " bytes when expecting " + length + " bytes, from file " + file.getAbsolutePath(), null);
                }
                string = new String(buf, "utf-8");
                Object var8_8 = null;
                if (fis == null) return string;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (fis != null) {
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
            return string;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException while reading from " + file.getAbsolutePath(), e);
        }
    }

    static void removeMailbox(long mboxId) {
        File dir = FileStore.getMailboxDir(mboxId);
        try {
            FileUtil.deleteDir(dir);
        }
        catch (IOException e) {
            ZimbraLog.calendar.warn((Object)("Unable to delete calendar cache for mailbox " + mboxId), e);
        }
    }
}

