/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.memcached.MemcachedKey;
import com.zimbra.common.util.memcached.MemcachedMap;
import com.zimbra.common.util.memcached.MemcachedSerializer;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.memcached.MemcachedConnector;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class CtagResponseCache {
    private MemcachedMap<CtagResponseCacheKey, CtagResponseCacheValue> mMemcachedLookup;

    CtagResponseCache() {
        ZimbraMemcachedClient memcachedClient = MemcachedConnector.getClient();
        CtagResponseSerializer serializer = new CtagResponseSerializer();
        this.mMemcachedLookup = new MemcachedMap(memcachedClient, serializer);
    }

    public CtagResponseCacheValue get(CtagResponseCacheKey key) throws ServiceException {
        return this.mMemcachedLookup.get(key);
    }

    public void put(CtagResponseCacheKey key, CtagResponseCacheValue value) throws ServiceException {
        this.mMemcachedLookup.put(key, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CtagResponseCacheValue {
        private byte[] mRespBody;
        private int mRawLen;
        private boolean mGzipped;
        private String mVersion;
        private Map<Integer, String> mCtags;
        private static final String FN_RESPONSE_BODY = "b";
        private static final String FN_BODY_LENGTH = "bl";
        private static final String FN_RAW_LENGTH = "rl";
        private static final String FN_IS_GZIPPED = "gz";
        private static final String FN_CALLIST_VERSION = "clv";
        private static final String FN_NUM_CTAGS = "nct";
        private static final String FN_CTAGS_CAL_ID = "ci";
        private static final String FN_CTAGS_CTAG = "ct";

        public CtagResponseCacheValue(byte[] respBody, int rawLen, boolean gzipped, String calListVer, Map<Integer, String> ctags) {
            this.mRespBody = respBody;
            if (gzipped) {
                this.mRawLen = rawLen;
                this.mGzipped = gzipped;
            } else {
                this.mRawLen = respBody.length;
                this.mGzipped = false;
            }
            this.mVersion = calListVer;
            this.mCtags = ctags;
        }

        public byte[] getResponseBody() {
            return this.mRespBody;
        }

        public int getRawLength() {
            return this.mRawLen;
        }

        public boolean isGzipped() {
            return this.mGzipped;
        }

        public String getVersion() {
            return this.mVersion;
        }

        public Map<Integer, String> getCtags() {
            return this.mCtags;
        }

        Metadata encodeMetadata() throws ServiceException {
            Metadata meta = new Metadata();
            String body = null;
            try {
                body = new String(this.mRespBody, "iso-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw ServiceException.FAILURE("Unable to encode ctag response body", e);
            }
            meta.put(FN_BODY_LENGTH, this.mRespBody.length);
            meta.put(FN_RESPONSE_BODY, body);
            meta.put(FN_RAW_LENGTH, this.mRawLen);
            if (this.mGzipped) {
                meta.put(FN_IS_GZIPPED, true);
            }
            meta.put(FN_CALLIST_VERSION, this.mVersion);
            int i = 0;
            for (Map.Entry<Integer, String> entry : this.mCtags.entrySet()) {
                meta.put(FN_CTAGS_CAL_ID + i, entry.getKey());
                meta.put(FN_CTAGS_CTAG + i, entry.getValue());
                ++i;
            }
            meta.put(FN_NUM_CTAGS, i);
            return meta;
        }

        CtagResponseCacheValue(Metadata meta) throws ServiceException {
            int bodyLen = (int)meta.getLong(FN_BODY_LENGTH, 0L);
            String body = meta.get(FN_RESPONSE_BODY, null);
            if (body == null) {
                throw ServiceException.FAILURE("Ctag response body not found in cached entry", null);
            }
            if (body.length() != bodyLen) {
                throw ServiceException.FAILURE("Ctag response body has wrong length: " + body.length() + " when expecting " + bodyLen, null);
            }
            try {
                this.mRespBody = body.getBytes("iso-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw ServiceException.FAILURE("Unable to decode ctag response body", e);
            }
            this.mRawLen = (int)meta.getLong(FN_RAW_LENGTH, 0L);
            this.mGzipped = meta.getBool(FN_IS_GZIPPED, false);
            this.mVersion = meta.get(FN_CALLIST_VERSION, "");
            int numCtags = (int)meta.getLong(FN_NUM_CTAGS, 0L);
            this.mCtags = new HashMap<Integer, String>(Math.min(numCtags, 100));
            if (numCtags > 0) {
                for (int i = 0; i < numCtags; ++i) {
                    int calId = (int)meta.getLong(FN_CTAGS_CAL_ID + i, -1L);
                    String ctag = meta.get(FN_CTAGS_CTAG + i, null);
                    if (calId == -1 || ctag == null) break;
                    this.mCtags.put(calId, ctag);
                }
            }
        }
    }

    public static class CtagResponseCacheKey
    implements MemcachedKey {
        private String mAccountId;
        private String mUserAgent;
        private int mRootFolderId;
        private String mKeyVal;

        public CtagResponseCacheKey(String accountId, String userAgent, int rootFolderId) {
            this.mAccountId = accountId;
            this.mUserAgent = userAgent;
            this.mRootFolderId = rootFolderId;
            this.mKeyVal = String.format("%s:%s:%d", this.mAccountId, this.mUserAgent, this.mRootFolderId);
        }

        public String getAccountId() {
            return this.mAccountId;
        }

        public String getUserAgent() {
            return this.mUserAgent;
        }

        public int getRootFolderId() {
            return this.mRootFolderId;
        }

        public boolean equals(Object other) {
            if (other instanceof CtagResponseCacheKey) {
                CtagResponseCacheKey otherKey = (CtagResponseCacheKey)other;
                return this.mKeyVal.equals(otherKey.mKeyVal);
            }
            return false;
        }

        public int hashCode() {
            return this.mKeyVal.hashCode();
        }

        public String getKeyPrefix() {
            return "zmCtagResp:";
        }

        public String getKeyValue() {
            return this.mKeyVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CtagResponseSerializer
    implements MemcachedSerializer<CtagResponseCacheValue> {
        private CtagResponseSerializer() {
        }

        @Override
        public Object serialize(CtagResponseCacheValue value) throws ServiceException {
            return value.encodeMetadata().toString();
        }

        @Override
        public CtagResponseCacheValue deserialize(Object obj) throws ServiceException {
            Metadata meta = new Metadata((String)obj);
            return new CtagResponseCacheValue(meta);
        }
    }
}

