/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.memcached.MemcachedMap;
import com.zimbra.common.util.memcached.MemcachedSerializer;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.cache.CalendarKey;
import com.zimbra.cs.mailbox.calendar.cache.CtagInfo;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtagInfoCache {
    private MemcachedMap<CalendarKey, CtagInfo> mMemcachedLookup;

    CtagInfoCache() {
        ZimbraMemcachedClient memcachedClient = MemcachedConnector.getClient();
        CtagInfoSerializer serializer = new CtagInfoSerializer();
        this.mMemcachedLookup = new MemcachedMap(memcachedClient, serializer);
    }

    public boolean containsKey(CalendarKey key) throws ServiceException {
        return this.mMemcachedLookup.get(key) != null;
    }

    public CtagInfo get(CalendarKey key) throws ServiceException {
        return this.get(key, false);
    }

    private CtagInfo get(CalendarKey key, boolean wasMountpoint) throws ServiceException {
        CtagInfo info = this.mMemcachedLookup.get(key);
        if (info != null && !info.isMountpoint()) {
            return info;
        }
        boolean needToPut = false;
        if (info == null) {
            info = this.getFolder(key);
            needToPut = true;
        }
        if (info != null) {
            if (info.isMountpoint() && !wasMountpoint) {
                CalendarKey keyTarget = new CalendarKey(info.getRemoteAccount(), info.getRemoteId());
                CtagInfo infoTarget = this.get(keyTarget, true);
                if (infoTarget != null) {
                    String remoteCtag = infoTarget.getCtag();
                    if (!remoteCtag.equals(info.getCtag())) {
                        info.setCtag(remoteCtag);
                        needToPut = true;
                    }
                } else {
                    ZimbraLog.calendar.warn("Mounpoint target %s:%d not found during cache lookup", keyTarget.getAccountId(), keyTarget.getFolderId());
                }
            }
            if (needToPut) {
                this.mMemcachedLookup.put(key, info);
            }
        }
        return info;
    }

    public Map<CalendarKey, CtagInfo> getMultiSerial(List<CalendarKey> keys) throws ServiceException {
        HashMap<CalendarKey, CtagInfo> result = new HashMap<CalendarKey, CtagInfo>(keys.size());
        for (CalendarKey key : keys) {
            CtagInfo value = this.get(key);
            result.put(key, value);
        }
        return result;
    }

    public Map<CalendarKey, CtagInfo> getMulti(List<CalendarKey> keys) throws ServiceException {
        HashMap<CalendarKey, CtagInfo> toPut = new HashMap<CalendarKey, CtagInfo>(keys.size());
        Map<CalendarKey, CtagInfo> result = this.mMemcachedLookup.getMulti(keys);
        for (Map.Entry<CalendarKey, CtagInfo> entry : result.entrySet()) {
            String remoteCtag;
            CalendarKey keyTarget;
            CtagInfo target;
            CalendarKey key = entry.getKey();
            CtagInfo info = entry.getValue();
            boolean needToPut = false;
            if (info == null) {
                info = this.getFolder(key);
                needToPut = true;
            }
            if (info == null) continue;
            if (info.isMountpoint() && (target = this.get(keyTarget = new CalendarKey(info.getRemoteAccount(), info.getRemoteId()), true)) != null && !(remoteCtag = target.getCtag()).equals(info.getCtag())) {
                info.setCtag(remoteCtag);
                needToPut = true;
            }
            if (!needToPut) continue;
            toPut.put(key, info);
            entry.setValue(info);
        }
        this.mMemcachedLookup.putMulti(toPut);
        return result;
    }

    private CtagInfo getFolder(CalendarKey key) throws ServiceException {
        String accountId = key.getAccountId();
        int folderId = key.getFolderId();
        CtagInfo calInfo = null;
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.id, accountId);
        if (acct == null) {
            ZimbraLog.calendar.warn("Invalid account %s during cache lookup", accountId);
            return null;
        }
        if (Provisioning.onLocalServer(acct)) {
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct);
            Folder folder = mbox.getFolderById(null, folderId);
            if (folder != null) {
                calInfo = new CtagInfo(folder);
            } else {
                ZimbraLog.calendar.warn("Invalid folder %d in account %s during cache lookup", folderId, accountId);
            }
        } else {
            ZAuthToken zat = AuthToken.getZimbraAdminAuthToken().toZAuthToken();
            ZMailbox.Options zoptions = new ZMailbox.Options(zat, AccountUtil.getSoapUri(acct));
            zoptions.setNoSession(true);
            zoptions.setResponseProtocol(SoapProtocol.SoapJS);
            zoptions.setTargetAccount(acct.getId());
            zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
            ZMailbox zmbx = ZMailbox.getMailbox(zoptions);
            ItemId iidFolder = new ItemId(accountId, folderId);
            ZFolder zfolder = zmbx.getFolderById(iidFolder.toString());
            if (zfolder != null) {
                calInfo = new CtagInfo(zfolder);
            } else {
                ZimbraLog.calendar.warn("Invalid folder %d in account %s during cache lookup", folderId, accountId);
            }
        }
        return calInfo;
    }

    void purgeMailbox(Mailbox mbox) throws ServiceException {
        String accountId = mbox.getAccountId();
        List<Folder> folders = mbox.getCalendarFolders(null, SortBy.NONE);
        ArrayList<CalendarKey> keys = new ArrayList<CalendarKey>(folders.size());
        for (Folder folder : folders) {
            CalendarKey key = new CalendarKey(accountId, folder.getId());
            keys.add(key);
        }
        this.mMemcachedLookup.removeMulti(keys);
    }

    void notifyCommittedChanges(PendingModifications mods, int changeId) {
        int inboxFolder = 2;
        HashSet<CalendarKey> keysToInvalidate = new HashSet<CalendarKey>();
        if (mods.created != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.created.entrySet()) {
                Message msg;
                MailItem item = (MailItem)entry.getValue();
                if (!(item instanceof Message) || !(msg = (Message)item).hasCalendarItemInfos() || msg.getFolderId() != inboxFolder) continue;
                CalendarKey key = new CalendarKey(msg.getMailbox().getAccountId(), inboxFolder);
                keysToInvalidate.add(key);
            }
        }
        if (mods.modified != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.modified.entrySet()) {
                Message msg;
                PendingModifications.Change change = (PendingModifications.Change)entry.getValue();
                Object whatChanged = change.what;
                if (whatChanged instanceof Folder) {
                    Folder folder = (Folder)whatChanged;
                    byte viewType = folder.getDefaultView();
                    if (viewType != 11 && viewType != 15) continue;
                    CalendarKey key = new CalendarKey(folder.getMailbox().getAccountId(), folder.getId());
                    keysToInvalidate.add(key);
                    continue;
                }
                if (!(whatChanged instanceof Message) || !(msg = (Message)whatChanged).hasCalendarItemInfos() || msg.getFolderId() != inboxFolder && (change.why & 0x100) == 0) continue;
                CalendarKey key = new CalendarKey(msg.getMailbox().getAccountId(), inboxFolder);
                keysToInvalidate.add(key);
            }
        }
        if (mods.deleted != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.deleted.entrySet()) {
                String acctId;
                CalendarKey key;
                Object deletedObj = entry.getValue();
                if (deletedObj instanceof Folder) {
                    Folder folder = (Folder)deletedObj;
                    byte viewType = folder.getDefaultView();
                    if (viewType != 11 && viewType != 15) continue;
                    key = new CalendarKey(folder.getMailbox().getAccountId(), folder.getId());
                    keysToInvalidate.add(key);
                    continue;
                }
                if (!(deletedObj instanceof Integer) || (acctId = entry.getKey().getAccountId()) == null) continue;
                int itemId = (Integer)deletedObj;
                key = new CalendarKey(acctId, itemId);
                keysToInvalidate.add(key);
            }
        }
        try {
            this.mMemcachedLookup.removeMulti(keysToInvalidate);
        }
        catch (ServiceException e) {
            ZimbraLog.calendar.warn((Object)"Unable to notify ctag info cache.  Some cached data may become stale.", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CtagInfoSerializer
    implements MemcachedSerializer<CtagInfo> {
        private CtagInfoSerializer() {
        }

        @Override
        public Object serialize(CtagInfo value) {
            return value.encodeMetadata().toString();
        }

        @Override
        public CtagInfo deserialize(Object obj) throws ServiceException {
            Metadata meta = new Metadata((String)obj);
            return new CtagInfo(meta);
        }
    }
}

