/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMountpoint;

public class CtagInfo {
    private int mId;
    private int mFolderId;
    private String mCtag;
    private String mPath;
    private boolean mIsMountpoint;
    private String mRemoteAccount;
    private int mRemoteId;
    private static final String FN_ID = "i";
    private static final String FN_FOLDER_ID = "f";
    private static final String FN_PATH = "p";
    private static final String FN_CTAG = "c";
    private static final String FN_REMOTE_ACCOUNT = "ra";
    private static final String FN_REMOTE_ID = "ri";

    public int getId() {
        return this.mId;
    }

    public int getFolderId() {
        return this.mFolderId;
    }

    public String getCtag() {
        return this.mCtag;
    }

    public String getPath() {
        return this.mPath;
    }

    public boolean isMountpoint() {
        return this.mIsMountpoint;
    }

    public String getRemoteAccount() {
        return this.mRemoteAccount;
    }

    public int getRemoteId() {
        return this.mRemoteId;
    }

    CtagInfo(Folder calFolder) {
        boolean isMountpoint = calFolder instanceof Mountpoint;
        String remoteAccount = null;
        int remoteId = -1;
        if (isMountpoint) {
            Mountpoint mp = (Mountpoint)calFolder;
            remoteAccount = mp.getOwnerId();
            remoteId = mp.getRemoteId();
        }
        String ctag = CtagInfo.makeCtag(calFolder);
        this.init(calFolder.getId(), calFolder.getFolderId(), ctag, calFolder.getPath(), isMountpoint, remoteAccount, remoteId);
    }

    CtagInfo(ZFolder calFolder) throws ServiceException {
        boolean isMountpoint = calFolder instanceof ZMountpoint;
        String remoteAccount = null;
        int remoteId = -1;
        if (isMountpoint) {
            ZMountpoint mp = (ZMountpoint)calFolder;
            remoteAccount = mp.getOwnerId();
            remoteId = Integer.parseInt(mp.getRemoteId());
        }
        String ctag = CtagInfo.makeCtag(calFolder);
        ItemId iidId = new ItemId(calFolder.getId(), (String)null);
        int id = iidId.getId();
        int folderId = 1;
        String folderIdStr = calFolder.getParentId();
        if (folderIdStr != null && folderIdStr.length() > 0) {
            ItemId iidFolderId = new ItemId(folderIdStr, (String)null);
            folderId = iidFolderId.getId();
        }
        this.init(id, folderId, ctag, calFolder.getPath(), isMountpoint, remoteAccount, remoteId);
    }

    private void init(int id, int parentFolderId, String ctag, String path, boolean isMountpoint, String remoteAccountId, int remoteId) {
        this.mId = id;
        this.mFolderId = parentFolderId;
        this.mCtag = ctag;
        this.mIsMountpoint = isMountpoint;
        if (this.mIsMountpoint) {
            this.mRemoteAccount = remoteAccountId;
            this.mRemoteId = remoteId;
        }
        this.mPath = path != null && !path.endsWith("/") ? path + "/" : path;
    }

    void setCtag(String ctag) {
        this.mCtag = ctag;
    }

    private static String makeCtag(int modMetadata, int imapModseq) {
        return String.format("%d-%d", modMetadata, imapModseq);
    }

    public static String makeCtag(Folder calFolder) {
        return CtagInfo.makeCtag(calFolder.getModifiedSequence(), calFolder.getImapMODSEQ());
    }

    public static String makeCtag(ZFolder calFolder) {
        return CtagInfo.makeCtag(calFolder.getModifiedSequence(), calFolder.getImapMODSEQ());
    }

    Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_ID, this.mId);
        meta.put(FN_FOLDER_ID, this.mFolderId);
        meta.put(FN_PATH, this.mPath);
        meta.put(FN_CTAG, this.mCtag);
        if (this.mIsMountpoint) {
            meta.put(FN_REMOTE_ACCOUNT, this.mRemoteAccount);
            meta.put(FN_REMOTE_ID, this.mRemoteId);
        }
        return meta;
    }

    CtagInfo(Metadata meta) throws ServiceException {
        int remoteId;
        boolean isMountpoint;
        int id = (int)meta.getLong(FN_ID, -1L);
        int folderId = (int)meta.getLong(FN_FOLDER_ID, -1L);
        String path = meta.get(FN_PATH, null);
        String ctag = meta.get(FN_CTAG, null);
        String remoteAccountId = meta.get(FN_REMOTE_ACCOUNT, null);
        if (remoteAccountId == null) {
            isMountpoint = false;
            remoteId = -1;
        } else {
            isMountpoint = true;
            remoteId = (int)meta.getLong(FN_REMOTE_ID, -1L);
        }
        this.init(id, folderId, ctag, path, isMountpoint, remoteAccountId, remoteId);
    }
}

