/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.cache.AlarmData;
import com.zimbra.cs.mailbox.calendar.cache.FullInstanceData;
import com.zimbra.cs.mailbox.calendar.cache.InstanceData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarItemData {
    private byte mType;
    private int mFolderId;
    private int mCalItemId;
    private String mFlags;
    private String mTags;
    private boolean mIsPublic;
    private int mModMetadata;
    private int mModContent;
    private long mDate;
    private long mChangeDate;
    private long mSize;
    private String mUid;
    private boolean mIsRecurring;
    private AlarmData mAlarm;
    private FullInstanceData mDefaultData;
    private List<InstanceData> mInstances;
    private long mActualRangeStart;
    private long mActualRangeEnd;
    private static final String FN_TYPE = "type";
    private static final String FN_FOLDER_ID = "fid";
    private static final String FN_CALITEM_ID = "ciid";
    private static final String FN_FLAGS = "flag";
    private static final String FN_TAGS = "tag";
    private static final String FN_IS_PUBLIC = "isPub";
    private static final String FN_MOD_METADATA = "modM";
    private static final String FN_MOD_CONTENT = "modC";
    private static final String FN_DATE = "d";
    private static final String FN_CHANGE_DATE = "cd";
    private static final String FN_SIZE = "sz";
    private static final String FN_UID = "uid";
    private static final String FN_IS_RECURRING = "isRecur";
    private static final String FN_ALARM = "alarm";
    private static final String FN_DEFAULT_INST = "defInst";
    private static final String FN_NUM_INST = "numInst";
    private static final String FN_INST = "inst";
    private static final String FN_RANGE_START = "rgStart";
    private static final String FN_RANGE_END = "rgEnd";

    public byte getType() {
        return this.mType;
    }

    public int getFolderId() {
        return this.mFolderId;
    }

    public int getCalItemId() {
        return this.mCalItemId;
    }

    public String getFlags() {
        return this.mFlags;
    }

    public String getTags() {
        return this.mTags;
    }

    public boolean isPublic() {
        return this.mIsPublic;
    }

    public int getModMetadata() {
        return this.mModMetadata;
    }

    public int getModContent() {
        return this.mModContent;
    }

    public long getDate() {
        return this.mDate;
    }

    public long getChangeDate() {
        return this.mChangeDate;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getUid() {
        return this.mUid;
    }

    public boolean isRecurring() {
        return this.mIsRecurring;
    }

    public AlarmData getAlarm() {
        return this.mAlarm;
    }

    public boolean hasAlarm() {
        return this.mAlarm != null;
    }

    public FullInstanceData getDefaultData() {
        return this.mDefaultData;
    }

    public Iterator<InstanceData> instanceIterator() {
        return this.mInstances.iterator();
    }

    public long getActualRangeStart() {
        return this.mActualRangeStart;
    }

    public long getActualRangeEnd() {
        return this.mActualRangeEnd;
    }

    void setActualRange(long start, long end) {
        this.mActualRangeStart = start;
        this.mActualRangeEnd = end;
    }

    CalendarItemData(byte type, int folderId, int calItemId, String flags, String tags, int modMetadata, int modContent, long date, long changeDate, long size, String uid, boolean isRecurring, boolean isPublic, AlarmData alarm, FullInstanceData defaultData) {
        this.mType = type;
        this.mFolderId = folderId;
        this.mCalItemId = calItemId;
        this.mFlags = flags;
        this.mTags = tags;
        this.mModMetadata = modMetadata;
        this.mModContent = modContent;
        this.mDate = date;
        this.mChangeDate = changeDate;
        this.mSize = size;
        this.mUid = uid;
        this.mIsRecurring = isRecurring;
        this.mIsPublic = isPublic;
        this.mAlarm = alarm;
        this.mDefaultData = defaultData;
        this.mInstances = new ArrayList<InstanceData>();
    }

    void addInstance(InstanceData instance) {
        this.mInstances.add(instance);
    }

    public int getNumInstances() {
        return this.mInstances.size();
    }

    public CalendarItemData getSubRange(long rangeStart, long rangeEnd) {
        if (rangeStart <= this.mActualRangeStart && rangeEnd >= this.mActualRangeEnd) {
            return this;
        }
        CalendarItemData calItemData = new CalendarItemData(this.mType, this.mFolderId, this.mCalItemId, this.mFlags, this.mTags, this.mModMetadata, this.mModContent, this.mDate, this.mChangeDate, this.mSize, this.mUid, this.mIsRecurring, this.mIsPublic, this.mAlarm, this.mDefaultData);
        long defaultDuration = this.mDefaultData.getDuration() != null ? this.mDefaultData.getDuration() : 0L;
        for (InstanceData inst : this.mInstances) {
            long alarmAt;
            long l = alarmAt = inst.getAlarmAt() != null ? inst.getAlarmAt() : 0L;
            if (rangeStart <= alarmAt && alarmAt < rangeEnd) {
                calItemData.addInstance(inst);
                continue;
            }
            if (inst.getDtStart() != null) {
                long instStart = inst.getDtStart();
                Long instDuration = inst.getDuration();
                long duration = instDuration != null ? instDuration : defaultDuration;
                long instEnd = instStart + duration;
                if ((instStart != 0L || instEnd != 0L) && (instStart >= rangeEnd || instEnd <= rangeStart)) continue;
                calItemData.addInstance(inst);
                continue;
            }
            calItemData.addInstance(inst);
        }
        if (calItemData.getNumInstances() > 0) {
            return calItemData;
        }
        return null;
    }

    CalendarItemData(Metadata meta) throws ServiceException {
        int numInst;
        Metadata metaDefInst;
        this.mType = (byte)meta.getLong(FN_TYPE);
        this.mFolderId = (int)meta.getLong(FN_FOLDER_ID);
        this.mCalItemId = (int)meta.getLong(FN_CALITEM_ID);
        this.mFlags = meta.get(FN_FLAGS, null);
        this.mTags = meta.get(FN_TAGS, null);
        this.mIsPublic = meta.getBool(FN_IS_PUBLIC);
        this.mModMetadata = (int)meta.getLong(FN_MOD_METADATA);
        this.mModContent = (int)meta.getLong(FN_MOD_CONTENT);
        this.mDate = meta.getLong(FN_DATE);
        this.mChangeDate = meta.getLong(FN_CHANGE_DATE);
        this.mSize = meta.getLong(FN_SIZE);
        this.mUid = meta.get(FN_UID, null);
        this.mIsRecurring = meta.getBool(FN_IS_RECURRING);
        Metadata metaAlarm = meta.getMap(FN_ALARM, true);
        if (metaAlarm != null) {
            this.mAlarm = new AlarmData(metaAlarm);
        }
        if ((metaDefInst = meta.getMap(FN_DEFAULT_INST, true)) != null) {
            this.mDefaultData = new FullInstanceData(metaDefInst);
        }
        if ((numInst = (int)meta.getLong(FN_NUM_INST, 0L)) > 0) {
            ArrayList<InstanceData> instances = new ArrayList<InstanceData>(numInst);
            for (int i = 0; i < numInst; ++i) {
                Metadata metaInst = meta.getMap(FN_INST + i, true);
                if (metaInst == null) continue;
                InstanceData inst = null;
                inst = FullInstanceData.isFullInstanceMeta(metaInst) ? new FullInstanceData(metaInst) : new InstanceData(metaInst);
                instances.add(inst);
            }
            this.mInstances = instances;
        } else {
            this.mInstances = new ArrayList<InstanceData>(0);
        }
        this.mActualRangeStart = meta.getLong(FN_RANGE_START);
        this.mActualRangeEnd = meta.getLong(FN_RANGE_END);
    }

    Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_TYPE, this.mType);
        meta.put(FN_FOLDER_ID, this.mFolderId);
        meta.put(FN_CALITEM_ID, this.mCalItemId);
        meta.put(FN_FLAGS, this.mFlags);
        meta.put(FN_TAGS, this.mTags);
        meta.put(FN_IS_PUBLIC, this.mIsPublic);
        meta.put(FN_MOD_METADATA, this.mModMetadata);
        meta.put(FN_MOD_CONTENT, this.mModContent);
        meta.put(FN_DATE, this.mDate);
        meta.put(FN_CHANGE_DATE, this.mChangeDate);
        meta.put(FN_SIZE, this.mSize);
        meta.put(FN_UID, this.mUid);
        meta.put(FN_IS_RECURRING, this.mIsRecurring);
        if (this.mAlarm != null) {
            meta.put(FN_ALARM, this.mAlarm.encodeMetadata());
        }
        if (this.mDefaultData != null) {
            meta.put(FN_DEFAULT_INST, this.mDefaultData.encodeMetadata());
        }
        if (this.mInstances != null) {
            meta.put(FN_NUM_INST, this.mInstances.size());
            int i = 0;
            for (InstanceData inst : this.mInstances) {
                meta.put(FN_INST + i, inst.encodeMetadata());
                ++i;
            }
        }
        meta.put(FN_RANGE_START, this.mActualRangeStart);
        meta.put(FN_RANGE_END, this.mActualRangeEnd);
        return meta;
    }
}

