/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.cache.CalendarItemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarData {
    private int mFolderId;
    private int mModSeq;
    private long mRangeStart;
    private long mRangeEnd;
    private List<CalendarItemData> mCalendarItems;
    private Map<Integer, CalendarItemData> mCalendarItemsMap;
    private Set<Integer> mStaleItemIds;
    private static final String FN_FOLDER_ID = "fid";
    private static final String FN_MODSEQ = "modSeq";
    private static final String FN_RANGE_START = "rgStart";
    private static final String FN_RANGE_END = "rgEnd";
    private static final String FN_NUM_CALITEMS = "numCi";
    private static final String FN_CALITEM = "ci";

    CalendarData(int folderId, int modSeq, long rangeStart, long rangeEnd) {
        this.mFolderId = folderId;
        this.mModSeq = modSeq;
        this.mRangeStart = rangeStart;
        this.mRangeEnd = rangeEnd;
        this.mCalendarItems = new ArrayList<CalendarItemData>();
        this.mCalendarItemsMap = new HashMap<Integer, CalendarItemData>();
        this.mStaleItemIds = new HashSet<Integer>();
    }

    void addCalendarItem(CalendarItemData calItemData) {
        this.mCalendarItems.add(calItemData);
        this.mCalendarItemsMap.put(calItemData.getCalItemId(), calItemData);
    }

    public CalendarItemData getCalendarItemData(int calItemId) {
        return this.mCalendarItemsMap.get(calItemId);
    }

    public int getFolderId() {
        return this.mFolderId;
    }

    public int getModSeq() {
        return this.mModSeq;
    }

    public long getRangeStart() {
        return this.mRangeStart;
    }

    public long getRangeEnd() {
        return this.mRangeEnd;
    }

    public Iterator<CalendarItemData> calendarItemIterator() {
        return this.mCalendarItems.iterator();
    }

    public int getNumItems() {
        return this.mCalendarItems.size();
    }

    public CalendarData getSubRange(long rangeStart, long rangeEnd) {
        if (rangeStart <= this.mRangeStart && rangeEnd >= this.mRangeEnd) {
            return this;
        }
        CalendarData calData = new CalendarData(this.mFolderId, this.mModSeq, rangeStart, rangeEnd);
        for (CalendarItemData calItemData : this.mCalendarItems) {
            CalendarItemData itemSubRange = calItemData.getSubRange(rangeStart, rangeEnd);
            if (itemSubRange == null) continue;
            calData.addCalendarItem(itemSubRange);
            int itemId = itemSubRange.getCalItemId();
            if (!this.isItemStale(itemId)) continue;
            calData.markItemStale(itemId);
        }
        return calData;
    }

    synchronized int getNumStaleItems() {
        return this.mStaleItemIds.size();
    }

    synchronized int markItemStale(int calItemId) {
        this.mStaleItemIds.add(calItemId);
        return this.mStaleItemIds.size();
    }

    synchronized boolean isItemStale(int calItemId) {
        return this.mStaleItemIds.contains(calItemId);
    }

    synchronized void copyStaleItemIdsTo(Set<Integer> copyTo) {
        copyTo.addAll(this.mStaleItemIds);
    }

    CalendarData(Metadata meta) throws ServiceException {
        this.mFolderId = (int)meta.getLong(FN_FOLDER_ID);
        this.mModSeq = (int)meta.getLong(FN_MODSEQ);
        this.mRangeStart = meta.getLong(FN_RANGE_START);
        this.mRangeEnd = meta.getLong(FN_RANGE_END);
        int numCalItems = (int)meta.getLong(FN_NUM_CALITEMS);
        if (numCalItems > 0) {
            this.mCalendarItems = new ArrayList<CalendarItemData>(numCalItems);
            this.mCalendarItemsMap = new HashMap<Integer, CalendarItemData>(numCalItems);
            for (int i = 0; i < numCalItems; ++i) {
                Metadata metaCalItem = meta.getMap(FN_CALITEM + i, true);
                if (metaCalItem == null) continue;
                CalendarItemData calItemData = new CalendarItemData(metaCalItem);
                this.addCalendarItem(calItemData);
            }
        } else {
            this.mCalendarItems = new ArrayList<CalendarItemData>(0);
            this.mCalendarItemsMap = new HashMap<Integer, CalendarItemData>(0);
        }
        this.mStaleItemIds = new HashSet<Integer>();
    }

    Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_FOLDER_ID, this.mFolderId);
        meta.put(FN_MODSEQ, this.mModSeq);
        meta.put(FN_RANGE_START, this.mRangeStart);
        meta.put(FN_RANGE_END, this.mRangeEnd);
        meta.put(FN_NUM_CALITEMS, this.mCalendarItems.size());
        int i = 0;
        for (CalendarItemData calItemData : this.mCalendarItems) {
            meta.put(FN_CALITEM + i, calItemData.encodeMetadata());
            ++i;
        }
        return meta;
    }
}

