/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.calendar.cache.AccountCtags;
import com.zimbra.cs.mailbox.calendar.cache.AccountKey;
import com.zimbra.cs.mailbox.calendar.cache.CalList;
import com.zimbra.cs.mailbox.calendar.cache.CalListCache;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryCache;
import com.zimbra.cs.mailbox.calendar.cache.CalendarKey;
import com.zimbra.cs.mailbox.calendar.cache.CtagInfo;
import com.zimbra.cs.mailbox.calendar.cache.CtagInfoCache;
import com.zimbra.cs.mailbox.calendar.cache.CtagResponseCache;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.session.PendingModifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class CalendarCacheManager {
    private boolean mSummaryCacheEnabled;
    private CalSummaryCache mSummaryCache;
    private CalListCache mCalListCache;
    private CtagInfoCache mCtagCache = new CtagInfoCache();
    private CtagResponseCache mCtagResponseCache;
    private static CalendarCacheManager sInstance = new CalendarCacheManager();

    public static CalendarCacheManager getInstance() {
        return sInstance;
    }

    private CalendarCacheManager() {
        this.mCalListCache = new CalListCache();
        this.mCtagResponseCache = new CtagResponseCache();
        int summaryLRUSize = 0;
        this.mSummaryCacheEnabled = LC.calendar_cache_enabled.booleanValue();
        if (this.mSummaryCacheEnabled) {
            summaryLRUSize = LC.calendar_cache_lru_size.intValue();
        }
        this.mSummaryCache = new CalSummaryCache(summaryLRUSize);
    }

    public void notifyCommittedChanges(PendingModifications mods, int changeId) {
        if (this.mSummaryCacheEnabled) {
            this.mSummaryCache.notifyCommittedChanges(mods, changeId);
        }
        if (MemcachedConnector.isConnected()) {
            this.mCalListCache.notifyCommittedChanges(mods, changeId);
            this.mCtagCache.notifyCommittedChanges(mods, changeId);
        }
    }

    public void purgeMailbox(Mailbox mbox) throws ServiceException {
        this.mSummaryCache.purgeMailbox(mbox);
        if (MemcachedConnector.isConnected()) {
            this.mCalListCache.purgeMailbox(mbox);
            this.mCtagCache.purgeMailbox(mbox);
        }
    }

    CtagInfoCache getCtagCache() {
        return this.mCtagCache;
    }

    public CalSummaryCache getSummaryCache() {
        return this.mSummaryCache;
    }

    public CtagResponseCache getCtagResponseCache() {
        return this.mCtagResponseCache;
    }

    public AccountCtags getCtags(AccountKey key) throws ServiceException {
        CalList calList = this.mCalListCache.get(key);
        if (calList == null) {
            return null;
        }
        Collection<Integer> calendarIds = calList.getCalendars();
        ArrayList<CalendarKey> calKeys = new ArrayList<CalendarKey>(calendarIds.size());
        String accountId = key.getAccountId();
        for (int calFolderId : calendarIds) {
            calKeys.add(new CalendarKey(accountId, calFolderId));
        }
        Map<CalendarKey, CtagInfo> ctagsMap = this.mCtagCache.getMulti(calKeys);
        AccountCtags acctCtags = new AccountCtags(calList, ctagsMap.values());
        return acctCtags;
    }
}

