/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.memcached.BigByteArrayMemcachedMap;
import com.zimbra.common.util.memcached.ByteArraySerializer;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryKey;
import com.zimbra.cs.mailbox.calendar.cache.CalendarData;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.session.PendingModifications;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CalSummaryMemcachedCache {
    private BigByteArrayMemcachedMap<CalSummaryKey, CalendarData> mMemcachedLookup;

    CalSummaryMemcachedCache() {
        ZimbraMemcachedClient memcachedClient = MemcachedConnector.getClient();
        CalSummarySerializer serializer = new CalSummarySerializer();
        this.mMemcachedLookup = new BigByteArrayMemcachedMap(memcachedClient, serializer);
    }

    public CalendarData getForRange(CalSummaryKey key, long rangeStart, long rangeEnd) throws ServiceException {
        CalendarData calData = this.mMemcachedLookup.get(key);
        if (calData != null && rangeStart >= calData.getRangeStart() && rangeEnd <= calData.getRangeEnd()) {
            return calData.getSubRange(rangeStart, rangeEnd);
        }
        return null;
    }

    public void put(CalSummaryKey key, CalendarData calData) throws ServiceException {
        this.mMemcachedLookup.put(key, calData);
    }

    void purgeMailbox(Mailbox mbox) throws ServiceException {
        String accountId = mbox.getAccountId();
        List<Folder> folders = mbox.getCalendarFolders(null, SortBy.NONE);
        ArrayList<CalSummaryKey> keys = new ArrayList<CalSummaryKey>(folders.size());
        for (Folder folder : folders) {
            CalSummaryKey key = new CalSummaryKey(accountId, folder.getId());
            keys.add(key);
        }
        this.mMemcachedLookup.removeMulti(keys);
    }

    void notifyCommittedChanges(PendingModifications mods, int changeId) {
        HashSet<CalSummaryKey> keysToInvalidate = new HashSet<CalSummaryKey>();
        if (mods.modified != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.modified.entrySet()) {
                Folder folder;
                byte viewType;
                PendingModifications.Change change = (PendingModifications.Change)entry.getValue();
                Object whatChanged = change.what;
                if (!(whatChanged instanceof Folder) || (viewType = (folder = (Folder)whatChanged).getDefaultView()) != 11 && viewType != 15) continue;
                CalSummaryKey key = new CalSummaryKey(folder.getMailbox().getAccountId(), folder.getId());
                keysToInvalidate.add(key);
            }
        }
        if (mods.deleted != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.deleted.entrySet()) {
                String acctId;
                CalSummaryKey key;
                Object deletedObj = entry.getValue();
                if (deletedObj instanceof Folder) {
                    Folder folder = (Folder)deletedObj;
                    byte viewType = folder.getDefaultView();
                    if (viewType != 11 && viewType != 15) continue;
                    key = new CalSummaryKey(folder.getMailbox().getAccountId(), folder.getId());
                    keysToInvalidate.add(key);
                    continue;
                }
                if (!(deletedObj instanceof Integer) || (acctId = entry.getKey().getAccountId()) == null) continue;
                int itemId = (Integer)deletedObj;
                key = new CalSummaryKey(acctId, itemId);
                keysToInvalidate.add(key);
            }
        }
        try {
            this.mMemcachedLookup.removeMulti(keysToInvalidate);
        }
        catch (ServiceException e) {
            ZimbraLog.calendar.warn((Object)"Unable to notify ctag info cache.  Some cached data may become stale.", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalSummarySerializer
    implements ByteArraySerializer<CalendarData> {
        private CalSummarySerializer() {
        }

        @Override
        public byte[] serialize(CalendarData value) {
            try {
                return value.encodeMetadata().toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                ZimbraLog.calendar.warn((Object)"Unable to serialize data for calendar summary cache", e);
                return null;
            }
        }

        @Override
        public CalendarData deserialize(byte[] bytes) throws ServiceException {
            if (bytes != null) {
                String encoded;
                try {
                    encoded = new String(bytes, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    ZimbraLog.calendar.warn((Object)"Unable to deserialize data for calendar summary cache", e);
                    return null;
                }
                Metadata meta = new Metadata(encoded);
                return new CalendarData(meta);
            }
            return null;
        }
    }
}

