/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.acl.FolderACL;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.InviteInfo;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.cache.AlarmData;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryKey;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryMemcachedCache;
import com.zimbra.cs.mailbox.calendar.cache.CalendarData;
import com.zimbra.cs.mailbox.calendar.cache.CalendarItemData;
import com.zimbra.cs.mailbox.calendar.cache.FileStore;
import com.zimbra.cs.mailbox.calendar.cache.FullInstanceData;
import com.zimbra.cs.mailbox.calendar.cache.InstanceData;
import com.zimbra.cs.mailbox.calendar.cache.Util;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.stats.ZimbraPerf;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalSummaryCache {
    private static final int sRangeMonthFrom = LC.calendar_cache_range_month_from.intValue();
    private static final int sRangeNumMonths = LC.calendar_cache_range_months.intValue();
    private static final int sMaxStaleItems = LC.calendar_cache_max_stale_items.intValue();
    private static final int sMaxStaleItemsBeforeInvalidatingCalendar = 100;
    private static final int sMaxSearchDays = LC.calendar_search_max_days.intValueWithinRange(0, 3660);
    private static final long MSEC_PER_DAY = 86400000L;
    private SummaryLRU mSummaryCache;
    private int mLRUCapacity;
    private CalSummaryMemcachedCache mMemcachedCache;

    private static CalendarItemData reloadCalendarItemOverRange(Mailbox mbox, CalendarItem calItem, long rangeStart, long rangeEnd) throws ServiceException {
        CalendarItemData calItemData = null;
        try {
            boolean rangeValid;
            boolean bl = rangeValid = rangeStart >= 0L && rangeEnd > 0L && rangeStart < rangeEnd;
            if (!rangeValid) {
                return null;
            }
            Invite defaultInvite = calItem.getDefaultInviteOrNull();
            if (defaultInvite == null) {
                ZimbraLog.calendar.info("Could not load defaultinfo for calendar item with id=" + calItem.getId() + "; SKIPPING");
                return null;
            }
            String defaultFba = null;
            if (calItem instanceof Appointment) {
                defaultFba = ((Appointment)calItem).getEffectiveFreeBusyActual(defaultInvite, null);
            }
            AlarmData alarm = null;
            CalendarItem.AlarmData calItemAlarmData = calItem.getAlarmData();
            long alarmTime = 0L;
            long alarmInst = 0L;
            if (calItemAlarmData != null) {
                alarmTime = calItemAlarmData.getNextAt();
                alarmInst = calItemAlarmData.getNextInstanceStart();
                int alarmInvId = calItemAlarmData.getInvId();
                int alarmCompNum = calItemAlarmData.getCompNum();
                String summary = null;
                String location = null;
                Invite alarmInv = calItem.getInvite(alarmInvId, alarmCompNum);
                if (alarmInv != null) {
                    summary = alarmInv.getName();
                    location = alarmInv.getLocation();
                }
                alarm = new AlarmData(calItemAlarmData.getNextAt(), calItemAlarmData.getNextInstanceStart(), alarmInvId, alarmCompNum, summary, location, calItemAlarmData.getAlarm());
            }
            Long defDtStartLong = null;
            Long defDurationLong = null;
            ParsedDateTime defDtStart = defaultInvite.getStartTime();
            if (defDtStart != null) {
                defDtStartLong = new Long(defDtStart.getUtcTime());
                ParsedDateTime defDtEnd = defaultInvite.getEffectiveEndTime();
                if (defDtEnd != null) {
                    defDurationLong = new Long(defDtEnd.getUtcTime() - defDtStartLong);
                }
            }
            String defaultEffectivePartStat = calItem.getEffectivePartStat(defaultInvite, null);
            FullInstanceData defaultData = new FullInstanceData(defaultInvite, null, defDtStartLong, defDurationLong, defaultEffectivePartStat, defaultFba, null, null);
            calItemData = new CalendarItemData(calItem.getType(), calItem.getFolderId(), calItem.getId(), calItem.getFlagString(), calItem.getTagString(), calItem.getModifiedSequence(), calItem.getSavedSequence(), calItem.getDate(), calItem.getChangeDate(), calItem.getSize(), defaultInvite.getUid(), defaultInvite.isRecurrence(), calItem.isPublic(), alarm, defaultData);
            long actualRangeStart = 0L;
            long actualRangeEnd = 0L;
            int numInstances = 0;
            Collection<CalendarItem.Instance> instances = calItem.expandInstances(rangeStart, rangeEnd, true);
            for (CalendarItem.Instance inst : instances) {
                try {
                    InstanceData instData;
                    String ridZ;
                    long startOrAlarm;
                    long instStart = inst.getStart();
                    long duration = inst.getEnd() - instStart;
                    Long instStartLong = instStart > 0L ? new Long(instStart) : null;
                    Long durationLong = duration > 0L ? new Long(duration) : null;
                    long l = startOrAlarm = instStart == alarmInst ? alarmTime : instStart;
                    if (!inst.isTimeless() && (startOrAlarm >= rangeEnd || inst.getEnd() <= rangeStart)) continue;
                    ++numInstances;
                    if (!inst.isTimeless()) {
                        if (actualRangeStart == 0L || startOrAlarm < actualRangeStart) {
                            actualRangeStart = startOrAlarm;
                        }
                        if (inst.getEnd() > actualRangeEnd) {
                            actualRangeEnd = inst.getEnd();
                        }
                    }
                    InviteInfo invId = inst.getInviteInfo();
                    Invite inv = calItem.getInvite(invId.getMsgId(), invId.getComponentId());
                    Long alarmAt = instStart == alarmInst ? new Long(alarmTime) : null;
                    String fba = inv.getFreeBusyActual();
                    if (calItem instanceof Appointment) {
                        fba = ((Appointment)calItem).getEffectiveFreeBusyActual(inv, inst);
                    }
                    String effectivePartStat = calItem.getEffectivePartStat(inv, inst);
                    if (!inst.isException()) {
                        ridZ = inst.getRecurIdZ();
                        Long tzOffset = instStartLong != null ? Util.getTZOffsetForInvite(inv, instStart) : null;
                        instData = new InstanceData(ridZ, instStartLong, durationLong, alarmAt, tzOffset, effectivePartStat, fba, inv.getPercentComplete(), defaultData);
                    } else {
                        ridZ = null;
                        if (inv.hasRecurId()) {
                            ridZ = inv.getRecurId().getDtZ();
                        }
                        instData = new FullInstanceData(inv, ridZ, instStartLong, durationLong, effectivePartStat, fba, alarmAt, defaultData);
                    }
                    calItemData.addInstance(instData);
                }
                catch (MailServiceException.NoSuchItemException e) {
                    ZimbraLog.calendar.info((Object)("Error could not get instance " + inst.getMailItemId() + "-" + inst.getComponentNum() + " for appt " + calItem.getId()), e);
                }
            }
            if (numInstances < 1) {
                return null;
            }
            calItemData.setActualRange(actualRangeStart, actualRangeEnd);
        }
        catch (MailServiceException.NoSuchItemException e) {
            ZimbraLog.calendar.info((Object)("Error could not get default invite for calendar item: " + calItem.getId()), e);
        }
        catch (RuntimeException e) {
            ZimbraLog.calendar.info((Object)("Caught Exception " + e + " while getting summary info for calendar item: " + calItem.getId()), e);
        }
        return calItemData;
    }

    private static CalendarData reloadCalendarOverRange(OperationContext octxt, Mailbox mbox, int folderId, byte itemType, long rangeStart, long rangeEnd, CalendarData prevCalData, boolean incrementalUpdate) throws ServiceException {
        if (rangeEnd < rangeStart) {
            throw ServiceException.INVALID_REQUEST("End time must be after Start time", null);
        }
        long days = (rangeEnd - rangeStart) / 86400000L;
        if (days > (long)sMaxSearchDays) {
            throw ServiceException.INVALID_REQUEST("Requested range is too large (Maximum " + sMaxSearchDays + " days)", null);
        }
        if (prevCalData == null || rangeStart < prevCalData.getRangeStart() || rangeEnd > prevCalData.getRangeEnd()) {
            return CalSummaryCache.reloadCalendarOverRangeWithFolderScan(octxt, mbox, folderId, itemType, rangeStart, rangeEnd, null);
        }
        if (!incrementalUpdate || prevCalData.getNumStaleItems() > sMaxStaleItems) {
            return CalSummaryCache.reloadCalendarOverRangeWithFolderScan(octxt, mbox, folderId, itemType, rangeStart, rangeEnd, prevCalData);
        }
        HashSet<Integer> staleItemIds = new HashSet<Integer>();
        prevCalData.copyStaleItemIdsTo(staleItemIds);
        Folder folder = mbox.getFolderById(octxt, folderId);
        CalendarData calData = new CalendarData(folderId, folder.getImapMODSEQ(), rangeStart, rangeEnd);
        Iterator<CalendarItemData> iter = prevCalData.calendarItemIterator();
        while (iter.hasNext()) {
            CalendarItemData existing = iter.next();
            int calItemId = existing.getCalItemId();
            if (!staleItemIds.contains(calItemId)) {
                calData.addCalendarItem(existing);
                continue;
            }
            CalendarItemData calItemData = CalSummaryCache.fetchCalendarItemData(octxt, mbox, folderId, calItemId, rangeStart, rangeEnd);
            staleItemIds.remove(calItemId);
            if (calItemData == null || calItemData.getCalItemId() != calItemId) continue;
            calData.addCalendarItem(calItemData);
        }
        Iterator i$ = staleItemIds.iterator();
        while (i$.hasNext()) {
            int calItemId = (Integer)i$.next();
            CalendarItemData calItemData = CalSummaryCache.fetchCalendarItemData(octxt, mbox, folderId, calItemId, rangeStart, rangeEnd);
            if (calItemData == null) continue;
            calData.addCalendarItem(calItemData);
        }
        return calData;
    }

    private static CalendarItemData fetchCalendarItemData(OperationContext octxt, Mailbox mbox, int folderId, int calItemId, long rangeStart, long rangeEnd) throws ServiceException {
        CalendarItem calItem;
        block3: {
            calItem = null;
            try {
                calItem = mbox.getCalendarItemById(octxt, calItemId);
            }
            catch (MailServiceException e) {
                if (e.getCode().equals("mail.NO_SUCH_ITEM") || e.getCode().equals("mail.NO_SUCH_APPT") || e.getCode().equals("mail.NO_SUCH_TASK")) break block3;
                throw e;
            }
        }
        CalendarItemData calItemData = null;
        if (calItem != null && calItem.getFolderId() == folderId) {
            calItemData = CalSummaryCache.reloadCalendarItemOverRange(mbox, calItem, rangeStart, rangeEnd);
        }
        return calItemData;
    }

    private static CalendarData reloadCalendarOverRangeWithFolderScan(OperationContext octxt, Mailbox mbox, int folderId, byte itemType, long rangeStart, long rangeEnd, CalendarData prevCalData) throws ServiceException {
        if (rangeEnd < rangeStart) {
            throw ServiceException.INVALID_REQUEST("End time must be after Start time", null);
        }
        long days = (rangeEnd - rangeStart) / 86400000L;
        if (days > (long)sMaxSearchDays) {
            throw ServiceException.INVALID_REQUEST("Requested range is too large (Maximum " + sMaxSearchDays + " days)", null);
        }
        if (prevCalData != null && (rangeStart < prevCalData.getRangeStart() || rangeEnd > prevCalData.getRangeEnd())) {
            prevCalData = null;
        }
        Folder folder = mbox.getFolderById(octxt, folderId);
        CalendarData calData = new CalendarData(folderId, folder.getImapMODSEQ(), rangeStart, rangeEnd);
        List<CalendarItem> calItems = mbox.getCalendarItemsForRange(octxt, itemType, rangeStart, rangeEnd, folderId, null);
        for (CalendarItem calItem : calItems) {
            CalendarItemData cur;
            if (prevCalData != null && (cur = prevCalData.getCalendarItemData(calItem.getId())) != null && cur.getModMetadata() == calItem.getModifiedSequence()) {
                calData.addCalendarItem(cur);
                continue;
            }
            CalendarItemData calItemData = CalSummaryCache.reloadCalendarItemOverRange(mbox, calItem, rangeStart, rangeEnd);
            if (calItemData == null) continue;
            calData.addCalendarItem(calItemData);
        }
        return calData;
    }

    CalSummaryCache(int capacity) {
        this.mLRUCapacity = capacity;
        this.mSummaryCache = new SummaryLRU(capacity);
        this.mMemcachedCache = new CalSummaryMemcachedCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalendarDataResult getCalendarSummary(OperationContext octxt, String targetAcctId, int folderId, byte itemType, long rangeStart, long rangeEnd, boolean computeSubRange) throws ServiceException {
        if (rangeStart > rangeEnd) {
            throw ServiceException.INVALID_REQUEST("End time must be after Start time", null);
        }
        Account targetAcct = Provisioning.getInstance().get(Provisioning.AccountBy.id, targetAcctId);
        if (targetAcct == null) {
            return null;
        }
        boolean targetAcctOnLocalServer = Provisioning.onLocalServer(targetAcct);
        CalendarDataResult result = new CalendarDataResult();
        if (!LC.calendar_cache_enabled.booleanValue()) {
            ZimbraPerf.COUNTER_CALENDAR_CACHE_HIT.increment(0L);
            ZimbraPerf.COUNTER_CALENDAR_CACHE_MEM_HIT.increment(0L);
            if (!targetAcctOnLocalServer) {
                return null;
            }
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(targetAcct);
            Folder folder = mbox.getFolderById(octxt, folderId);
            Account authAcct = octxt != null ? octxt.getAuthenticatedUser() : null;
            boolean asAdmin = octxt != null ? octxt.isUsingAdminPrivileges() : false;
            result.allowPrivateAccess = CalendarItem.allowPrivateAccess(folder, authAcct, asAdmin);
            result.data = CalSummaryCache.reloadCalendarOverRangeWithFolderScan(octxt, mbox, folderId, itemType, rangeStart, rangeEnd, null);
            return result;
        }
        FolderACL facl = new FolderACL(octxt, targetAcctId, folderId);
        short perms = facl.getEffectivePermissions();
        if ((short)(perms & 1) != 1) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on folder " + targetAcctId + ":" + folderId);
        }
        result.allowPrivateAccess = (short)(perms & 0x400) == 1024;
        CalSummaryKey key = new CalSummaryKey(targetAcctId, folderId);
        CalendarData calData = this.mMemcachedCache.getForRange(key, rangeStart, rangeEnd);
        if (calData != null) {
            ZimbraPerf.COUNTER_CALENDAR_CACHE_HIT.increment(1L);
            ZimbraPerf.COUNTER_CALENDAR_CACHE_MEM_HIT.increment(1L);
            result.data = calData;
            return result;
        }
        if (!targetAcctOnLocalServer) {
            return null;
        }
        int lruSize = 0;
        CacheLevel dataFrom = CacheLevel.Memory;
        boolean incrementalUpdate = sMaxStaleItems > 0;
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(targetAcctId);
        Folder folder = mbox.getFolderById(octxt, folderId);
        OperationContext ownerOctxt = new OperationContext(targetAcct);
        int currentModSeq = folder.getImapMODSEQ();
        SummaryLRU summaryLRU = this.mSummaryCache;
        synchronized (summaryLRU) {
            if (this.mLRUCapacity > 0) {
                calData = (CalendarData)this.mSummaryCache.get(key);
                lruSize = this.mSummaryCache.size();
            }
        }
        if (calData != null) {
            if (calData.getModSeq() > currentModSeq) {
                calData = null;
            } else {
                dataFrom = CacheLevel.Memory;
                boolean bl = incrementalUpdate = sMaxStaleItems > 0;
            }
        }
        if (calData == null) {
            try {
                calData = FileStore.loadCalendarData(mbox.getId(), folderId, currentModSeq);
                if (calData != null) {
                    if (calData.getModSeq() == currentModSeq) {
                        if (this.mLRUCapacity > 0) {
                            summaryLRU = this.mSummaryCache;
                            synchronized (summaryLRU) {
                                this.mSummaryCache.put(key, calData);
                                lruSize = this.mSummaryCache.size();
                            }
                        }
                    } else {
                        incrementalUpdate = false;
                    }
                    dataFrom = CacheLevel.File;
                }
            }
            catch (ServiceException e) {
                ZimbraLog.calendar.warn((Object)"Error loading cached calendar summary", e);
            }
        }
        CalendarData reusableCalData = null;
        Pair<Long, Long> defaultRange = null;
        if (calData != null) {
            if (calData.getModSeq() != currentModSeq || calData.getNumStaleItems() > 0) {
                if (rangeStart >= calData.getRangeStart() && rangeEnd <= calData.getRangeEnd()) {
                    reusableCalData = calData;
                }
                calData = null;
            } else if (rangeStart < calData.getRangeStart() || rangeEnd > calData.getRangeEnd()) {
                defaultRange = Util.getMonthsRange(System.currentTimeMillis(), sRangeMonthFrom, sRangeNumMonths);
                if (calData.getRangeStart() != defaultRange.getFirst().longValue() || calData.getRangeEnd() != defaultRange.getSecond().longValue()) {
                    calData = null;
                }
            }
        }
        if (calData == null) {
            if (defaultRange == null) {
                defaultRange = Util.getMonthsRange(System.currentTimeMillis(), sRangeMonthFrom, sRangeNumMonths);
            }
            calData = CalSummaryCache.reloadCalendarOverRange(ownerOctxt, mbox, folderId, itemType, defaultRange.getFirst(), defaultRange.getSecond(), reusableCalData, incrementalUpdate);
            SummaryLRU summaryLRU2 = this.mSummaryCache;
            synchronized (summaryLRU2) {
                if (this.mLRUCapacity > 0) {
                    this.mSummaryCache.put(key, calData);
                    lruSize = this.mSummaryCache.size();
                }
            }
            dataFrom = CacheLevel.Miss;
            try {
                FileStore.saveCalendarData(mbox.getId(), calData);
            }
            catch (ServiceException e) {
                ZimbraLog.calendar.warn((Object)"Error persisting calendar summary cache", e);
            }
        }
        assert (calData != null);
        if (!CacheLevel.Memcached.equals((Object)dataFrom)) {
            this.mMemcachedCache.put(key, calData);
        }
        if (rangeStart >= calData.getRangeStart() && rangeEnd <= calData.getRangeEnd()) {
            result.data = computeSubRange ? calData.getSubRange(rangeStart, rangeEnd) : calData;
        } else {
            dataFrom = CacheLevel.Miss;
            result.data = CalSummaryCache.reloadCalendarOverRange(ownerOctxt, mbox, folderId, itemType, rangeStart, rangeEnd, reusableCalData, incrementalUpdate);
        }
        switch (dataFrom) {
            case Memory: 
            case Memcached: {
                ZimbraPerf.COUNTER_CALENDAR_CACHE_HIT.increment(1L);
                ZimbraPerf.COUNTER_CALENDAR_CACHE_MEM_HIT.increment(1L);
                break;
            }
            case File: {
                ZimbraPerf.COUNTER_CALENDAR_CACHE_HIT.increment(1L);
                ZimbraPerf.COUNTER_CALENDAR_CACHE_MEM_HIT.increment(0L);
                break;
            }
            default: {
                ZimbraPerf.COUNTER_CALENDAR_CACHE_HIT.increment(0L);
                ZimbraPerf.COUNTER_CALENDAR_CACHE_MEM_HIT.increment(0L);
            }
        }
        ZimbraPerf.COUNTER_CALENDAR_CACHE_LRU_SIZE.increment(lruSize);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSummary(Mailbox mbox, int folderId) {
        if (!LC.calendar_cache_enabled.booleanValue()) {
            return;
        }
        long mboxId = mbox.getId();
        CalSummaryKey key = new CalSummaryKey(mbox.getAccountId(), folderId);
        SummaryLRU summaryLRU = this.mSummaryCache;
        synchronized (summaryLRU) {
            this.mSummaryCache.remove(key);
        }
        try {
            FileStore.deleteCalendarData(mboxId, folderId);
        }
        catch (ServiceException e) {
            ZimbraLog.calendar.warn((Object)"Error deleting calendar summary cache", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateItem(Mailbox mbox, int folderId, int calItemId) {
        int numStaleItems;
        if (!LC.calendar_cache_enabled.booleanValue()) {
            return;
        }
        CalSummaryKey key = new CalSummaryKey(mbox.getAccountId(), folderId);
        CalendarData calData = null;
        SummaryLRU summaryLRU = this.mSummaryCache;
        synchronized (summaryLRU) {
            if (this.mLRUCapacity > 0) {
                calData = (CalendarData)this.mSummaryCache.get(key);
            }
        }
        if (calData != null && (numStaleItems = calData.markItemStale(calItemId)) > sMaxStaleItemsBeforeInvalidatingCalendar) {
            this.invalidateSummary(mbox, folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void notifyCommittedChanges(PendingModifications mods, int changeId) {
        SummaryLRU summaryLRU;
        String accountId;
        Mailbox mbox;
        if (mods.created != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.created.entrySet()) {
                MailItem item = (MailItem)entry.getValue();
                if (!(item instanceof CalendarItem)) continue;
                int folderId = item.getFolderId();
                this.invalidateItem(item.getMailbox(), folderId, item.getId());
            }
        }
        if (mods.modified != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.modified.entrySet()) {
                int prevFolderId;
                PendingModifications.Change change = (PendingModifications.Change)entry.getValue();
                Object whatChanged = change.what;
                if (!(whatChanged instanceof CalendarItem)) continue;
                CalendarItem item = (CalendarItem)whatChanged;
                mbox = item.getMailbox();
                int folderId = item.getFolderId();
                int itemId = item.getId();
                this.invalidateItem(mbox, folderId, itemId);
                if ((change.why & 0x100) == 0) continue;
                accountId = mbox.getAccountId();
                summaryLRU = this.mSummaryCache;
                synchronized (summaryLRU) {
                    prevFolderId = this.mSummaryCache.getFolderForItem(accountId, itemId);
                }
                if (prevFolderId == folderId || prevFolderId == -1) continue;
                this.invalidateItem(mbox, prevFolderId, itemId);
            }
        }
        if (mods.deleted != null) {
            String lastAcctId = null;
            Object var4_7 = null;
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.deleted.entrySet()) {
                int folderId;
                Object deletedObj = entry.getValue();
                if (deletedObj instanceof CalendarItem) {
                    CalendarItem item = (CalendarItem)deletedObj;
                    Mailbox mbox2 = item.getMailbox();
                    this.invalidateItem(mbox2, item.getFolderId(), item.getId());
                    lastAcctId = mbox2.getAccountId();
                    Mailbox mailbox = mbox2;
                    continue;
                }
                if (!(deletedObj instanceof Integer)) continue;
                mbox = null;
                String acctId = entry.getKey().getAccountId();
                if (acctId == null) continue;
                if (acctId.equals(lastAcctId)) {
                    void var4_8;
                    mbox = var4_8;
                } else {
                    try {
                        mbox = MailboxManager.getInstance().getMailboxByAccountId(acctId, MailboxManager.FetchMode.DO_NOT_AUTOCREATE);
                    }
                    catch (ServiceException e) {
                        ZimbraLog.calendar.error((Object)("Error looking up the mailbox of account in delete notification: account=" + acctId), e);
                        continue;
                    }
                }
                if (mbox == null) continue;
                lastAcctId = acctId;
                Mailbox mailbox = mbox;
                int itemId = (Integer)deletedObj;
                accountId = mbox.getAccountId();
                summaryLRU = this.mSummaryCache;
                synchronized (summaryLRU) {
                    folderId = this.mSummaryCache.getFolderForItem(accountId, itemId);
                }
                if (folderId == -1) continue;
                this.invalidateItem(mbox, folderId, itemId);
            }
        }
        if (MemcachedConnector.isConnected()) {
            this.mMemcachedCache.notifyCommittedChanges(mods, changeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeMailbox(Mailbox mbox) throws ServiceException {
        SummaryLRU summaryLRU = this.mSummaryCache;
        synchronized (summaryLRU) {
            this.mSummaryCache.removeAccount(mbox.getAccountId());
        }
        if (MemcachedConnector.isConnected()) {
            this.mMemcachedCache.purgeMailbox(mbox);
        }
        FileStore.removeMailbox(mbox.getId());
    }

    public class CalendarDataResult {
        public CalendarData data;
        public boolean allowPrivateAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CacheLevel {
        Memory,
        Memcached,
        File,
        Miss;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SummaryLRU
    extends LinkedHashMap<CalSummaryKey, CalendarData> {
        private int mMaxAllowed;
        private Map<String, Set<Integer>> mAccountFolders;
        public static final int FOLDER_NOT_FOUND = -1;

        private SummaryLRU(int capacity) {
            super(capacity + 1, 1.0f, true);
            this.mMaxAllowed = Math.max(capacity, 1);
            this.mAccountFolders = new HashMap<String, Set<Integer>>();
        }

        @Override
        public void clear() {
            super.clear();
            this.mAccountFolders.clear();
        }

        @Override
        public CalendarData put(CalSummaryKey key, CalendarData value) {
            CalendarData prevVal = super.put(key, value);
            if (prevVal == null) {
                this.registerWithAccount(key);
            }
            return prevVal;
        }

        @Override
        public void putAll(Map<? extends CalSummaryKey, ? extends CalendarData> t) {
            super.putAll(t);
            for (CalSummaryKey calSummaryKey : t.keySet()) {
                this.registerWithAccount(calSummaryKey);
            }
        }

        @Override
        public CalendarData remove(Object key) {
            CalendarData prevVal = (CalendarData)super.remove(key);
            if (prevVal != null && key instanceof CalSummaryKey) {
                CalSummaryKey k = (CalSummaryKey)key;
                this.deregisterFromAccount(k);
            }
            return prevVal;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<CalSummaryKey, CalendarData> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > this.mMaxAllowed;
            if (remove) {
                this.deregisterFromAccount(eldest.getKey());
            }
            return remove;
        }

        private void registerWithAccount(CalSummaryKey key) {
            String accountId = key.getAccountId();
            int folderId = key.getFolderId();
            Set<Integer> folders = this.mAccountFolders.get(accountId);
            if (folders == null) {
                folders = new HashSet<Integer>();
                this.mAccountFolders.put(accountId, folders);
            }
            folders.add(folderId);
        }

        private void deregisterFromAccount(CalSummaryKey key) {
            String accountId = key.getAccountId();
            int folderId = key.getFolderId();
            Set<Integer> folders = this.mAccountFolders.get(accountId);
            if (folders != null) {
                folders.remove(folderId);
                if (folders.isEmpty()) {
                    this.mAccountFolders.remove(accountId);
                }
            }
        }

        public int getFolderForItem(String accountId, int itemId) {
            int retval = -1;
            Set<Integer> folders = this.mAccountFolders.get(accountId);
            if (folders != null) {
                for (int folderId : folders) {
                    CalendarItemData ci;
                    CalSummaryKey key = new CalSummaryKey(accountId, folderId);
                    CalendarData calData = (CalendarData)this.get(key);
                    if (calData == null || (ci = calData.getCalendarItemData(itemId)) == null) continue;
                    retval = folderId;
                    break;
                }
            }
            return retval;
        }

        public void removeAccount(String accountId) {
            Set<Integer> folders = this.mAccountFolders.get(accountId);
            if (folders != null) {
                Integer[] fids;
                Integer[] arr$ = fids = folders.toArray(new Integer[0]);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int folderId = arr$[i$];
                    CalSummaryKey key = new CalSummaryKey(accountId, folderId);
                    this.remove(key);
                }
            }
        }
    }
}

