/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.memcached.MemcachedMap;
import com.zimbra.common.util.memcached.MemcachedSerializer;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.cache.AccountKey;
import com.zimbra.cs.mailbox.calendar.cache.CalList;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.session.PendingModifications;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalListCache {
    private MemcachedMap<AccountKey, CalList> mMemcachedLookup;

    CalListCache() {
        ZimbraMemcachedClient memcachedClient = MemcachedConnector.getClient();
        CalListSerializer serializer = new CalListSerializer();
        this.mMemcachedLookup = new MemcachedMap(memcachedClient, serializer);
    }

    public CalList get(AccountKey key) throws ServiceException {
        CalList list = this.mMemcachedLookup.get(key);
        if (list != null) {
            return list;
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(key.getAccountId());
        if (mbox == null) {
            ZimbraLog.calendar.warn("Invalid account %s during cache lookup", key.getAccountId());
            return null;
        }
        List<Folder> calFolders = mbox.getCalendarFolders(null, SortBy.NONE);
        HashSet<Integer> idset = new HashSet<Integer>(calFolders.size());
        idset.add(2);
        for (Folder calFolder : calFolders) {
            idset.add(calFolder.getId());
        }
        list = new CalList(idset);
        this.mMemcachedLookup.put(key, list);
        return list;
    }

    void purgeMailbox(Mailbox mbox) throws ServiceException {
        AccountKey key = new AccountKey(mbox.getAccountId());
        this.mMemcachedLookup.remove(key);
    }

    void notifyCommittedChanges(PendingModifications mods, int changeId) {
        Folder folder;
        ChangeMap changeMap = new ChangeMap(1);
        if (mods.created != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.created.entrySet()) {
                byte viewType;
                MailItem item = (MailItem)entry.getValue();
                if (!(item instanceof Folder) || (viewType = (folder = (Folder)item).getDefaultView()) != 11 && viewType != 15) continue;
                ChangedFolders changedFolders = changeMap.getAccount(entry.getKey().getAccountId());
                changedFolders.created.add(folder.getId());
            }
        }
        if (mods.modified != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.modified.entrySet()) {
                Message msg;
                PendingModifications.Change change = (PendingModifications.Change)entry.getValue();
                Object whatChanged = change.what;
                if (whatChanged instanceof Folder) {
                    Folder folder2 = (Folder)whatChanged;
                    byte viewType = folder2.getDefaultView();
                    if (viewType != 11 && viewType != 15) continue;
                    ChangedFolders changedFolders = changeMap.getAccount(entry.getKey().getAccountId());
                    int folderId = folder2.getId();
                    if ((change.why & 0x100) != 0) {
                        int parentFolder = folder2.getFolderId();
                        changedFolders.created.add(folderId);
                        if (parentFolder == 3) {
                            changedFolders.deleted.add(folderId);
                            continue;
                        }
                        changedFolders.created.add(folderId);
                        continue;
                    }
                    changedFolders.modified.add(folderId);
                    continue;
                }
                if (!(whatChanged instanceof Message) || !(msg = (Message)whatChanged).hasCalendarItemInfos() || msg.getFolderId() != 2 && (change.why & 0x100) == 0) continue;
                ChangedFolders changedFolders = changeMap.getAccount(entry.getKey().getAccountId());
                changedFolders.modified.add(2);
            }
        }
        if (mods.deleted != null) {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : mods.deleted.entrySet()) {
                Object deletedObj = entry.getValue();
                if (deletedObj instanceof Folder) {
                    folder = (Folder)deletedObj;
                    byte viewType = folder.getDefaultView();
                    if (viewType != 11 && viewType != 15) continue;
                    ChangedFolders changedFolders = changeMap.getAccount(entry.getKey().getAccountId());
                    changedFolders.deleted.add(folder.getId());
                    continue;
                }
                if (!(deletedObj instanceof Integer)) continue;
                ChangedFolders changedFolders = changeMap.getAccount(entry.getKey().getAccountId());
                int itemId = (Integer)deletedObj;
                changedFolders.deleted.add(itemId);
            }
        }
        try {
            for (Map.Entry<PendingModifications.ModificationKey, Object> entry : changeMap.entrySet()) {
                String accountId;
                AccountKey key;
                CalList list;
                ChangedFolders changedFolders = (ChangedFolders)entry.getValue();
                if (changedFolders.isEmpty() || (list = this.mMemcachedLookup.get(key = new AccountKey(accountId = (String)((Object)entry.getKey())))) == null) continue;
                boolean updated = false;
                CalList newList = new CalList(list);
                for (Integer folderId : changedFolders.created) {
                    if (list.contains(folderId)) continue;
                    updated = true;
                    newList.add(folderId);
                }
                for (Integer folderId : changedFolders.modified) {
                    if (!list.contains(folderId)) continue;
                    updated = true;
                }
                for (Integer folderId : changedFolders.deleted) {
                    if (!list.contains(folderId)) continue;
                    updated = true;
                    newList.remove(folderId);
                }
                if (!updated) continue;
                newList.incrementSeq();
                this.mMemcachedLookup.put(key, newList);
            }
        }
        catch (ServiceException e) {
            ZimbraLog.calendar.warn((Object)"Unable to notify calendar list cache.  Some cached data may become stale.", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeMap
    extends HashMap<String, ChangedFolders> {
        public ChangeMap(int capacity) {
            super(capacity);
        }

        public ChangedFolders getAccount(String accountId) {
            ChangedFolders cf = (ChangedFolders)this.get(accountId);
            if (cf == null) {
                cf = new ChangedFolders();
                this.put(accountId, cf);
            }
            return cf;
        }
    }

    private static class ChangedFolders {
        public Set<Integer> created = new HashSet<Integer>();
        public Set<Integer> modified = new HashSet<Integer>();
        public Set<Integer> deleted = new HashSet<Integer>();

        private ChangedFolders() {
        }

        public boolean isEmpty() {
            return this.created.isEmpty() && this.modified.isEmpty() && this.deleted.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalListSerializer
    implements MemcachedSerializer<CalList> {
        private CalListSerializer() {
        }

        @Override
        public Object serialize(CalList value) {
            return value.encodeMetadata().toString();
        }

        @Override
        public CalList deserialize(Object obj) throws ServiceException {
            Metadata meta = new Metadata((String)obj);
            return new CalList(meta);
        }
    }
}

