/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalList {
    private Set<Integer> mCalendars;
    private String mVerPrefix;
    private long mVerSeq;
    private String mVerString;
    private static final String FN_CALS = "c";
    private static final String FN_VERSION_PREFIX = "vp";
    private static final String FN_VERSION_SEQ = "vs";

    CalList(Set<Integer> calendars) {
        this.mCalendars = new HashSet<Integer>(calendars);
        this.mVerPrefix = Long.toString(System.currentTimeMillis()) + ":";
        this.mVerSeq = 1L;
        this.setVersion();
    }

    CalList(CalList other) {
        this.mCalendars = new HashSet<Integer>(other.mCalendars);
        this.mVerPrefix = other.mVerPrefix;
        this.mVerSeq = other.mVerSeq;
        this.mVerString = other.mVerString;
    }

    Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        ArrayList<Integer> list = new ArrayList<Integer>(this.mCalendars);
        MetadataList calsMetaList = new MetadataList(list);
        meta.put(FN_CALS, calsMetaList);
        meta.put(FN_VERSION_PREFIX, this.mVerPrefix);
        meta.put(FN_VERSION_SEQ, this.mVerSeq);
        return meta;
    }

    CalList(Metadata meta) throws ServiceException {
        MetadataList calsMetaList = meta.getList(FN_CALS, true);
        if (calsMetaList != null) {
            this.mCalendars = new HashSet<Integer>(calsMetaList.size());
            List vals = calsMetaList.asList();
            for (Object val : vals) {
                if (val instanceof Long) {
                    this.mCalendars.add((int)((Long)val).longValue());
                    continue;
                }
                if (val instanceof Integer) {
                    this.mCalendars.add((Integer)val);
                    continue;
                }
                throw ServiceException.FAILURE("Invalid calendar id value: " + val.toString(), null);
            }
        } else {
            this.mCalendars = new HashSet<Integer>(0);
        }
        this.mVerPrefix = meta.get(FN_VERSION_PREFIX, "");
        this.mVerSeq = meta.getLong(FN_VERSION_SEQ, 1L);
        this.setVersion();
    }

    void add(int calFolderId) {
        this.mCalendars.add(calFolderId);
    }

    void remove(int calFolderId) {
        this.mCalendars.remove(calFolderId);
    }

    void incrementSeq() {
        ++this.mVerSeq;
        this.setVersion();
    }

    boolean contains(int calFolderId) {
        return this.mCalendars.contains(calFolderId);
    }

    public String getVersion() {
        return this.mVerString;
    }

    private void setVersion() {
        this.mVerString = this.mVerPrefix + Long.toString(this.mVerSeq);
    }

    public Collection<Integer> getCalendars() {
        return this.mCalendars;
    }
}

