/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.mailbox.calendar.Alarm;
import com.zimbra.cs.mailbox.calendar.Geo;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mailbox.calendar.cache.AlarmData;
import com.zimbra.cs.mailbox.calendar.cache.CalendarData;
import com.zimbra.cs.mailbox.calendar.cache.CalendarItemData;
import com.zimbra.cs.mailbox.calendar.cache.FullInstanceData;
import com.zimbra.cs.mailbox.calendar.cache.InstanceData;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Iterator;
import java.util.List;

public class CacheToXML {
    private static void encodeInstanceData(Element parent, ItemIdFormatter ifmt, int calItemId, InstanceData instance, FullInstanceData defaultInstance, boolean isException, boolean isAppointment, boolean allowPrivateAccess, boolean legacyFormat) throws ServiceException {
        ZOrganizer organizer;
        boolean showAll;
        if (isException && instance.getDtStart() != null) {
            parent.addAttribute("s", instance.getDtStart());
        }
        if (instance.getDuration() != null) {
            String attribute = !legacyFormat ? "dur" : "d";
            parent.addAttribute(attribute, instance.getDuration());
        }
        if (instance.getTZOffset() != null) {
            parent.addAttribute("tzo", instance.getTZOffset());
        }
        parent.addAttribute("ptst", instance.getPartStat());
        if (isAppointment) {
            parent.addAttribute("fba", instance.getFreeBusyActual());
        } else {
            parent.addAttribute("percentComplete", instance.getPercentComplete());
        }
        parent.addAttribute("ridZ", instance.getRecurIdZ());
        if (!(instance instanceof FullInstanceData)) {
            return;
        }
        FullInstanceData fullInstance = (FullInstanceData)instance;
        boolean bl = showAll = allowPrivateAccess || fullInstance.isPublic(defaultInstance);
        if (isException) {
            parent.addAttribute("ex", true);
            parent.addAttribute("recur", false);
        }
        if ((organizer = fullInstance.getOrganizer()) != null) {
            Element orgElt = parent.addUniqueElement("or");
            String addr = IDNUtil.toUnicode(organizer.getAddress());
            orgElt.addAttribute("a", addr);
            orgElt.addAttribute("url", addr);
            orgElt.addAttribute("d", organizer.getCn());
            orgElt.addAttribute("sentBy", organizer.getSentBy());
        }
        if (showAll) {
            Integer numAttendees;
            String fragment;
            Geo geo;
            parent.addAttribute("priority", fullInstance.getPriority());
            parent.addAttribute("ptst", fullInstance.getPartStat());
            if (isAppointment) {
                parent.addAttribute("fb", fullInstance.getFreeBusyIntended());
                parent.addAttribute("transp", fullInstance.getTransparency());
            }
            parent.addAttribute("name", fullInstance.getSummary());
            parent.addAttribute("loc", fullInstance.getLocation());
            List<String> categories = fullInstance.getCategories();
            if (categories != null) {
                for (String cat : categories) {
                    parent.addElement("category").setText(cat);
                }
            }
            if ((geo = fullInstance.getGeo()) != null) {
                geo.toXml(parent);
            }
            if ((fragment = fullInstance.getFragment()) != null && !fragment.equals("")) {
                parent.addAttribute("fr", fragment, Element.Disposition.CONTENT);
            }
            if ((numAttendees = fullInstance.getNumAttendees()) != null) {
                parent.addAttribute("otherAtt", numAttendees > 0);
            }
            if (fullInstance.hasAlarm() != null) {
                parent.addAttribute("alarm", fullInstance.hasAlarm());
            }
        }
        if (fullInstance.isOrganizer() != null) {
            parent.addAttribute("isOrg", fullInstance.isOrganizer());
        }
        if (!isException) {
            parent.addAttribute("id", ifmt.formatItemId(calItemId));
        }
        parent.addAttribute("invId", ifmt.formatItemId(calItemId, fullInstance.getInvId()));
        parent.addAttribute("compNum", fullInstance.getCompNum());
        parent.addAttribute("status", fullInstance.getStatus());
        parent.addAttribute("class", fullInstance.getClassProp());
        if (fullInstance.isAllDay() != null) {
            parent.addAttribute("allDay", fullInstance.isAllDay());
        }
    }

    private static void encodeAlarmData(Element parent, AlarmData alarmData, boolean showAll) {
        Element alarmElem = parent.addElement("alarmData");
        long nextAlarm = alarmData.getNextAt();
        if (nextAlarm < Long.MAX_VALUE) {
            alarmElem.addAttribute("nextAlarm", nextAlarm);
        }
        long alarmInstStart = alarmData.getNextInstanceStart();
        alarmElem.addAttribute("alarmInstStart", alarmInstStart);
        alarmElem.addAttribute("invId", alarmData.getInvId());
        alarmElem.addAttribute("compNum", alarmData.getCompNum());
        if (showAll) {
            alarmElem.addAttribute("name", alarmData.getSummary());
            alarmElem.addAttribute("loc", alarmData.getLocation());
            Alarm alarmObj = alarmData.getAlarm();
            if (alarmObj != null) {
                alarmObj.toXml(alarmElem);
            }
        }
    }

    public static Element encodeCalendarItemData(ZimbraSoapContext zsc, ItemIdFormatter ifmt, CalendarItemData calItemData, boolean allowPrivateAccess, boolean legacyFormat) throws ServiceException {
        boolean showAll;
        boolean isAppointment = calItemData.getType() == 11;
        Element calItemElem = zsc.createElement(isAppointment ? "appt" : "task");
        calItemElem.addAttribute("x_uid", calItemData.getUid());
        calItemElem.addAttribute("uid", calItemData.getUid());
        FullInstanceData defaultData = calItemData.getDefaultData();
        boolean bl = showAll = allowPrivateAccess || calItemData.isPublic();
        if (showAll) {
            String tags;
            String flags = calItemData.getFlags();
            if (flags != null && !flags.equals("")) {
                calItemElem.addAttribute("f", flags);
            }
            if ((tags = calItemData.getTags()) != null && !tags.equals("")) {
                calItemElem.addAttribute("t", tags);
            }
        }
        calItemElem.addAttribute("l", ifmt.formatItemId(calItemData.getFolderId()));
        if (calItemData.isRecurring()) {
            calItemElem.addAttribute("recur", calItemData.isRecurring());
        }
        calItemElem.addAttribute("s", calItemData.getSize());
        calItemElem.addAttribute("d", calItemData.getDate());
        calItemElem.addAttribute("md", calItemData.getChangeDate() / 1000L);
        calItemElem.addAttribute("ms", calItemData.getModMetadata());
        calItemElem.addAttribute("rev", calItemData.getModContent());
        int calItemId = calItemData.getCalItemId();
        CacheToXML.encodeInstanceData(calItemElem, ifmt, calItemId, defaultData, null, false, isAppointment, allowPrivateAccess, legacyFormat);
        Iterator<InstanceData> iter = calItemData.instanceIterator();
        while (iter.hasNext()) {
            InstanceData instance = iter.next();
            Element instElem = calItemElem.addElement("inst");
            CacheToXML.encodeInstanceData(instElem, ifmt, calItemId, instance, defaultData, true, isAppointment, allowPrivateAccess, legacyFormat);
        }
        AlarmData alarmData = calItemData.getAlarm();
        if (alarmData != null) {
            CacheToXML.encodeAlarmData(calItemElem, alarmData, showAll);
        }
        return calItemElem;
    }

    public static void encodeCalendarData(ZimbraSoapContext zsc, ItemIdFormatter ifmt, Element parent, CalendarData calData, boolean allowPrivateAccess, boolean legacyFormat) throws ServiceException {
        Iterator<CalendarItemData> iter = calData.calendarItemIterator();
        while (iter.hasNext()) {
            CalendarItemData calItemData = iter.next();
            if (calItemData.getNumInstances() <= 0) continue;
            Element calItemElem = CacheToXML.encodeCalendarItemData(zsc, ifmt, calItemData, allowPrivateAccess, legacyFormat);
            parent.addElement(calItemElem);
        }
    }
}

