/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.Alarm;

public class AlarmData {
    private long mNextAt = Long.MAX_VALUE;
    private long mNextInstStart;
    private int mInvId;
    private int mCompNum;
    private String mSummary;
    private String mLocation;
    private Alarm mAlarm;
    private static final String FN_NEXT_AT = "na";
    private static final String FN_NEXT_INSTANCE_START = "nis";
    private static final String FN_INV_ID = "invId";
    private static final String FN_COMP_NUM = "compNum";
    private static final String FN_SUMMARY = "summ";
    private static final String FN_LOCATION = "loc";
    private static final String FN_ALARM = "alarm";

    public AlarmData(long next, long nextInstStart, int invId, int compNum, String summary, String location, Alarm alarm) {
        this.init(next, nextInstStart, invId, compNum, summary, location, alarm);
    }

    private void init(long next, long nextInstStart, int invId, int compNum, String summary, String location, Alarm alarm) {
        this.mNextAt = next;
        this.mNextInstStart = nextInstStart;
        this.mInvId = invId;
        this.mCompNum = compNum;
        this.mSummary = summary;
        this.mLocation = location;
        this.mAlarm = alarm;
    }

    public long getNextAt() {
        return this.mNextAt;
    }

    public long getNextInstanceStart() {
        return this.mNextInstStart;
    }

    public int getInvId() {
        return this.mInvId;
    }

    public int getCompNum() {
        return this.mCompNum;
    }

    public String getSummary() {
        return this.mSummary;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public Alarm getAlarm() {
        return this.mAlarm;
    }

    AlarmData(Metadata meta) throws ServiceException {
        long nextAt = meta.getLong(FN_NEXT_AT);
        long nextInstStart = meta.getLong(FN_NEXT_INSTANCE_START);
        int invId = (int)meta.getLong(FN_INV_ID);
        int compNum = (int)meta.getLong(FN_COMP_NUM);
        String summary = meta.get(FN_SUMMARY, null);
        String location = meta.get(FN_LOCATION, null);
        Alarm alarm = null;
        Metadata metaAlarm = meta.getMap(FN_ALARM, true);
        if (metaAlarm != null) {
            alarm = Alarm.decodeMetadata(metaAlarm);
        }
        this.init(nextAt, nextInstStart, invId, compNum, summary, location, alarm);
    }

    Metadata encodeMetadata() {
        Metadata meta = new Metadata();
        meta.put(FN_NEXT_AT, this.mNextAt);
        meta.put(FN_NEXT_INSTANCE_START, this.mNextInstStart);
        meta.put(FN_INV_ID, this.mInvId);
        meta.put(FN_COMP_NUM, this.mCompNum);
        meta.put(FN_SUMMARY, this.mSummary);
        meta.put(FN_LOCATION, this.mLocation);
        if (this.mAlarm != null) {
            meta.put(FN_ALARM, this.mAlarm.encodeMetadata());
        }
        return meta;
    }
}

