/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar.cache;

import com.zimbra.cs.mailbox.calendar.cache.CalList;
import com.zimbra.cs.mailbox.calendar.cache.CtagInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountCtags {
    private CalList mCalList;
    private Map<Integer, CtagInfo> mCtagMap;

    AccountCtags(CalList calList, Collection<CtagInfo> ctags) {
        this.mCalList = calList;
        this.mCtagMap = new HashMap<Integer, CtagInfo>(ctags.size());
        for (CtagInfo ctag : ctags) {
            this.mCtagMap.put(ctag.getId(), ctag);
        }
    }

    public String getVersion() {
        return this.mCalList.getVersion();
    }

    public CtagInfo getById(int calFolderId) {
        return this.mCtagMap.get(calFolderId);
    }

    public CtagInfo getByPath(String path) {
        for (CtagInfo calInfo : this.mCtagMap.values()) {
            if (!path.equalsIgnoreCase(calInfo.getPath())) continue;
            return calInfo;
        }
        return null;
    }

    public Collection<CtagInfo> getChildren(int parentFolderId) {
        Collection<CtagInfo> allFolders = this.mCtagMap.values();
        if (parentFolderId == 1) {
            return allFolders;
        }
        ArrayList<CtagInfo> children = new ArrayList<CtagInfo>();
        for (CtagInfo calInfo : allFolders) {
            if (calInfo.getFolderId() != parentFolderId) continue;
            children.add(calInfo);
        }
        return children;
    }
}

