/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.util.Zimbra;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZRecur {
    private static final long MAX_DATE_MILLIS = 221845392000000L;
    private static ExpansionLimits sExpansionLimits = new ExpansionLimits();
    private List<ZWeekDayNum> mByDayList = new ArrayList<ZWeekDayNum>();
    private List<Integer> mByHourList = new ArrayList<Integer>();
    private List<Integer> mByMinuteList = new ArrayList<Integer>();
    private List<Integer> mByMonthDayList = new ArrayList<Integer>();
    private List<Integer> mByMonthList = new ArrayList<Integer>();
    private List<Integer> mBySecondList = new ArrayList<Integer>();
    private List<Integer> mBySetPosList = new ArrayList<Integer>();
    private List<Integer> mByWeekNoList = new ArrayList<Integer>();
    private List<Integer> mByYearDayList = new ArrayList<Integer>();
    private int mCount = 0;
    private Frequency mFreq = Frequency.WEEKLY;
    private int mInterval = 0;
    private ParsedDateTime mUntil = null;
    private ZWeekDay mWkSt = null;

    private Date estimateEndTimeByUntilAndHardLimits(ParsedDateTime dtStart) throws ServiceException {
        Date until;
        boolean forever = false;
        GregorianCalendar hardEnd = dtStart.getCalendarCopy();
        Frequency freq = this.mFreq;
        if (freq == null) {
            freq = Frequency.WEEKLY;
        }
        switch (freq) {
            case WEEKLY: {
                int weeks = ZRecur.sExpansionLimits.maxWeeks;
                if (weeks <= 0) {
                    forever = true;
                    break;
                }
                ((Calendar)hardEnd).add(3, weeks);
                break;
            }
            case MONTHLY: {
                int months = ZRecur.sExpansionLimits.maxMonths;
                if (months <= 0) {
                    forever = true;
                    break;
                }
                ((Calendar)hardEnd).add(2, months);
                break;
            }
            case YEARLY: {
                int years = ZRecur.sExpansionLimits.maxYears;
                if (years <= 0) {
                    forever = true;
                    break;
                }
                ((Calendar)hardEnd).add(1, years);
                break;
            }
            case DAILY: {
                int days = ZRecur.sExpansionLimits.maxDays;
                if (days <= 0) {
                    forever = true;
                    break;
                }
                ((Calendar)hardEnd).add(6, days);
                break;
            }
            default: {
                int otherFreqYears = Math.max(ZRecur.sExpansionLimits.maxYearsOtherFreqs, 1);
                ((Calendar)hardEnd).add(1, otherFreqYears);
            }
        }
        Date d = forever ? new Date(221845392000000L) : hardEnd.getTime();
        if (this.mUntil != null && (until = this.mUntil.getDateForRecurUntil(dtStart.getTimeZone())).before(d)) {
            d = until;
        }
        return d;
    }

    public Date getEstimatedEndTime(ParsedDateTime dtStart) throws ServiceException {
        if (dtStart == null) {
            return null;
        }
        return this.estimateEndTimeByUntilAndHardLimits(dtStart);
    }

    public static String listAsStr(List<? extends Object> l) {
        StringBuffer toRet = new StringBuffer();
        boolean first = true;
        for (Object object : l) {
            if (!first) {
                toRet.append(',');
            } else {
                first = false;
            }
            toRet.append(object.toString());
        }
        return toRet.toString();
    }

    public static void main(String[] args) {
        List<Date> dateList;
        ZRecur test;
        ICalTimeZone tzUTC = ICalTimeZone.getUTC();
        TimeZoneMap tzmap = new TimeZoneMap(tzUTC);
        ParsedDateTime dtStart = null;
        try {
            dtStart = ParsedDateTime.parse("20050101T123456", tzmap, tzUTC, tzUTC);
        }
        catch (ParseException e) {
            System.out.println("Caught ParseException at start: " + e);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setTimeZone(tzUTC);
        cal.set(2005, 4, 15, 0, 0, 0);
        Date rangeStart = cal.getTime();
        cal.set(2006, 0, 1, 0, 0, 0);
        Date rangeEnd = cal.getTime();
        try {
            test = new ZRecur("FREQ=DAILY;BYMONTH=5,6", tzmap);
            System.out.println("\n\n" + test.toString() + "\n-------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                cal.setTimeZone(tzUTC);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=DAILY;BYMONTH=5,6;BYDAY=TH,-1MO", tzmap);
            System.out.println("\n\n" + test.toString() + "\n-------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                cal.setTimeZone(tzUTC);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=DAILY;BYMONTH=5,6;BYMONTHDAY=1,3,5,7,9,31", tzmap);
            System.out.println("\n\n" + test.toString() + "\n-------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=DAILY;BYMONTH=5,6;BYMONTHDAY=1,3,5,7,9,31;BYDAY=SU,SA", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=DAILY;BYMONTH=5,6;BYMONTHDAY=1,3,5,7,9,31;BYDAY=SU,SA;BYHOUR=21,0", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=DAILY;BYMONTH=5,6;BYMONTHDAY=1,3,5,7,9,31;BYDAY=SU;BYHOUR=21,0;BYMINUTE=23", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=DAILY;BYMONTH=5,6;BYMONTHDAY=1,3,5,7,9,31;BYDAY=SU;BYHOUR=1,21,0;BYSECOND=0,59", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=DAILY;BIYMONTH=5,6;BYMONTHDAY=1,3,5,7,9,31;BYDAY=SU;BYHOUR=1,21,0;BYSECOND=0,59;BYSETPOS=1,-1,3,1000,,-1000", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=HOURLY;BIYMONTH=6;BYMONTHDAY=1,3;BYHOUR=2,14", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=HOURLY;BIYMONTH=6;BYMONTHDAY=1;;BYMINUTE=10;BYSECOND=11,12", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        cal.set(2010, 0, 1, 0, 0, 0);
        rangeEnd = cal.getTime();
        try {
            test = new ZRecur("FREQ=YEARLY", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=YEARLY;BYYEARDAY=-1", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            test = new ZRecur("FREQ=SECONDLY", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        try {
            ParsedDateTime myDtStart = ParsedDateTime.parse("16010101T020000", tzmap, tzUTC, tzUTC);
            ZRecur test2 = new ZRecur("FREQ=YEARLY;WKST=MO;INTERVAL=1;BYMONTH=12;BYDAY=-1SU", tzmap);
            System.out.println("\n\n" + test2.toString() + "\n--------------------------------------------------------------");
            List<Date> dateList2 = test2.expandRecurrenceOverRange(myDtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList2) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ParseException e) {
            System.out.println("Caught ParseException" + e);
            e.printStackTrace();
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
        cal.set(2010, 0, 1, 0, 0, 0);
        rangeEnd = cal.getTime();
        try {
            test = new ZRecur("FREQ=YEARLY;BYMONTH=12;BYDAY=1WE", tzmap);
            System.out.println("\n\n" + test.toString() + "\n--------------------------------------------------------------");
            dateList = test.expandRecurrenceOverRange(dtStart, rangeStart.getTime(), rangeEnd.getTime());
            for (Date d : dateList) {
                cal.setTime(d);
                System.out.printf("%tc\n", cal);
            }
        }
        catch (ServiceException e) {
            System.out.println("Caught ServiceException" + e);
            e.printStackTrace();
        }
    }

    public ZRecur(String str, TimeZoneMap tzmap) throws ServiceException {
        this.parse(str, tzmap);
    }

    public List<Integer> getByHourList() {
        return this.mByHourList;
    }

    public void setByHourList(List<Integer> byHourList) {
        this.mByHourList = byHourList;
    }

    public List<Integer> getByMinuteList() {
        return this.mByMinuteList;
    }

    public void setByMinuteList(List<Integer> byMinuteList) {
        this.mByMinuteList = byMinuteList;
    }

    public List<Integer> getByMonthDayList() {
        return this.mByMonthDayList;
    }

    public void setByMonthDayList(List<Integer> byMonthDayList) {
        this.mByMonthDayList = byMonthDayList;
    }

    public List<Integer> getByMonthList() {
        return this.mByMonthList;
    }

    public void setByMonthList(List<Integer> byMonthList) {
        this.mByMonthList = byMonthList;
    }

    public List<Integer> getBySecondList() {
        return this.mBySecondList;
    }

    public void setBySecondList(List<Integer> bySecondList) {
        this.mBySecondList = bySecondList;
    }

    public List<Integer> getBySetPosList() {
        return this.mBySetPosList;
    }

    public void setBySetPosList(List<Integer> bySetPosList) {
        this.mBySetPosList = bySetPosList;
    }

    public List<Integer> getByWeekNoList() {
        return this.mByWeekNoList;
    }

    public void setByWeekNoList(List<Integer> byWeekNoList) {
        this.mByWeekNoList = byWeekNoList;
    }

    public List<Integer> getByYearDayList() {
        return this.mByYearDayList;
    }

    public void setByYearDayList(List<Integer> byYearDayList) {
        this.mByYearDayList = byYearDayList;
    }

    public int getCount() {
        return this.mCount;
    }

    public void setCount(int count) {
        this.mCount = count;
    }

    public Frequency getFrequency() {
        return this.mFreq;
    }

    public void setFrequency(Frequency freq) {
        this.mFreq = freq;
    }

    public int getInterval() {
        return this.mInterval;
    }

    public void setInterval(int interval) {
        this.mInterval = interval;
    }

    public ParsedDateTime getUntil() {
        return this.mUntil;
    }

    public void setUntil(ParsedDateTime until) {
        this.mUntil = until;
    }

    public ZWeekDay getWkSt() {
        return this.mWkSt;
    }

    public void setWkSt(ZWeekDay wkSt) {
        this.mWkSt = wkSt;
    }

    public void setByDayList(List<ZWeekDayNum> byDayList) {
        this.mByDayList = byDayList;
    }

    public List<ZWeekDayNum> getByDayList() {
        return this.mByDayList;
    }

    public List<Date> expandRecurrenceOverRange(ParsedDateTime dtStart, long rangeStart, long rangeEnd) throws ServiceException {
        int maxInstancesFromConfig;
        Date until;
        LinkedList<Date> toRet = new LinkedList<Date>();
        Date rangeStartDate = new Date(rangeStart);
        Date rangeEndDate = new Date(rangeEnd - 1000L);
        Date dtStartDate = new Date(dtStart.getUtcTime());
        Date earliestDate = dtStartDate.after(rangeStartDate) ? dtStartDate : rangeStartDate;
        if (this.mUntil != null && (until = this.mUntil.getDateForRecurUntil(dtStart.getTimeZone())).before(rangeEndDate)) {
            rangeEndDate = until;
        }
        int maxInstancesExpanded = (maxInstancesFromConfig = ZRecur.sExpansionLimits.maxInstances) <= 0 ? this.mCount : (this.mCount <= 0 ? maxInstancesFromConfig : Math.min(this.mCount, maxInstancesFromConfig));
        int numInstancesExpanded = 1;
        Date hardEndDate = this.getEstimatedEndTime(dtStart);
        if (hardEndDate.before(rangeEndDate)) {
            rangeEndDate = hardEndDate;
        }
        if (rangeEndDate.before(earliestDate)) {
            return toRet;
        }
        GregorianCalendar cur = dtStart.getCalendarCopy();
        int baseMonthDay = cur.get(5);
        int interval = this.mInterval;
        if (interval <= 0) {
            interval = 1;
        }
        if (!dtStartDate.before(earliestDate) && !dtStartDate.after(rangeEndDate)) {
            toRet.add(dtStartDate);
        }
        int numConsecutiveIterationsWithoutMatchingInstance = 0;
        boolean pastHardEndTime = false;
        long numIterations = 0L;
        block7: while (!(pastHardEndTime || maxInstancesExpanded > 0 && numInstancesExpanded >= maxInstancesExpanded)) {
            ++numIterations;
            boolean curIsAtOrAfterEarliestDate = !cur.getTime().before(earliestDate);
            boolean curIsAfterEndDate = cur.getTime().after(rangeEndDate);
            List<Calendar> addList = new LinkedList<Calendar>();
            switch (this.mFreq) {
                case HOURLY: {
                    if (!this.checkMonthList(cur) || !this.checkYearDayList(cur) || !this.checkMonthDayList(cur) || !this.checkDayList(cur) || !this.checkHourList(cur)) continue block7;
                    addList.add((Calendar)cur.clone());
                    cur.add(11, interval);
                    addList = this.expandHourList(addList);
                    addList = this.expandMinuteList(addList);
                    addList = this.expandSecondList(addList);
                    break;
                }
                case DAILY: {
                    if (!this.checkMonthList(cur) || !this.checkYearDayList(cur) || !this.checkMonthDayList(cur) || !this.checkDayList(cur)) continue block7;
                    addList.add((Calendar)cur.clone());
                    cur.add(6, interval);
                    addList = this.expandHourList(addList);
                    addList = this.expandMinuteList(addList);
                    addList = this.expandSecondList(addList);
                    break;
                }
                case WEEKLY: {
                    if (!this.checkMonthList(cur) || !this.checkYearDayList(cur) || !this.checkMonthDayList(cur)) continue block7;
                    addList.add((Calendar)cur.clone());
                    cur.add(3, interval);
                    addList = this.expandDayListForWeekly(addList);
                    addList = this.expandHourList(addList);
                    addList = this.expandMinuteList(addList);
                    addList = this.expandSecondList(addList);
                    break;
                }
                case MONTHLY: {
                    if (!this.checkMonthList(cur) || !this.checkYearDayList(cur)) continue block7;
                    addList.add((Calendar)cur.clone());
                    cur.set(5, 1);
                    cur.add(2, interval);
                    int daysInMonth = cur.getActualMaximum(5);
                    cur.set(5, Math.min(baseMonthDay, daysInMonth));
                    addList = this.expandMonthDayList(addList);
                    addList = this.expandDayListForMonthlyYearly(addList);
                    addList = this.expandHourList(addList);
                    addList = this.expandMinuteList(addList);
                    addList = this.expandSecondList(addList);
                    break;
                }
                case YEARLY: {
                    addList.add((Calendar)cur.clone());
                    cur.add(1, interval);
                    addList = this.expandMonthList(addList);
                    addList = this.expandYearDayList(addList);
                    addList = this.expandMonthDayList(addList);
                    addList = this.expandDayListForMonthlyYearly(addList);
                    addList = this.expandHourList(addList);
                    addList = this.expandMinuteList(addList);
                    addList = this.expandSecondList(addList);
                    break;
                }
                default: {
                    return toRet;
                }
            }
            addList = this.handleSetPos(addList);
            boolean noInstanceFound = true;
            boolean foundInstancePastEndDate = false;
            for (Calendar addCal : addList) {
                Date toAdd = addCal.getTime();
                if (toAdd.compareTo(dtStartDate) == 0) {
                    noInstanceFound = false;
                    continue;
                }
                if (toAdd.after(dtStartDate)) {
                    ++numInstancesExpanded;
                }
                if (!toAdd.after(rangeEndDate)) {
                    if (!toAdd.before(earliestDate)) {
                        toRet.add(toAdd);
                        noInstanceFound = false;
                    }
                } else {
                    foundInstancePastEndDate = true;
                    break;
                }
                if (maxInstancesExpanded <= 0 || numInstancesExpanded < maxInstancesExpanded) continue;
                break;
            }
            if (curIsAtOrAfterEarliestDate) {
                numConsecutiveIterationsWithoutMatchingInstance = noInstanceFound ? ++numConsecutiveIterationsWithoutMatchingInstance : 0;
                if (numConsecutiveIterationsWithoutMatchingInstance >= 4) {
                    ZimbraLog.calendar.warn("Invalid recurrence rule: " + this.toString());
                    return toRet;
                }
            }
            pastHardEndTime = foundInstancePastEndDate || noInstanceFound && curIsAfterEndDate;
        }
        return toRet;
    }

    public String toString() {
        StringBuffer toRet = new StringBuffer("FREQ=").append((Object)this.mFreq);
        if (this.mUntil != null) {
            toRet.append(';').append("UNTIL=");
            toRet.append(this.mUntil.getDateTimePartString(false));
        }
        if (this.mCount > 0) {
            toRet.append(';').append("COUNT=").append(this.mCount);
        }
        if (this.mInterval > 0) {
            toRet.append(';').append("INTERVAL=").append(this.mInterval);
        }
        if (this.mBySecondList.size() > 0) {
            toRet.append(';').append("BYSECOND=").append(ZRecur.listAsStr(this.mBySecondList));
        }
        if (this.mByMinuteList.size() > 0) {
            toRet.append(';').append("BYMINUTE=").append(ZRecur.listAsStr(this.mByMinuteList));
        }
        if (this.mByHourList.size() > 0) {
            toRet.append(';').append("BYHOUR=").append(ZRecur.listAsStr(this.mByHourList));
        }
        if (this.mByDayList.size() > 0) {
            toRet.append(';').append("BYDAY=").append(ZRecur.listAsStr(this.mByDayList));
        }
        if (this.mByMonthDayList.size() > 0) {
            toRet.append(';').append("BYMONTHDAY=").append(ZRecur.listAsStr(this.mByMonthDayList));
        }
        if (this.mByYearDayList.size() > 0) {
            toRet.append(';').append("BYYEARDAY=").append(ZRecur.listAsStr(this.mByYearDayList));
        }
        if (this.mByWeekNoList.size() > 0) {
            toRet.append(';').append("BYWEEKNO=").append(ZRecur.listAsStr(this.mByWeekNoList));
        }
        if (this.mByMonthList.size() > 0) {
            toRet.append(';').append("BYMONTH=").append(ZRecur.listAsStr(this.mByMonthList));
        }
        if (this.mBySetPosList.size() > 0) {
            toRet.append(';').append("BYSETPOS=").append(ZRecur.listAsStr(this.mBySetPosList));
        }
        return toRet.toString();
    }

    private boolean checkDayList(GregorianCalendar cal) {
        assert (this.mFreq != Frequency.MONTHLY && this.mFreq != Frequency.YEARLY && this.mFreq != Frequency.WEEKLY);
        if (this.mByDayList.size() > 0) {
            for (ZWeekDayNum listCur : this.mByDayList) {
                int curDayOfWeek = cal.get(7);
                if (listCur.mDay.getCalendarDay() == curDayOfWeek) {
                    return true;
                }
                if (listCur.mDay.getCalendarDay() <= curDayOfWeek) continue;
                cal.set(7, listCur.mDay.getCalendarDay());
                return false;
            }
            cal.set(7, this.mByDayList.get((int)0).mDay.getCalendarDay());
            cal.add(3, 1);
            return false;
        }
        return true;
    }

    private boolean checkHourList(GregorianCalendar cal) {
        if (this.mByHourList.size() > 0) {
            for (Integer cur : this.mByHourList) {
                int curHour = cal.get(11);
                if (curHour == cur) {
                    return true;
                }
                if (cur <= curHour) continue;
                cal.set(11, cur);
                return false;
            }
            cal.set(10, this.mByHourList.get(0));
            cal.add(6, 1);
            return false;
        }
        return true;
    }

    private boolean checkMonthDayList(GregorianCalendar cal) {
        if (this.mByMonthDayList.size() > 0) {
            for (Integer cur : this.mByMonthDayList) {
                int curMonthDay = cal.get(5);
                if (cur == curMonthDay) {
                    return true;
                }
                if (cur <= curMonthDay) continue;
                cal.set(5, cur);
                return false;
            }
            cal.set(5, this.mByMonthDayList.get(0));
            cal.add(2, 1);
            return false;
        }
        return true;
    }

    private boolean checkMonthList(GregorianCalendar cal) {
        if (this.mByMonthList.size() > 0) {
            for (Integer cur : this.mByMonthList) {
                int curMonth = cal.get(2) + 1;
                if (cur == curMonth) {
                    return true;
                }
                if (cur <= curMonth) continue;
                cal.set(2, cur - 1);
                return false;
            }
            cal.set(2, this.mByMonthList.get(0) - 1);
            cal.add(1, 1);
            return false;
        }
        return true;
    }

    private boolean checkYearDayList(GregorianCalendar cal) {
        if (this.mByYearDayList.size() > 0) {
            for (Integer cur : this.mByYearDayList) {
                int curYearDay = cal.get(6);
                if (cur == curYearDay) {
                    return true;
                }
                if (cur <= curYearDay) continue;
                cal.set(6, cur);
                return false;
            }
            cal.set(6, this.mByYearDayList.get(0));
            cal.add(1, 1);
            return false;
        }
        return true;
    }

    private List<Calendar> expandDayListForMonthlyYearly(List<Calendar> list) {
        assert (this.mFreq == Frequency.MONTHLY || this.mFreq == Frequency.YEARLY);
        if (this.mByDayList.size() <= 0) {
            return list;
        }
        ArrayList<Calendar> toRet = new ArrayList<Calendar>();
        HashSet<Integer> months = new HashSet<Integer>();
        for (Calendar cur : list) {
            int curYear = cur.get(1);
            int curMonth = cur.get(2);
            if (months.contains(curMonth)) continue;
            months.add(curMonth);
            for (ZWeekDayNum day : this.mByDayList) {
                ArrayList<Integer> matching = new ArrayList<Integer>();
                cur.set(5, 1);
                do {
                    if (cur.get(7) == day.mDay.getCalendarDay()) {
                        matching.add(cur.get(5));
                    }
                    cur.add(5, 1);
                } while (cur.get(2) == curMonth);
                cur.set(2, curMonth);
                cur.set(1, curYear);
                if (day.mOrdinal == 0) {
                    for (Integer matchDay : matching) {
                        cur.set(5, matchDay);
                        toRet.add((Calendar)cur.clone());
                    }
                    continue;
                }
                if (day.mOrdinal > 0) {
                    if (day.mOrdinal > matching.size()) continue;
                    cur.set(5, (Integer)matching.get(day.mOrdinal - 1));
                    toRet.add((Calendar)cur.clone());
                    continue;
                }
                if (-1 * day.mOrdinal > matching.size()) continue;
                cur.set(5, (Integer)matching.get(matching.size() + day.mOrdinal));
                toRet.add((Calendar)cur.clone());
            }
        }
        assert (toRet instanceof ArrayList);
        Collections.sort(toRet);
        return toRet;
    }

    private List<Calendar> expandDayListForWeekly(List<Calendar> list) {
        assert (this.mFreq == Frequency.WEEKLY);
        if (this.mByDayList.size() <= 0) {
            return list;
        }
        LinkedList<Calendar> toRet = new LinkedList<Calendar>();
        for (Calendar cur : list) {
            for (ZWeekDayNum day : this.mByDayList) {
                cur.set(7, day.mDay.getCalendarDay());
                toRet.add((Calendar)cur.clone());
            }
        }
        return toRet;
    }

    private List<Calendar> expandHourList(List<Calendar> list) {
        assert (this.mFreq == Frequency.DAILY || this.mFreq == Frequency.WEEKLY || this.mFreq == Frequency.MONTHLY || this.mFreq == Frequency.YEARLY);
        if (this.mByHourList.size() <= 0) {
            return list;
        }
        LinkedList<Calendar> toRet = new LinkedList<Calendar>();
        for (Calendar cur : list) {
            for (Integer hour : this.mByHourList) {
                cur.set(11, hour);
                toRet.add((Calendar)cur.clone());
            }
        }
        return toRet;
    }

    private List<Calendar> expandMinuteList(List<Calendar> list) {
        assert (this.mFreq != Frequency.MINUTELY && this.mFreq != Frequency.SECONDLY);
        if (this.mByMinuteList.size() <= 0) {
            return list;
        }
        LinkedList<Calendar> toRet = new LinkedList<Calendar>();
        for (Calendar cur : list) {
            for (Integer minute : this.mByMinuteList) {
                cur.set(12, minute);
                toRet.add((Calendar)cur.clone());
            }
        }
        return toRet;
    }

    private List<Calendar> expandMonthDayList(List<Calendar> list) {
        assert (this.mFreq == Frequency.MONTHLY || this.mFreq == Frequency.YEARLY);
        if (this.mByMonthDayList.size() <= 0) {
            return list;
        }
        LinkedList<Calendar> toRet = new LinkedList<Calendar>();
        for (Calendar cur : list) {
            int curMonth = cur.get(2);
            int lastMonthDay = cur.getActualMaximum(5);
            boolean seenLastMonthDay = false;
            for (Integer moday : this.mByMonthDayList) {
                if (moday == 0) continue;
                if (moday > 0) {
                    if (moday >= lastMonthDay) {
                        if (seenLastMonthDay) continue;
                        seenLastMonthDay = true;
                        moday = lastMonthDay;
                    }
                    cur.set(5, moday);
                } else {
                    if (moday == -1) {
                        if (seenLastMonthDay) continue;
                        seenLastMonthDay = true;
                    }
                    cur.set(5, 1);
                    cur.roll(5, moday);
                }
                assert (cur.get(2) == curMonth);
                toRet.add((Calendar)cur.clone());
            }
        }
        return toRet;
    }

    private List<Calendar> expandMonthList(List<Calendar> list) {
        assert (this.mFreq == Frequency.YEARLY);
        if (this.mByMonthList.size() <= 0) {
            return list;
        }
        LinkedList<Calendar> toRet = new LinkedList<Calendar>();
        for (Calendar cur : list) {
            for (Integer month : this.mByMonthList) {
                cur.set(2, month - 1);
                toRet.add((Calendar)cur.clone());
            }
        }
        return toRet;
    }

    private List<Calendar> expandSecondList(List<Calendar> list) {
        assert (this.mFreq != Frequency.SECONDLY);
        if (this.mBySecondList.size() <= 0) {
            return list;
        }
        LinkedList<Calendar> toRet = new LinkedList<Calendar>();
        for (Calendar cur : list) {
            for (Integer second : this.mBySecondList) {
                cur.set(13, second);
                toRet.add((Calendar)cur.clone());
            }
        }
        return toRet;
    }

    private List<Calendar> expandYearDayList(List<Calendar> list) {
        assert (this.mFreq == Frequency.YEARLY);
        if (this.mByYearDayList.size() <= 0) {
            return list;
        }
        LinkedList<Calendar> toRet = new LinkedList<Calendar>();
        HashSet<Integer> years = new HashSet<Integer>();
        for (Calendar cur : list) {
            int curYear = cur.get(1);
            if (years.contains(curYear)) continue;
            years.add(curYear);
            for (Integer yearDay : this.mByYearDayList) {
                if (yearDay > 0) {
                    cur.set(6, yearDay);
                } else {
                    cur.set(6, 1);
                    cur.roll(6, yearDay);
                }
                toRet.add((Calendar)cur.clone());
            }
        }
        return toRet;
    }

    private List<Calendar> handleSetPos(List<Calendar> list) {
        if (this.mBySetPosList.size() <= 0) {
            return list;
        }
        Calendar[] array = new Calendar[list.size()];
        array = list.toArray(array);
        LinkedList<Calendar> toRet = new LinkedList<Calendar>();
        ArrayList<Integer> idxsToInclude = new ArrayList<Integer>();
        for (Integer cur : this.mBySetPosList) {
            int idx = cur;
            if (idx < -366 || idx > 366 || idx == 0) continue;
            idx = idx > 0 ? --idx : array.length + idx;
            if (idx < 0 || idx >= array.length || idxsToInclude.contains(idx)) continue;
            idxsToInclude.add(idx);
        }
        Collections.sort(idxsToInclude);
        for (Integer idx : idxsToInclude) {
            toRet.add(array[idx]);
        }
        return toRet;
    }

    private void parse(String str, TimeZoneMap tzmap) throws ServiceException {
        try {
            for (String tok : str.split("\\s*;\\s*")) {
                String[] s = tok.split("\\s*=\\s*");
                if (s.length != 2) {
                    if (!ZimbraLog.calendar.isDebugEnabled()) continue;
                    ZimbraLog.calendar.debug(new Formatter().format("Parse error for recur: \"%s\" at token \"%s\"", str, tok));
                    continue;
                }
                String rhs = s[1];
                rhs = rhs.replaceAll("\\s+", "");
                try {
                    switch (Tokens.valueOf(s[0])) {
                        case FREQ: {
                            this.mFreq = Frequency.valueOf(rhs);
                            break;
                        }
                        case UNTIL: {
                            ParsedDateTime until = ParsedDateTime.parse(rhs, tzmap);
                            if (until == null) break;
                            if (until.hasTime()) {
                                until.toUTC();
                            }
                            this.mUntil = until;
                            break;
                        }
                        case COUNT: {
                            this.mCount = Integer.parseInt(rhs);
                            break;
                        }
                        case INTERVAL: {
                            this.mInterval = Integer.parseInt(rhs);
                            break;
                        }
                        case BYSECOND: {
                            this.parseIntList(rhs, this.mBySecondList, 0, 59, false);
                            break;
                        }
                        case BYMINUTE: {
                            this.parseIntList(rhs, this.mByMinuteList, 0, 59, false);
                            break;
                        }
                        case BYHOUR: {
                            this.parseIntList(rhs, this.mByHourList, 0, 23, false);
                            break;
                        }
                        case BYDAY: {
                            this.parseByDayList(rhs, this.mByDayList);
                            break;
                        }
                        case BYMONTHDAY: {
                            this.parseIntList(rhs, this.mByMonthDayList, -31, 31, true);
                            break;
                        }
                        case BYYEARDAY: {
                            this.parseIntList(rhs, this.mByYearDayList, -366, 366, true);
                            break;
                        }
                        case BYWEEKNO: {
                            this.parseIntList(rhs, this.mByWeekNoList, -53, 53, true);
                            break;
                        }
                        case BYMONTH: {
                            this.parseIntList(rhs, this.mByMonthList, 1, 12, false);
                            break;
                        }
                        case BYSETPOS: {
                            this.parseIntList(rhs, this.mBySetPosList, Integer.MIN_VALUE, Integer.MAX_VALUE, true);
                            break;
                        }
                        case WKST: {
                            this.mWkSt = ZWeekDay.valueOf(rhs);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    ZimbraLog.calendar.warn("Skipping RECUR token: \"%s\" in Recur \"%s\" due to parse error", (Object)s[0], (Object)str, e);
                }
            }
        }
        catch (ParseException e) {
            throw ServiceException.FAILURE("Parse error for recur \"" + str + "\"", e);
        }
    }

    private static int parseSignedInt(String str) {
        if (str == null) {
            throw new NumberFormatException("null is not a number");
        }
        int len = str.length();
        if (len == 0) {
            throw new NumberFormatException("empty string is not a number");
        }
        int num = 0;
        if (str.charAt(0) == '+') {
            if (len == 1) {
                throw new NumberFormatException("+ is not a number");
            }
            num = Integer.parseInt(str.substring(1));
        } else {
            num = Integer.parseInt(str);
        }
        return num;
    }

    private static int parseUnsignedInt(String str) {
        if (str == null) {
            throw new NumberFormatException("null is not a number");
        }
        int len = str.length();
        if (len == 0) {
            throw new NumberFormatException("empty string is not a number");
        }
        char sign = str.charAt(0);
        if (sign == '+' || sign == '-') {
            throw new NumberFormatException("sign not allowed: " + str);
        }
        return Integer.parseInt(str);
    }

    private void parseByDayList(String str, List<ZWeekDayNum> list) {
        for (String s : str.split("\\s*,\\s*")) {
            ZWeekDayNum wdn = new ZWeekDayNum();
            String dayStr = s;
            if (s.length() > 2) {
                String numStr = s.substring(0, s.length() - 2);
                dayStr = dayStr.substring(s.length() - 2);
                wdn.mOrdinal = ZRecur.parseSignedInt(numStr);
            }
            wdn.mDay = ZWeekDay.valueOf(dayStr);
            list.add(wdn);
        }
        Collections.sort(list, new ZWeekDayNum.DayOnlyComparator());
    }

    private void parseIntList(String str, List<Integer> list, int min, int max, boolean signed) {
        for (String s : str.split("\\s*,\\s*")) {
            try {
                int readInt = signed ? ZRecur.parseSignedInt(s) : ZRecur.parseUnsignedInt(s);
                if (readInt < min || readInt > max) continue;
                list.add(readInt);
            }
            catch (Exception e) {
                ZimbraLog.calendar.debug(new Formatter().format("Skipping unparsable Recur int list entry: \"%s\" in parameter list: \"%s\"", s, str));
            }
        }
        Collections.sort(list);
    }

    static {
        try {
            Server server = Provisioning.getInstance().getLocalServer();
            String val = server.getAttr("zimbraCalendarRecurrenceMaxInstances");
            ZRecur.sExpansionLimits.maxInstances = val == null ? 0 : Integer.parseInt(val);
            val = server.getAttr("zimbraCalendarRecurrenceDailyMaxDays");
            ZRecur.sExpansionLimits.maxDays = val == null ? 730 : Integer.parseInt(val);
            val = server.getAttr("zimbraCalendarRecurrenceWeeklyMaxWeeks");
            ZRecur.sExpansionLimits.maxWeeks = val == null ? 520 : Integer.parseInt(val);
            val = server.getAttr("zimbraCalendarRecurrenceMonthlyMaxMonths");
            ZRecur.sExpansionLimits.maxMonths = val == null ? 360 : Integer.parseInt(val);
            val = server.getAttr("zimbraCalendarRecurrenceYearlyMaxYears");
            ZRecur.sExpansionLimits.maxYears = val == null ? 100 : Integer.parseInt(val);
            val = server.getAttr("zimbraCalendarRecurrenceOtherFrequencyMaxYears");
            ZRecur.sExpansionLimits.maxYearsOtherFreqs = val == null ? 1 : Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            Zimbra.halt("Can't initialize recurrence expansion limits", e);
        }
        catch (ServiceException e) {
            Zimbra.halt("Can't initialize recurrence expansion limits", e);
        }
    }

    private static class ExpansionLimits {
        public int maxInstances;
        public int maxDays;
        public int maxWeeks;
        public int maxMonths;
        public int maxYears;
        public int maxYearsOtherFreqs;

        private ExpansionLimits() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Tokens {
        BYDAY,
        BYHOUR,
        BYMINUTE,
        BYMONTH,
        BYMONTHDAY,
        BYSECOND,
        BYSETPOS,
        BYWEEKNO,
        BYYEARDAY,
        COUNT,
        FREQ,
        INTERVAL,
        UNTIL,
        WKST;

    }

    public static class ZWeekDayNum {
        public ZWeekDay mDay;
        public int mOrdinal;

        public ZWeekDayNum() {
        }

        public ZWeekDayNum(int ord, ZWeekDay day) {
            this.mOrdinal = ord;
            this.mDay = day;
        }

        public String toString() {
            if (this.mOrdinal != 0) {
                return Integer.toString(this.mOrdinal) + (Object)((Object)this.mDay);
            }
            return this.mDay.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class DayOnlyComparator
        implements Comparator<ZWeekDayNum> {
            @Override
            public int compare(ZWeekDayNum lhs, ZWeekDayNum rhs) {
                return lhs.mDay.getCalendarDay() - rhs.mDay.getCalendarDay();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZWeekDay {
        FR,
        MO,
        SA,
        SU,
        TH,
        TU,
        WE;


        public int getCalendarDay() {
            switch (this) {
                case SU: {
                    return 1;
                }
                case MO: {
                    return 2;
                }
                case TU: {
                    return 3;
                }
                case WE: {
                    return 4;
                }
                case TH: {
                    return 5;
                }
                case FR: {
                    return 6;
                }
            }
            return 7;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Frequency {
        DAILY,
        HOURLY,
        MINUTELY,
        MONTHLY,
        SECONDLY,
        WEEKLY,
        YEARLY;

    }
}

