/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.CalendarUser;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ToXML;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZOrganizer
extends CalendarUser {
    public ZOrganizer(String address, String cn) {
        super(address, cn, null, null, null);
    }

    public ZOrganizer(String address, String cn, String sentBy, String dir, String language, List<ZCalendar.ZParameter> xparams) {
        super(address, cn, sentBy, dir, language, xparams);
    }

    public ZOrganizer(ZOrganizer other) {
        super(other);
    }

    public ZOrganizer(ZCalendar.ZProperty prop) {
        super(prop);
    }

    public ZOrganizer(Metadata meta) throws ServiceException {
        super(meta);
    }

    @Override
    protected ZCalendar.ICalTok getPropertyName() {
        return ZCalendar.ICalTok.ORGANIZER;
    }

    public Element toXml(Element parent) {
        Element orgElt = parent.addUniqueElement("or");
        String str = this.getAddress();
        orgElt.addAttribute("a", IDNUtil.toUnicode(str));
        orgElt.addAttribute("url", str);
        if (this.hasCn()) {
            orgElt.addAttribute("d", this.getCn());
        }
        if (this.hasSentBy()) {
            orgElt.addAttribute("sentBy", this.getSentBy());
        }
        if (this.hasDir()) {
            orgElt.addAttribute("dir", this.getDir());
        }
        if (this.hasLanguage()) {
            orgElt.addAttribute("lang", this.getLanguage());
        }
        ToXML.encodeXParams(orgElt, this.xparamsIterator());
        return orgElt;
    }

    public static ZOrganizer parse(Element element) throws ServiceException {
        String address = IDNUtil.toAscii(element.getAttribute("a", null));
        if (address == null && (address = element.getAttribute("url", null)) == null) {
            throw ServiceException.INVALID_REQUEST("missing organizer address", null);
        }
        String cn = element.getAttribute("d", null);
        String sentBy = element.getAttribute("sentBy", null);
        String dir = element.getAttribute("dir", null);
        String lang = element.getAttribute("lang", null);
        List<ZCalendar.ZParameter> xparams = CalendarUtils.parseXParams(element);
        ZOrganizer org = new ZOrganizer(address, cn, sentBy, dir, lang, xparams);
        return org;
    }
}

