/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.CalendarParserImpl;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZCalendar {
    public static final String sZimbraProdID = "Zimbra-Calendar-Provider";
    public static final String sIcalVersion = "2.0";
    public static final String sObsoleteVcalVersion = "1.0";
    private static final String LINE_BREAK = "\r\n";
    private static final Pattern MUST_ESCAPE = Pattern.compile("[,;\"\n\\\\]");
    private static final Pattern SIMPLE_ESCAPE = Pattern.compile("([,;\"\\\\])");
    private static final Pattern NEWLINE_CRLF_ESCAPE = Pattern.compile("\r\n");
    private static final Pattern NEWLINE_BARE_CR_OR_LF_ESCAPE = Pattern.compile("[\r\n]");
    private static final Pattern SIMPLE_ESCAPED = Pattern.compile("\\\\([,;\"\\\\])");
    private static final Pattern NEWLINE_ESCAPED = Pattern.compile("\\\\n");
    private static final Pattern MUST_QUOTE = Pattern.compile("[;:,]");

    public static String escape(String str) {
        if (str != null && MUST_ESCAPE.matcher(str).find()) {
            String toRet = SIMPLE_ESCAPE.matcher(str).replaceAll("\\\\$1");
            toRet = NEWLINE_CRLF_ESCAPE.matcher(toRet).replaceAll("\\\\n");
            toRet = NEWLINE_BARE_CR_OR_LF_ESCAPE.matcher(toRet).replaceAll("\\\\n");
            return toRet;
        }
        return str;
    }

    public static String unescape(String str) {
        if (str != null && str.indexOf(92) >= 0) {
            String toRet = SIMPLE_ESCAPED.matcher(str).replaceAll("$1");
            return NEWLINE_ESCAPED.matcher(toRet).replaceAll(LINE_BREAK);
        }
        return str;
    }

    public static String quote(String str) {
        if (str != null && MUST_QUOTE.matcher(str).find()) {
            return "\"" + str + "\"";
        }
        return str;
    }

    public static String unquote(String str) {
        if (str != null && str.length() > 2 && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String toCommaSepText(List<String> vals) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String val : vals) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(ZCalendar.escape(val));
        }
        return sb.toString();
    }

    public static List<String> parseCommaSepText(String encoded) {
        int len;
        ArrayList<String> list = new ArrayList<String>();
        if (encoded != null && (len = encoded.length()) > 0) {
            int start = 0;
            char prev = encoded.charAt(0);
            for (int i = 0; i < len; ++i) {
                char curr = encoded.charAt(i);
                if (curr == ',' && prev != '\\') {
                    String val = encoded.substring(start, i);
                    list.add(ZCalendar.unescape(val));
                    start = i + 1;
                }
                prev = curr;
            }
            String val = encoded.substring(start);
            list.add(ZCalendar.unescape(val));
        }
        return list;
    }

    static ZProperty findProp(List<ZProperty> list, ICalTok tok) {
        for (ZProperty prop : list) {
            if (prop.mTok != tok) continue;
            return prop;
        }
        return null;
    }

    static ZParameter findParameter(List<ZParameter> list, ICalTok tok) {
        for (ZParameter param : list) {
            if (param.mTok != tok) continue;
            return param;
        }
        return null;
    }

    static ZComponent findComponent(List<ZComponent> list, ICalTok tok) {
        for (ZComponent comp : list) {
            if (comp.mTok != tok) continue;
            return comp;
        }
        return null;
    }

    public static void main(String[] args) {
        String str1 = ",foo,,bar,,b\\,az,,,";
        List<String> list = ZCalendar.parseCommaSepText(str1);
        String str2 = ZCalendar.toCommaSepText(list);
        if (!str1.equals(str2)) {
            System.err.println("Different!");
        }
        try {
            String s = "This, is; my \"string\", and\\or \nI hope\r\nyou like it";
            System.out.println("Original: " + s + "\n\n\nEscaped: " + ZCalendar.escape(s) + "\n\n\nUnescaped:" + ZCalendar.unescape(ZCalendar.escape(s)));
            System.out.println("\n\n\n");
            s = "\"Foo Bar Gub\"";
            System.out.println("Unquoted:" + s + "\nQuoted:" + ZCalendar.unquote(s));
            System.out.println("\n\n\n");
            s = "Blah Bar Blah";
            System.out.println("Unquoted:" + s + "\nQuoted:" + ZCalendar.unquote(s));
            System.out.println("\n\n\n");
            s = "\"US & Canadia -- Foo\\Bar\"";
            System.out.println("String = " + s);
            ZParameter param = new ZParameter(ICalTok.TZID, s);
            System.out.println("TZID   = " + param.getValue());
            StringWriter writer = new StringWriter();
            param.toICalendar(writer);
            System.out.println("ICAL: " + writer.toString());
            System.out.println("\n\n\n");
        }
        catch (Exception e) {
            System.out.println("Caught exception: " + e);
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZCalendarBuilder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ZVCalendar build(String icalStr) throws ServiceException {
            ZVCalendar zVCalendar;
            ByteArrayInputStream bais = null;
            try {
                bais = new ByteArrayInputStream(icalStr.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw ServiceException.FAILURE("Can't get input stream from string", e);
            }
            try {
                zVCalendar = ZCalendarBuilder.build(bais, "utf-8");
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    bais.close();
                }
                catch (IOException e) {}
                throw throwable;
            }
            try {
                bais.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return zVCalendar;
        }

        public static ZVCalendar build(InputStream is, String charset) throws ServiceException {
            List<ZVCalendar> list = ZCalendarBuilder.buildMulti(is, charset);
            int len = list.size();
            if (len == 1) {
                return list.get(0);
            }
            if (len > 1) {
                ZimbraLog.calendar.warn("Returning only the first ZCALENDAR after parsing " + len);
                return list.get(0);
            }
            throw ServiceException.PARSE_ERROR("No ZCALENDAR found", null);
        }

        public static List<ZVCalendar> buildMulti(InputStream is, String charset) throws ServiceException {
            DefaultContentHandler handler = new DefaultContentHandler();
            ZCalendarBuilder.parse(is, charset, handler);
            return handler.getCals();
        }

        public static void parse(InputStream is, String charset, ZICalendarParseHandler handler) throws ServiceException {
            BufferedInputStream bis = new BufferedInputStream(is);
            bis.mark(32768);
            CalendarParserImpl parser = new CalendarParserImpl();
            try {
                parser.parse((InputStream)bis, charset, (ContentHandler)handler);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("Caught IOException parsing calendar: " + e, e);
            }
            catch (ParserException e) {
                StringBuilder s = new StringBuilder("Caught ParseException parsing calendar: " + (Object)((Object)e));
                try {
                    bis.reset();
                    byte[] ics = new byte[32768];
                    int bytesRead = bis.read(ics, 0, ics.length);
                    if (bytesRead > 0) {
                        String icsStr = new String(ics, 0, bytesRead, charset);
                        s.append(icsStr).append("\n");
                        if (bytesRead == ics.length) {
                            s.append("...\n");
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ServiceException se = ServiceException.PARSE_ERROR(s.toString(), e);
                if (handler.inZCalendar() || handler.getNumCals() < 1) {
                    throw se;
                }
                if (ZimbraLog.calendar.isDebugEnabled()) {
                    ZimbraLog.calendar.warn((Object)("Ignoring bad data at the end of text/calendar part: " + s.toString()), e);
                }
                ZimbraLog.calendar.warn("Ignoring bad data at the end of text/calendar part: " + e.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultContentHandler
    implements ZICalendarParseHandler {
        List<ZVCalendar> mCals = new ArrayList<ZVCalendar>(1);
        ZVCalendar mCurCal = null;
        List<ZComponent> mComponents = new ArrayList<ZComponent>();
        ZProperty mCurProperty = null;
        private int mNumCals;
        private boolean mInZCalendar;

        private DefaultContentHandler() {
        }

        public List<ZVCalendar> getCals() {
            return this.mCals;
        }

        public void startCalendar() {
            this.mInZCalendar = true;
            this.mCurCal = new ZVCalendar();
            this.mCals.add(this.mCurCal);
        }

        public void endCalendar() {
            this.mCurCal = null;
            this.mInZCalendar = false;
            ++this.mNumCals;
        }

        @Override
        public boolean inZCalendar() {
            return this.mInZCalendar;
        }

        @Override
        public int getNumCals() {
            return this.mNumCals;
        }

        public void startComponent(String name) {
            ZComponent newComponent = new ZComponent(name);
            if (this.mComponents.size() > 0) {
                this.mComponents.get((int)(this.mComponents.size() - 1)).mComponents.add(newComponent);
            } else {
                this.mCurCal.mComponents.add(newComponent);
            }
            this.mComponents.add(newComponent);
        }

        public void endComponent(String name) {
            this.mComponents.remove(this.mComponents.size() - 1);
        }

        public void startProperty(String name) {
            this.mCurProperty = new ZProperty(name);
            if (this.mComponents.size() > 0) {
                this.mComponents.get((int)(this.mComponents.size() - 1)).mProperties.add(this.mCurProperty);
            } else {
                this.mCurCal.mProperties.add(this.mCurProperty);
            }
        }

        public void propertyValue(String value) throws ParserException {
            this.mCurProperty.mValue = value;
            if (this.mComponents.size() == 0 && ICalTok.VERSION.equals((Object)this.mCurProperty.getToken())) {
                if (ZCalendar.sObsoleteVcalVersion.equals(value)) {
                    throw new ParserException("vCalendar 1.0 format not supported; use iCalendar instead");
                }
                if (!ZCalendar.sIcalVersion.equals(value)) {
                    throw new ParserException("Unknow iCalendar version " + value);
                }
            }
        }

        public void endProperty(String name) {
            this.mCurProperty = null;
        }

        public void parameter(String name, String value) {
            ZParameter param = new ZParameter(name, value);
            if (this.mCurProperty != null) {
                this.mCurProperty.mParameters.add(param);
            } else {
                ZimbraLog.calendar.debug("ERROR: got parameter " + name + "," + value + " outside of Property");
            }
        }
    }

    public static interface ZICalendarParseHandler
    extends ContentHandler {
        public boolean inZCalendar();

        public int getNumCals();
    }

    public static class ZParameter {
        ICalTok mTok;
        String mName;
        String maValue;

        public ZParameter(String name, String value) {
            this.setName(name);
            this.setValue(value);
            this.mTok = ICalTok.lookup(this.mName);
        }

        public ZParameter(ICalTok tok, String value) {
            this.mTok = tok;
            this.mName = tok.toString();
            this.setValue(value);
        }

        public ZParameter(ICalTok tok, boolean value) {
            this.mTok = tok;
            this.mName = tok.toString();
            this.maValue = value ? "TRUE" : "FALSE";
        }

        public void setName(String name) {
            this.mName = ZCalendar.unescape(name.toUpperCase());
        }

        public void setValue(String value) {
            this.maValue = ZCalendar.unescape(ZCalendar.unquote(value));
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String INDENT) {
            StringBuffer toRet = new StringBuffer(INDENT).append("PARAM:").append(this.mName).append('(').append((Object)this.mTok).append(')').append(':').append(this.maValue).append('\n');
            return toRet.toString();
        }

        public void toICalendar(Writer w) throws IOException {
            this.toICalendar(w, false);
        }

        public void toICalendar(Writer w, boolean needAppleICalHacks) throws IOException {
            w.write(59);
            w.write(ZCalendar.escape(this.mName));
            w.write(61);
            if (this.maValue == null || this.maValue.length() == 0) {
                w.write("\"\"");
            } else if (ICalTok.CN.equals((Object)this.mTok)) {
                w.write(ZParameter.sanitizeParamValue(this.maValue));
            } else if (this.maValue.startsWith("\"") && this.maValue.endsWith("\"")) {
                w.write(34);
                w.write(ZCalendar.escape(this.maValue.substring(1, this.maValue.length() - 1)));
                w.write(34);
            } else if (ICalTok.TZID.equals((Object)this.mTok)) {
                boolean entourageCompat;
                String value = this.maValue;
                if (needAppleICalHacks) {
                    value = TZIDMapper.canonicalize(value);
                }
                if (entourageCompat = LC.calendar_entourage_compatible_timezones.booleanValue()) {
                    w.write(34);
                    w.write(value);
                    w.write(34);
                } else {
                    w.write(ZCalendar.quote(value));
                }
            } else {
                w.write(ZCalendar.quote(this.maValue));
            }
        }

        public ICalTok getToken() {
            return this.mTok;
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.maValue;
        }

        long getLongValue() {
            return Long.parseLong(this.maValue);
        }

        int getIntValue() {
            return Integer.parseInt(this.maValue);
        }

        private static String sanitizeParamValue(String str) {
            int end;
            int start;
            boolean needToQuote;
            if (str == null) {
                return "";
            }
            int len = str.length();
            if (len == 0) {
                return "";
            }
            if (len >= 2 && str.charAt(0) == '\"' && str.charAt(len - 1) == '\"') {
                needToQuote = true;
                start = 1;
                end = len - 1;
            } else {
                needToQuote = false;
                start = 0;
                end = len;
            }
            StringBuilder sb = new StringBuilder(len + 2);
            sb.append('\"');
            for (int i = start; i < end; ++i) {
                int ch = str.charAt(i);
                if (!(ch >= 60 && ch <= 126 || ch == 32 || ch >= 45 && ch <= 57 || ch >= 35 && ch <= 43 || ch == 9 || ch == 33)) {
                    if (ch >= 128 || ch == 44 || ch == 58 || ch == 59) {
                        needToQuote = true;
                    } else {
                        ch = ch == 34 ? 39 : 63;
                    }
                }
                sb.append((char)ch);
            }
            sb.append('\"');
            if (needToQuote) {
                return sb.toString();
            }
            return sb.substring(1, sb.length() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZProperty {
        List<ZParameter> mParameters = new ArrayList<ZParameter>();
        private static final int CHARS_PER_FOLDED_LINE = 76;
        ICalTok mTok;
        String mName;
        String mValue;

        public ZProperty(String name) {
            this.setName(name);
            this.mTok = ICalTok.lookup(this.mName);
        }

        public ZProperty(ICalTok tok) {
            this.mTok = tok;
            this.mName = tok.toString();
        }

        public ZProperty(ICalTok tok, String value) {
            this.mTok = tok;
            this.mName = tok.toString();
            this.setValue(value);
        }

        public ZProperty(ICalTok tok, boolean value) {
            this.mTok = tok;
            this.mName = tok.toString();
            this.mValue = value ? "TRUE" : "FALSE";
        }

        public ZProperty(ICalTok tok, long value) {
            this.mTok = tok;
            this.mName = tok.toString();
            this.mValue = Long.toString(value);
        }

        public ZProperty(ICalTok tok, int value) {
            this.mTok = tok;
            this.mName = tok.toString();
            this.mValue = Integer.toString(value);
        }

        public void setName(String name) {
            this.mName = ZCalendar.unescape(name.toUpperCase());
        }

        public void setValue(String value) {
            this.mValue = ZCalendar.unescape(value);
        }

        public void addParameter(ZParameter param) {
            this.mParameters.add(param);
        }

        public ZParameter getParameter(ICalTok tok) {
            return ZCalendar.findParameter(this.mParameters, tok);
        }

        public Iterator<ZParameter> parameterIterator() {
            return this.mParameters.iterator();
        }

        public int getNumParameters() {
            return this.mParameters.size();
        }

        String getParameterVal(ICalTok tok, String defaultValue) {
            ZParameter param = ZCalendar.findParameter(this.mParameters, tok);
            if (param != null) {
                return param.getValue();
            }
            return defaultValue;
        }

        public String paramVal(ICalTok tok, String defaultValue) {
            ZParameter param = this.getParameter(tok);
            if (param != null) {
                return ZCalendar.unquote(param.getValue());
            }
            return defaultValue;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String INDENT) {
            StringBuffer toRet = new StringBuffer(INDENT).append("PROPERTY:").append(this.mName).append('(').append((Object)this.mTok).append(')').append('\n');
            String NEW_INDENT = INDENT + '\t';
            for (ZParameter param : this.mParameters) {
                toRet.append(param.toString(NEW_INDENT));
            }
            toRet.append(NEW_INDENT).append("VALUE=\"").append(this.mValue).append("\"\n");
            toRet.append(INDENT).append("END:").append(this.mName).append('\n');
            return toRet.toString();
        }

        public void toICalendar(Writer w) throws IOException {
            this.toICalendar(w, false);
        }

        public void toICalendar(Writer w, boolean needAppleICalHacks) throws IOException {
            StringWriter sw = new StringWriter();
            sw.write(ZCalendar.escape(this.mName));
            for (ZParameter param : this.mParameters) {
                param.toICalendar(sw, needAppleICalHacks);
            }
            sw.write(58);
            if (this.mValue != null) {
                String value = this.mValue;
                boolean noEscape = false;
                if (this.mTok != null) {
                    switch (this.mTok) {
                        case RRULE: 
                        case EXRULE: 
                        case RDATE: 
                        case EXDATE: 
                        case CATEGORIES: 
                        case GEO: {
                            noEscape = true;
                        }
                    }
                    if (needAppleICalHacks && this.mTok.equals((Object)ICalTok.TZID)) {
                        value = TZIDMapper.canonicalize(value);
                    }
                }
                if (noEscape) {
                    sw.write(value);
                } else {
                    sw.write(ZCalendar.escape(value));
                }
            }
            String rawval = sw.toString();
            int len = rawval.length();
            for (int i = 0; i < len; i += 76) {
                int upto = Math.min(i + 76, len);
                String segment = rawval.substring(i, upto);
                if (i > 0) {
                    w.write(ZCalendar.LINE_BREAK);
                    w.write(32);
                }
                w.write(segment);
            }
            w.write(ZCalendar.LINE_BREAK);
        }

        public ICalTok getToken() {
            return this.mTok;
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.mValue;
        }

        public long getLongValue() {
            return Long.parseLong(this.mValue);
        }

        public int getIntValue() {
            return Integer.parseInt(this.mValue);
        }

        public boolean getBoolValue() {
            return this.mValue.equalsIgnoreCase("TRUE");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZComponent {
        private String mName;
        ICalTok mTok;
        List<ZProperty> mProperties = new ArrayList<ZProperty>();
        List<ZComponent> mComponents = new ArrayList<ZComponent>();

        public ZComponent(String name) {
            this.mName = name.toUpperCase();
            this.mTok = ICalTok.lookup(this.mName);
        }

        public ZComponent(ICalTok tok) {
            this.mTok = tok;
            this.mName = tok.toString();
        }

        public String getName() {
            return this.mName;
        }

        public ICalTok getTok() {
            return this.mTok;
        }

        public void addProperty(ZProperty prop) {
            this.mProperties.add(prop);
        }

        public void addComponent(ZComponent comp) {
            this.mComponents.add(comp);
        }

        public ZComponent getComponent(ICalTok tok) {
            return ZCalendar.findComponent(this.mComponents, tok);
        }

        public Iterator<ZComponent> getComponentIterator() {
            return this.mComponents.iterator();
        }

        public Iterator<ZProperty> getPropertyIterator() {
            return this.mProperties.iterator();
        }

        public ZProperty getProperty(ICalTok tok) {
            return ZCalendar.findProp(this.mProperties, tok);
        }

        public String getPropVal(ICalTok tok, String defaultValue) {
            ZProperty prop = this.getProperty(tok);
            if (prop != null) {
                return prop.mValue;
            }
            return defaultValue;
        }

        long getPropLongVal(ICalTok tok, long defaultValue) {
            ZProperty prop = this.getProperty(tok);
            if (prop != null) {
                return Long.parseLong(prop.mValue);
            }
            return defaultValue;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String INDENT) {
            StringBuffer toRet = new StringBuffer(INDENT).append("COMPONENT:").append(this.mName).append('(').append((Object)this.mTok).append(')').append('\n');
            String NEW_INDENT = INDENT + '\t';
            for (ZProperty prop : this.mProperties) {
                toRet.append(prop.toString(NEW_INDENT));
            }
            for (ZComponent comp : this.mComponents) {
                toRet.append(comp.toString(NEW_INDENT));
            }
            toRet.append(INDENT).append("END:").append(this.mName).append('\n');
            return toRet.toString();
        }

        public void toICalendar(Writer w) throws IOException {
            this.toICalendar(w, false);
        }

        public void toICalendar(Writer w, boolean needAppleICalHacks) throws IOException {
            w.write("BEGIN:");
            String name = ZCalendar.escape(this.mName);
            w.write(name);
            w.write(ZCalendar.LINE_BREAK);
            for (ZProperty prop : this.mProperties) {
                if (needAppleICalHacks && ICalTok.X_ALT_DESC.equals((Object)prop.getToken())) continue;
                prop.toICalendar(w, needAppleICalHacks);
            }
            for (ZComponent comp : this.mComponents) {
                comp.toICalendar(w, needAppleICalHacks);
            }
            w.write("END:");
            w.write(name);
            w.write(ZCalendar.LINE_BREAK);
        }

        public String getDescriptionHtml() {
            for (ZProperty prop : this.mProperties) {
                ZParameter fmttype;
                if (!ICalTok.X_ALT_DESC.equals((Object)prop.getToken()) || (fmttype = prop.getParameter(ICalTok.FMTTYPE)) == null || !"text/html".equalsIgnoreCase(fmttype.getValue())) continue;
                return prop.getValue();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZVCalendar {
        List<ZComponent> mComponents = new ArrayList<ZComponent>();
        List<ZProperty> mProperties = new ArrayList<ZProperty>();

        public ZVCalendar() {
            this.addProperty(new ZProperty(ICalTok.PRODID, ZCalendar.sZimbraProdID));
            this.addProperty(new ZProperty(ICalTok.VERSION, ZCalendar.sIcalVersion));
        }

        public void addProperty(ZProperty prop) {
            this.mProperties.add(prop);
        }

        public void addComponent(ZComponent comp) {
            this.mComponents.add(comp);
        }

        public ZComponent getComponent(ICalTok tok) {
            return ZCalendar.findComponent(this.mComponents, tok);
        }

        public Iterator<ZComponent> getComponentIterator() {
            return this.mComponents.iterator();
        }

        public ZProperty getProperty(ICalTok tok) {
            return ZCalendar.findProp(this.mProperties, tok);
        }

        public String getPropVal(ICalTok tok, String defaultValue) {
            ZProperty prop = this.getProperty(tok);
            if (prop != null) {
                return prop.mValue;
            }
            return defaultValue;
        }

        public long getPropLongVal(ICalTok tok, long defaultValue) {
            ZProperty prop = this.getProperty(tok);
            if (prop != null) {
                return Long.parseLong(prop.mValue);
            }
            return defaultValue;
        }

        public String toString() {
            StringBuffer toRet = new StringBuffer("BEGIN:VCALENDAR");
            toRet.append(ZCalendar.LINE_BREAK);
            String INDENT = "\t";
            for (ZProperty prop : this.mProperties) {
                toRet.append(prop.toString(INDENT));
            }
            for (ZComponent comp : this.mComponents) {
                toRet.append(comp.toString(INDENT));
            }
            toRet.append("END:VCALENDAR");
            return toRet.toString();
        }

        public void toICalendar(Writer w) throws IOException {
            this.toICalendar(w, false);
        }

        public void toICalendar(Writer w, boolean needAppleICalHacks) throws IOException {
            w.write("BEGIN:VCALENDAR");
            w.write(ZCalendar.LINE_BREAK);
            for (ZProperty prop : this.mProperties) {
                prop.toICalendar(w, needAppleICalHacks);
            }
            for (ZComponent comp : this.mComponents) {
                comp.toICalendar(w, needAppleICalHacks);
            }
            w.write("END:VCALENDAR");
        }

        public void addDescription(String desc, String descHtml) {
            ZProperty descProp = new ZProperty(ICalTok.DESCRIPTION, desc);
            ZProperty altDescProp = new ZProperty(ICalTok.X_ALT_DESC, descHtml);
            altDescProp.addParameter(new ZParameter(ICalTok.FMTTYPE, "text/html"));
            for (ZComponent comp : this.mComponents) {
                ICalTok name = comp.getTok();
                if (!ICalTok.VEVENT.equals((Object)name) && !ICalTok.VTODO.equals((Object)name) && !ICalTok.VJOURNAL.equals((Object)name)) continue;
                if (desc != null && desc.length() > 0) {
                    ZProperty prop = comp.getProperty(ICalTok.DESCRIPTION);
                    if (prop == null) {
                        comp.addProperty(descProp);
                    } else {
                        String val = prop.getValue();
                        if (val == null || val.length() < 1) {
                            prop.setValue(desc);
                        }
                    }
                }
                if (descHtml == null || descHtml.length() <= 0) continue;
                comp.addProperty(altDescProp);
            }
        }

        public ICalTok getMethod() {
            String methodStr;
            ICalTok ret = null;
            ZProperty method = this.getProperty(ICalTok.METHOD);
            if (method != null && (methodStr = method.getValue()) != null) {
                try {
                    ret = ICalTok.valueOf(methodStr);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ICalTok {
        ACTION,
        ALTREP,
        ATTACH,
        ATTENDEE,
        BINARY,
        BOOLEAN,
        CAL_ADDRESS,
        CALSCALE,
        CATEGORIES,
        CLASS,
        CN,
        COMMENT,
        COMPLETED,
        CONTACT,
        CREATED,
        CUTYPE,
        DATE,
        DATE_TIME,
        DELEGATED_FROM,
        DELEGATED_TO,
        DESCRIPTION,
        DIR,
        DTEND,
        DTSTAMP,
        DTSTART,
        DUE,
        DURATION,
        ENCODING,
        EXDATE,
        EXRULE,
        FBTYPE,
        FLOAT,
        FMTTYPE,
        FREEBUSY,
        GEO,
        INTEGER,
        LANGUAGE,
        LAST_MODIFIED,
        LOCATION,
        MEMBER,
        METHOD,
        ORGANIZER,
        PARTSTAT,
        PERCENT_COMPLETE,
        PERIOD,
        PRIORITY,
        PRODID,
        RDATE,
        RECUR,
        RECURRENCE_ID,
        RELATED,
        RELATED_TO,
        RELTYPE,
        REPEAT,
        RESOURCES,
        ROLE,
        RRULE,
        RSVP,
        SENT_BY,
        SEQUENCE,
        STATUS,
        SUMMARY,
        TEXT,
        TIME,
        TRANSP,
        TRIGGER,
        TZID,
        TZNAME,
        TZOFFSETFROM,
        TZOFFSETTO,
        TZURL,
        UID,
        URI,
        URL,
        UTC_OFFSET,
        VALARM,
        VALUE,
        VERSION,
        VEVENT,
        VFREEBUSY,
        VJOURNAL,
        VTIMEZONE,
        VTODO,
        PUBLISH,
        REQUEST,
        REPLY,
        ADD,
        CANCEL,
        REFRESH,
        COUNTER,
        DECLINECOUNTER,
        PUBLIC,
        PRIVATE,
        CONFIDENTIAL,
        CHAIR,
        REQ_PARTICIPANT,
        OPT_PARTICIPANT,
        NON_PARTICIPANT,
        INDIVIDUAL,
        GROUP,
        RESOURCE,
        ROOM,
        UNKNOWN,
        TENTATIVE,
        CONFIRMED,
        NEEDS_ACTION,
        IN_PROCESS,
        CANCELLED,
        DRAFT,
        FINAL,
        ACCEPTED,
        DECLINED,
        DELEGATED,
        TRANSPARENT,
        OPAQUE,
        STANDARD,
        DAYLIGHT,
        RANGE,
        THISANDFUTURE,
        THISANDPRIOR,
        X_ALT_DESC,
        X_MICROSOFT_CDO_ALLDAYEVENT,
        X_MICROSOFT_CDO_INTENDEDSTATUS,
        X_MICROSOFT_DISALLOW_COUNTER,
        X_ZIMBRA_STATUS,
        X_ZIMBRA_STATUS_WAITING,
        X_ZIMBRA_STATUS_DEFERRED,
        X_ZIMBRA_PARTSTAT_WAITING,
        X_ZIMBRA_PARTSTAT_DEFERRED,
        X_ZIMBRA_LOCAL_ONLY,
        X_ZIMBRA_DISCARD_EXCEPTIONS;


        public static ICalTok lookup(String str) {
            try {
                str = str.replace('-', '_');
                return ICalTok.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public String toString() {
            return super.toString().replace('_', '-');
        }
    }
}

