/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.CalendarUser;
import com.zimbra.cs.mailbox.calendar.IcalXmlStrMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ToXML;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZAttendee
extends CalendarUser {
    private static final String FN_CUTYPE = "cut";
    private static final String FN_ROLE = "r";
    private static final String FN_PARTSTAT = "ptst";
    private static final String FN_RSVP_BOOL = "v";
    private static final String FN_MEMBER = "member";
    private static final String FN_DELEGATED_TO = "delto";
    private static final String FN_DELEGATED_FROM = "delfrom";
    private String mCUType;
    private String mRole;
    private String mPartStat;
    private Boolean mRsvp;
    private String mMember;
    private String mDelegatedTo;
    private String mDelegatedFrom;

    public boolean hasCUType() {
        return !StringUtil.isNullOrEmpty(this.mCUType);
    }

    public String getCUType() {
        return this.mCUType != null ? this.mCUType : "";
    }

    public void setCUType(String cutype) {
        if (cutype != null && !IcalXmlStrMap.sCUTypeMap.validXml(cutype)) {
            cutype = IcalXmlStrMap.sCUTypeMap.toXml(cutype);
        }
        this.mCUType = cutype;
    }

    public boolean hasRole() {
        return !StringUtil.isNullOrEmpty(this.mRole);
    }

    public String getRole() {
        return this.mRole != null ? this.mRole : "";
    }

    public void setRole(String role) {
        if (role != null && !IcalXmlStrMap.sRoleMap.validXml(role)) {
            role = IcalXmlStrMap.sRoleMap.toXml(role);
        }
        this.mRole = role;
    }

    public boolean hasPartStat() {
        return !StringUtil.isNullOrEmpty(this.mPartStat);
    }

    public String getPartStat() {
        return this.mPartStat != null ? this.mPartStat : "";
    }

    public void setPartStat(String partStat) {
        if (partStat != null && !IcalXmlStrMap.sPartStatMap.validXml(partStat)) {
            partStat = IcalXmlStrMap.sPartStatMap.toXml(partStat);
        }
        this.mPartStat = partStat;
    }

    public boolean hasRsvp() {
        return this.mRsvp != null;
    }

    public Boolean getRsvp() {
        return this.mRsvp;
    }

    public void setRsvp(Boolean rsvp) {
        this.mRsvp = rsvp;
    }

    public boolean hasMember() {
        return !StringUtil.isNullOrEmpty(this.mMember);
    }

    public String getMember() {
        return this.mMember;
    }

    public void setMember(String member) {
        this.mMember = ZAttendee.getMailToAddress(member);
    }

    public boolean hasDelegatedTo() {
        return !StringUtil.isNullOrEmpty(this.mDelegatedTo);
    }

    public String getDelegatedTo() {
        return this.mDelegatedTo;
    }

    public void setDelegatedTo(String delTo) {
        this.mDelegatedTo = ZAttendee.getMailToAddress(delTo);
    }

    public boolean hasDelegatedFrom() {
        return !StringUtil.isNullOrEmpty(this.mDelegatedFrom);
    }

    public String getDelegatedFrom() {
        return this.mDelegatedFrom;
    }

    public void setDelegatedFrom(String delFrom) {
        this.mDelegatedFrom = ZAttendee.getMailToAddress(delFrom);
    }

    public ZAttendee(ZAttendee other) {
        super(other);
        this.mCUType = other.mCUType;
        this.mRole = other.mRole;
        this.mPartStat = other.mPartStat;
        this.mRsvp = other.mRsvp;
        this.mMember = other.mMember;
        this.mDelegatedTo = other.mDelegatedTo;
        this.mDelegatedFrom = other.mDelegatedFrom;
    }

    public ZAttendee(String address, String cn, String sentBy, String dir, String language, String cutype, String role, String ptst, Boolean rsvp, String member, String delegatedTo, String delegatedFrom, List<ZCalendar.ZParameter> xparams) {
        super(address, cn, sentBy, dir, language, xparams);
        this.setCUType(cutype);
        this.setRole(role);
        this.setPartStat(ptst);
        this.setRsvp(rsvp);
        this.setMember(member);
        this.setDelegatedTo(delegatedTo);
        this.setDelegatedFrom(delegatedFrom);
    }

    public ZAttendee(String address) {
        this(address, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public ZAttendee(ZCalendar.ZProperty prop) {
        super(prop);
        this.setCUType(prop.paramVal(ZCalendar.ICalTok.CUTYPE, null));
        this.setRole(prop.paramVal(ZCalendar.ICalTok.ROLE, null));
        this.setPartStat(prop.paramVal(ZCalendar.ICalTok.PARTSTAT, null));
        String rsvpStr = prop.paramVal(ZCalendar.ICalTok.RSVP, "FALSE");
        boolean rsvp = false;
        if (rsvpStr.equalsIgnoreCase("TRUE")) {
            rsvp = true;
        }
        this.setRsvp(rsvp);
        this.setMember(prop.paramVal(ZCalendar.ICalTok.MEMBER, null));
        this.setDelegatedTo(prop.paramVal(ZCalendar.ICalTok.DELEGATED_TO, null));
        this.setDelegatedFrom(prop.paramVal(ZCalendar.ICalTok.DELEGATED_FROM, null));
    }

    public ZAttendee(Metadata meta) throws ServiceException {
        super(meta);
        this.setCUType(meta.get(FN_CUTYPE, null));
        this.setRole(meta.get(FN_ROLE, null));
        this.setPartStat(meta.get(FN_PARTSTAT, null));
        Boolean rsvp = null;
        if (meta.containsKey(FN_RSVP_BOOL)) {
            rsvp = meta.getBool(FN_RSVP_BOOL) ? Boolean.TRUE : Boolean.FALSE;
        }
        this.setRsvp(rsvp);
        this.setMember(meta.get(FN_MEMBER, null));
        this.setDelegatedTo(meta.get(FN_DELEGATED_TO, null));
        this.setDelegatedFrom(meta.get(FN_DELEGATED_FROM, null));
    }

    public Metadata encodeAsMetadata() {
        Metadata meta = super.encodeMetadata();
        if (this.hasCUType()) {
            meta.put(FN_CUTYPE, this.getCUType());
        }
        if (this.hasRole()) {
            meta.put(FN_ROLE, this.getRole());
        }
        if (this.hasPartStat()) {
            meta.put(FN_PARTSTAT, this.getPartStat());
        }
        if (this.hasRsvp() && this.getRsvp().booleanValue()) {
            meta.put(FN_RSVP_BOOL, "1");
        }
        if (this.hasMember()) {
            meta.put(FN_MEMBER, this.getMember());
        }
        if (this.hasDelegatedTo()) {
            meta.put(FN_DELEGATED_TO, this.getDelegatedTo());
        }
        if (this.hasDelegatedFrom()) {
            meta.put(FN_DELEGATED_FROM, this.getDelegatedFrom());
        }
        return meta;
    }

    @Override
    protected ZCalendar.ICalTok getPropertyName() {
        return ZCalendar.ICalTok.ATTENDEE;
    }

    @Override
    protected void setProperty(ZCalendar.ZProperty prop) throws ServiceException {
        super.setProperty(prop);
        if (this.hasCUType()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.CUTYPE, IcalXmlStrMap.sCUTypeMap.toIcal(this.getCUType())));
        }
        if (this.hasRole()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.ROLE, IcalXmlStrMap.sRoleMap.toIcal(this.getRole())));
        }
        if (this.hasPartStat()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.PARTSTAT, IcalXmlStrMap.sPartStatMap.toIcal(this.getPartStat())));
        }
        if (this.hasRsvp()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.RSVP, this.getRsvp()));
        }
        if (this.hasMember()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.MEMBER, "MAILTO:" + this.getMember()));
        }
        if (this.hasDelegatedTo()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.DELEGATED_TO, "MAILTO:" + this.getDelegatedTo()));
        }
        if (this.hasDelegatedFrom()) {
            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.DELEGATED_FROM, "MAILTO:" + this.getDelegatedFrom()));
        }
    }

    @Override
    protected StringBuilder addToStringBuilder(StringBuilder sb) {
        if (this.hasCUType()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("CUTYPE=").append(this.getCUType());
        }
        if (this.hasRole()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("ROLE=").append(this.getRole());
        }
        if (this.hasPartStat()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("PARTSTAT=").append(this.getPartStat());
        }
        if (this.hasRsvp()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("RSVP=");
            if (this.getRsvp().booleanValue()) {
                sb.append("TRUE");
            } else {
                sb.append("FALSE");
            }
        }
        if (this.hasMember()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("MEMBER=\"MAILTO:").append(this.getMember()).append('\"');
        }
        if (this.hasDelegatedTo()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("DELEGATED-TO=\"MAILTO:").append(this.getDelegatedTo()).append('\"');
        }
        if (this.hasDelegatedTo()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("DELEGATED-FROM=\"MAILTO:").append(this.getDelegatedFrom()).append('\"');
        }
        sb = super.addToStringBuilder(sb);
        return sb;
    }

    public boolean addressesMatch(ZAttendee other) {
        return this.getAddress().equalsIgnoreCase(other.getAddress());
    }

    public boolean addressMatches(String addr) {
        return this.getAddress().equalsIgnoreCase(addr);
    }

    public Element toXml(Element parent) {
        Element atElt = parent.addElement("at");
        atElt.addAttribute("a", IDNUtil.toUnicode(this.getAddress()));
        atElt.addAttribute("url", this.getAddress());
        if (this.hasCn()) {
            atElt.addAttribute("d", this.getCn());
        }
        if (this.hasSentBy()) {
            atElt.addAttribute("sentBy", this.getSentBy());
        }
        if (this.hasDir()) {
            atElt.addAttribute("dir", this.getDir());
        }
        if (this.hasLanguage()) {
            atElt.addAttribute("lang", this.getLanguage());
        }
        if (this.hasCUType()) {
            atElt.addAttribute("cutype", this.getCUType());
        }
        if (this.hasRole()) {
            atElt.addAttribute("role", this.getRole());
        }
        if (this.hasPartStat()) {
            atElt.addAttribute(FN_PARTSTAT, this.getPartStat());
        }
        if (this.hasRsvp()) {
            atElt.addAttribute("rsvp", this.getRsvp());
        }
        if (this.hasMember()) {
            atElt.addAttribute(FN_MEMBER, this.getMember());
        }
        if (this.hasDelegatedTo()) {
            atElt.addAttribute("delTo", this.getDelegatedTo());
        }
        if (this.hasDelegatedFrom()) {
            atElt.addAttribute("delFrom", this.getDelegatedFrom());
        }
        ToXML.encodeXParams(atElt, this.xparamsIterator());
        return atElt;
    }

    public static ZAttendee parse(Element element) throws ServiceException {
        String partStat;
        String role;
        String address = IDNUtil.toAscii(element.getAttribute("a", null));
        if (address == null && (address = element.getAttribute("url", null)) == null) {
            throw ServiceException.INVALID_REQUEST("missing attendee address", null);
        }
        String cn = element.getAttribute("d", null);
        String sentBy = element.getAttribute("sentBy", null);
        String dir = element.getAttribute("dir", null);
        String lang = element.getAttribute("lang", null);
        String cutype = element.getAttribute("cutype", null);
        if (cutype != null) {
            ZAttendee.validateAttr(IcalXmlStrMap.sCUTypeMap, "cutype", cutype);
        }
        if ((role = element.getAttribute("role", null)) != null) {
            ZAttendee.validateAttr(IcalXmlStrMap.sRoleMap, "role", role);
        }
        if ((partStat = element.getAttribute(FN_PARTSTAT, null)) != null) {
            ZAttendee.validateAttr(IcalXmlStrMap.sPartStatMap, FN_PARTSTAT, partStat);
        }
        String member = element.getAttribute(FN_MEMBER, null);
        String delTo = element.getAttribute("delTo", null);
        String delFrom = element.getAttribute("delFrom", null);
        boolean rsvp = element.getAttributeBool("rsvp", false);
        List<ZCalendar.ZParameter> xparams = CalendarUtils.parseXParams(element);
        ZAttendee at = new ZAttendee(address, cn, sentBy, dir, lang, cutype, role, partStat, rsvp ? Boolean.TRUE : Boolean.FALSE, member, delTo, delFrom, xparams);
        return at;
    }

    private static void validateAttr(IcalXmlStrMap map, String attrName, String value) throws ServiceException {
        if (!map.validXml(value)) {
            throw ServiceException.INVALID_REQUEST("Invalid value '" + value + "' specified for attribute:" + attrName, null);
        }
    }
}

