/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.WindowsSystemTime;

public class WindowsTimeZoneInformation {
    private String mName;
    private String mStandardName;
    private String mDaylightName;
    private int mBiasMins;
    private WindowsSystemTime mStandardDate;
    private int mStandardBiasMins;
    private WindowsSystemTime mDaylightDate;
    private int mDaylightBiasMins;
    private int mStandardOffsetMillis;
    private int mDaylightOffsetMillis;

    public WindowsTimeZoneInformation(String name, int biasMins, WindowsSystemTime standardDate, int standardBiasMins, String standardName, WindowsSystemTime daylightDate, int daylightBiasMins, String daylightName) {
        this.mName = name;
        this.mBiasMins = biasMins;
        this.mStandardDate = standardDate;
        this.mStandardBiasMins = standardBiasMins;
        this.mDaylightDate = daylightDate;
        this.mDaylightBiasMins = daylightBiasMins;
        this.mStandardOffsetMillis = -1 * (this.mBiasMins + this.mStandardBiasMins) * 60 * 1000;
        this.mDaylightOffsetMillis = -1 * (this.mBiasMins + this.mDaylightBiasMins) * 60 * 1000;
        this.mStandardName = standardName;
        this.mDaylightName = daylightName;
    }

    public String getName() {
        return this.mName;
    }

    public long getBiasMins() {
        return this.mBiasMins;
    }

    public WindowsSystemTime getStandardDate() {
        return this.mStandardDate;
    }

    public int getStandardBiasMins() {
        return this.mStandardBiasMins;
    }

    public int getStandardOffset() {
        return this.mStandardOffsetMillis;
    }

    public String getStandardName() {
        return this.mStandardName;
    }

    public WindowsSystemTime getDaylightDate() {
        return this.mDaylightDate;
    }

    public int getDaylightBiasMins() {
        return this.mDaylightBiasMins;
    }

    public int getDaylightOffset() {
        return this.mDaylightOffsetMillis;
    }

    public String getDaylightName() {
        return this.mDaylightName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TIME_ZONE_INFORMATION {\n");
        sb.append("    Zone Name    = ").append(this.mName).append("\n");
        sb.append("    Bias         = ").append(this.mBiasMins).append("\n");
        sb.append("    StandardDate = ").append(this.mStandardDate).append("\n");
        sb.append("    StandardBias = ").append(this.mStandardBiasMins).append("\n");
        sb.append("    StandardName = ").append(this.mStandardName).append("\n");
        sb.append("    DaylightDate = ").append(this.mDaylightDate).append("\n");
        sb.append("    DaylightBias = ").append(this.mDaylightBiasMins).append("\n");
        sb.append("    DaylightName = ").append(this.mDaylightName).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public ICalTimeZone toICal() {
        ICalTimeZone.SimpleOnset standardOnset = null;
        if (this.mStandardDate != null) {
            standardOnset = this.mStandardDate.toSimpleOnset();
        }
        ICalTimeZone.SimpleOnset daylightOnset = null;
        if (this.mDaylightDate != null) {
            daylightOnset = this.mDaylightDate.toSimpleOnset();
        }
        return ICalTimeZone.lookup(this.mName, this.mStandardOffsetMillis, standardOnset, this.mStandardName, this.mDaylightOffsetMillis, daylightOnset, this.mDaylightName);
    }

    public static WindowsTimeZoneInformation fromICal(ICalTimeZone icalTz) {
        WindowsSystemTime standardDate = WindowsSystemTime.fromSimpleOnset(icalTz.getStandardOnset());
        WindowsSystemTime daylightDate = WindowsSystemTime.fromSimpleOnset(icalTz.getDaylightOnset());
        int bias = -1 * icalTz.getStandardOffset();
        int daylightBias = -1 * icalTz.getDaylightOffset() - bias;
        return new WindowsTimeZoneInformation(icalTz.getID(), bias / 60 / 1000, standardDate, 0, icalTz.getStandardTzname(), daylightDate, daylightBias / 60 / 1000, icalTz.getDaylightTzname());
    }
}

