/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import java.util.GregorianCalendar;

public class WindowsSystemTime {
    private int mYear;
    private int mMonth;
    private int mDayOfWeek;
    private int mDay;
    private int mHour;
    private int mMinute;
    private int mSecond;
    private int mMilliseconds;

    public WindowsSystemTime(int year, int month, int dayOfWeek, int day, int hour, int minute, int second, int milliseconds) {
        this.mYear = year;
        this.mMonth = month;
        this.mDayOfWeek = dayOfWeek;
        this.mDay = day;
        this.mHour = hour;
        this.mMinute = minute;
        this.mSecond = second;
        this.mMilliseconds = milliseconds;
        if (this.mYear == 0) {
            if (this.mDayOfWeek < 0 || this.mDayOfWeek > 6) {
                throw new IllegalArgumentException("DayOfWeek field must be in [0, 6] range");
            }
            if (this.mDay < 0 || this.mDay > 5) {
                throw new IllegalArgumentException("Day field specifying week number must be in [1, 5] range");
            }
        }
    }

    public int getYear() {
        return this.mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDayOfWeek() {
        return this.mDayOfWeek;
    }

    public int getDay() {
        return this.mDay;
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public int getSecond() {
        return this.mSecond;
    }

    public int getMilliseconds() {
        return this.mMilliseconds;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("SYSTEMTIME {\n");
        sb.append("    wYear         = ").append(this.mYear).append("\n");
        sb.append("    wMonth        = ").append(this.mMonth).append("\n");
        sb.append("    wDayOfWeek    = ").append(this.mDayOfWeek).append("\n");
        sb.append("    wDay          = ").append(this.mDay).append("\n");
        sb.append("    wHour         = ").append(this.mHour).append("\n");
        sb.append("    wMinute       = ").append(this.mMinute).append("\n");
        sb.append("    wSecond       = ").append(this.mSecond).append("\n");
        sb.append("    wMilliseconds = ").append(this.mMilliseconds).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public ICalTimeZone.SimpleOnset toSimpleOnset() {
        if (this.mYear != 0) {
            return null;
        }
        int week = this.mDay;
        if (week == 5) {
            week = -1;
        }
        return new ICalTimeZone.SimpleOnset(week, this.mDayOfWeek + 1, this.mMonth, this.mDay, this.mHour, this.mMinute, this.mSecond);
    }

    public static WindowsSystemTime fromSimpleOnset(ICalTimeZone.SimpleOnset onset) {
        if (onset == null) {
            return null;
        }
        int week = onset.getWeek();
        if (week == -1) {
            week = 5;
        }
        if (week != 0) {
            return new WindowsSystemTime(0, onset.getMonth(), onset.getDayOfWeek() - 1, week, onset.getHour(), onset.getMinute(), onset.getSecond(), 0);
        }
        GregorianCalendar cal = new GregorianCalendar();
        int year = cal.get(1);
        cal.set(year, onset.getMonth() - 1, onset.getDayOfMonth(), onset.getHour(), onset.getMinute());
        return new WindowsSystemTime(year, onset.getMonth(), cal.get(7) - 1, onset.getDayOfMonth(), onset.getHour(), onset.getMinute(), onset.getSecond(), 0);
    }
}

