/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class WellKnownTimeZones {
    private static Map<String, ICalTimeZone> sTZIDMap = new HashMap<String, ICalTimeZone>();
    private static Map<ICalTimeZone, ICalTimeZone> sOffsetRuleMatches = new TreeMap<ICalTimeZone, ICalTimeZone>(new SimpleYearlyTZComparator());

    public static ICalTimeZone getTimeZoneById(String tzid) {
        return sTZIDMap.get(tzid);
    }

    public static ICalTimeZone getBestMatch(ICalTimeZone tz) {
        return sOffsetRuleMatches.get(tz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadFromFile(File tzFile) throws IOException, ServiceException {
        ICalTimeZone itz;
        String id;
        Object tz;
        ZCalendar.ZVCalendar tzs;
        block9: {
            FileInputStream fis = null;
            tzs = null;
            try {
                fis = new FileInputStream(tzFile);
                tzs = ZCalendar.ZCalendarBuilder.build(new FileInputStream(tzFile), "utf-8");
                Object var4_3 = null;
                if (fis == null) break block9;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (fis != null) {
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
        }
        Iterator<ZCalendar.ZComponent> compIter = tzs.getComponentIterator();
        while (compIter.hasNext()) {
            ZCalendar.ZComponent tzComp = compIter.next();
            if (!ZCalendar.ICalTok.VTIMEZONE.equals((Object)tzComp.getTok())) continue;
            tz = ICalTimeZone.fromVTimeZone(tzComp, true);
            sTZIDMap.put(((TimeZone)tz).getID(), (ICalTimeZone)tz);
        }
        HashMap<String, Integer> matchScoreMap = new HashMap<String, Integer>();
        Iterator<TZIDMapper.TZ> tzIter = TZIDMapper.iterator(false);
        while (tzIter.hasNext()) {
            String[] aliases;
            tz = tzIter.next();
            id = ((TZIDMapper.TZ)tz).getID();
            matchScoreMap.put(id, ((TZIDMapper.TZ)tz).getMatchScore());
            itz = WellKnownTimeZones.getTimeZoneById(id);
            if (itz == null || (aliases = ((TZIDMapper.TZ)tz).getAliases()) == null) continue;
            for (String alias : aliases) {
                WellKnownTimeZones.addAlias(itz, alias);
            }
        }
        tzIter = TZIDMapper.iterator(false);
        while (tzIter.hasNext()) {
            int currentMatchScore;
            tz = tzIter.next();
            id = ((TZIDMapper.TZ)tz).getID();
            itz = WellKnownTimeZones.getTimeZoneById(id);
            if (itz == null) continue;
            ICalTimeZone current = sOffsetRuleMatches.get(itz);
            if (current == null) {
                sOffsetRuleMatches.put(itz, itz);
                continue;
            }
            String currentId = current.getID();
            int n = currentMatchScore = matchScoreMap.containsKey(currentId) ? (Integer)matchScoreMap.get(currentId) : 0;
            if (currentMatchScore >= ((TZIDMapper.TZ)tz).getMatchScore() && (currentMatchScore != ((TZIDMapper.TZ)tz).getMatchScore() || currentId.compareTo(id) <= 0)) continue;
            sOffsetRuleMatches.remove(itz);
            sOffsetRuleMatches.put(itz, itz);
        }
        return;
    }

    private static void addAlias(ICalTimeZone tz, String tzid) {
        ICalTimeZone existing = WellKnownTimeZones.getTimeZoneById(tzid);
        if (existing == null) {
            ICalTimeZone newTz = tz.cloneWithNewTZID(tzid);
            sTZIDMap.put(tzid, newTz);
        }
    }

    public static void main(String[] args) throws Exception {
        String tzFilePath = LC.timezone_file.value();
        File tzFile = new File(tzFilePath);
        WellKnownTimeZones.loadFromFile(tzFile);
        System.out.println("OFFSET/RULE MATCH TIME ZONES");
        System.out.println("----------------------------");
        Iterator<ICalTimeZone> piter = sOffsetRuleMatches.keySet().iterator();
        while (piter.hasNext()) {
            System.out.println(piter.next().getID());
        }
        System.out.println("(Total = " + sOffsetRuleMatches.size() + ")");
        System.out.println();
        int nTotal = 0;
        int nPrim = 0;
        int nNonPrim = 0;
        Iterator<TZIDMapper.TZ> tziter = TZIDMapper.iterator(false);
        while (tziter.hasNext()) {
            ++nTotal;
            TZIDMapper.TZ t = tziter.next();
            if (t.isPrimary()) {
                ++nPrim;
                ICalTimeZone tz = WellKnownTimeZones.getTimeZoneById(t.getID());
                ICalTimeZone match = sOffsetRuleMatches.get(tz);
                if (match == null) {
                    System.out.println("sOffsetRuleMatches map is missing primary TZ: " + tz.getID());
                    continue;
                }
                if (match.getID().equals(tz.getID())) continue;
                System.out.println("Mismatch for primary TZ: " + tz.getID() + " (map has " + match.getID() + ")");
                continue;
            }
            ++nNonPrim;
        }
        System.out.println("num primary in TZIDMapper     = " + nPrim);
        System.out.println("num non-primary in TZIDMapper = " + nNonPrim);
        System.out.println("num total in TZIDMapper       = " + nTotal);
        System.out.println();
        ICalTimeZone iPhonePacific = ICalTimeZone.lookup("GMT-08.00/-07.00", -28800000, "19710101T020000", "FREQ=YEARLY;INTERVAL=1;BYMONTH=11;BYDAY=1SU;WKST=MO", "PST", -25200000, "19710101T020000", "FREQ=YEARLY;INTERVAL=1;BYMONTH=3;BYDAY=2SU;WKST=MO", "PDT");
        System.out.println("iPhone Pacific: " + iPhonePacific.getID());
        ICalTimeZone primaryPacific = sOffsetRuleMatches.get(iPhonePacific);
        System.out.println("Primary Pacific: " + primaryPacific.getID());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleYearlyTZComparator
    implements Comparator<ICalTimeZone> {
        private SimpleYearlyTZComparator() {
        }

        private static int nullCompare(Object o1, Object o2) {
            if (o1 != null) {
                if (o2 != null) {
                    return 0;
                }
                return 1;
            }
            if (o2 != null) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compare(ICalTimeZone tz1, ICalTimeZone tz2) {
            int dayOff2;
            int stdOff2;
            if (tz1 == null || tz2 == null) {
                return SimpleYearlyTZComparator.nullCompare(tz1, tz2);
            }
            int stdOff1 = tz1.getStandardOffset();
            int comp = stdOff1 - (stdOff2 = tz2.getStandardOffset());
            if (comp != 0) {
                return comp;
            }
            int dayOff1 = tz1.getDaylightOffset();
            comp = dayOff1 - (dayOff2 = tz2.getDaylightOffset());
            if (comp != 0) {
                return comp;
            }
            assert (stdOff1 == stdOff2 && dayOff1 == dayOff2);
            if (stdOff1 == dayOff1) {
                return 0;
            }
            ICalTimeZone.SimpleOnset stdOnset1 = tz1.getStandardOnset();
            ICalTimeZone.SimpleOnset stdOnset2 = tz2.getStandardOnset();
            if (stdOnset1 != null || stdOnset2 != null) {
                comp = SimpleYearlyTZComparator.nullCompare(stdOnset1, stdOnset2);
                if (comp != 0) {
                    return comp;
                }
                comp = stdOnset1.compareTo(stdOnset2);
                if (comp != 0) {
                    return comp;
                }
            } else {
                String stdRule1 = tz1.getStandardRule();
                String stdRule2 = tz2.getStandardRule();
                comp = stdRule1 != null && stdRule2 != null ? stdRule1.compareTo(stdRule2) : SimpleYearlyTZComparator.nullCompare(stdRule1, stdRule2);
                if (comp != 0) {
                    return comp;
                }
                String stdDt1 = tz1.getStandardDtStart();
                String stdDt2 = tz2.getStandardDtStart();
                comp = stdDt1 != null && stdDt2 != null ? stdDt1.compareTo(stdDt2) : SimpleYearlyTZComparator.nullCompare(stdDt1, stdDt2);
                if (comp != 0) {
                    return comp;
                }
            }
            ICalTimeZone.SimpleOnset dayOnset1 = tz1.getDaylightOnset();
            ICalTimeZone.SimpleOnset dayOnset2 = tz2.getDaylightOnset();
            if (dayOnset1 != null || dayOnset2 != null) {
                comp = SimpleYearlyTZComparator.nullCompare(dayOnset1, dayOnset2);
                if (comp != 0) {
                    return comp;
                }
                comp = dayOnset1.compareTo(dayOnset2);
                if (comp != 0) {
                    return comp;
                }
            } else {
                String dayRule1 = tz1.getDaylightRule();
                String dayRule2 = tz2.getDaylightRule();
                comp = dayRule1 != null && dayRule2 != null ? dayRule1.compareTo(dayRule2) : SimpleYearlyTZComparator.nullCompare(dayRule1, dayRule2);
                if (comp != 0) {
                    return comp;
                }
                String dayDt1 = tz1.getDaylightDtStart();
                String dayDt2 = tz2.getDaylightDtStart();
                comp = dayDt1 != null && dayDt2 != null ? dayDt1.compareTo(dayDt2) : SimpleYearlyTZComparator.nullCompare(dayDt1, dayDt2);
                if (comp != 0) {
                    return comp;
                }
            }
            return 0;
        }
    }
}

