/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String FN_NAME = "n";
    private static final String FN_NUM_XPROPS_OR_XPARAMS = "numX";
    private static final String FN_VALUE = "v";
    private static final String FN_XPROP_OR_XPARAM = "x";

    public static void encodeXParamsAsMetadata(Metadata meta, Iterator<ZCalendar.ZParameter> xparamsIter) {
        int xparamCount = 0;
        while (xparamsIter.hasNext()) {
            ZCalendar.ZParameter xparam = xparamsIter.next();
            String paramName = xparam.getName();
            if (paramName == null) continue;
            Metadata paramMeta = new Metadata();
            paramMeta.put(FN_NAME, paramName);
            String paramValue = xparam.getValue();
            if (paramValue != null) {
                paramMeta.put(FN_VALUE, paramValue);
            }
            meta.put(FN_XPROP_OR_XPARAM + xparamCount, paramMeta);
            ++xparamCount;
        }
        if (xparamCount > 0) {
            meta.put(FN_NUM_XPROPS_OR_XPARAMS, xparamCount);
        }
    }

    public static void encodeXPropsAsMetadata(Metadata meta, Iterator<ZCalendar.ZProperty> xpropsIter) {
        int xpropCount = 0;
        while (xpropsIter.hasNext()) {
            ZCalendar.ZProperty xprop = xpropsIter.next();
            String propName = xprop.getName();
            if (propName == null) continue;
            Metadata propMeta = new Metadata();
            propMeta.put(FN_NAME, propName);
            String propValue = xprop.getValue();
            if (propValue != null) {
                propMeta.put(FN_VALUE, propValue);
            }
            Util.encodeXParamsAsMetadata(propMeta, xprop.parameterIterator());
            meta.put(FN_XPROP_OR_XPARAM + xpropCount, propMeta);
            ++xpropCount;
        }
        if (xpropCount > 0) {
            meta.put(FN_NUM_XPROPS_OR_XPARAMS, xpropCount);
        }
    }

    public static List<ZCalendar.ZParameter> decodeXParamsFromMetadata(Metadata meta) throws ServiceException {
        int xparamCount = (int)meta.getLong(FN_NUM_XPROPS_OR_XPARAMS, 0L);
        if (xparamCount > 0) {
            ArrayList<ZCalendar.ZParameter> list = new ArrayList<ZCalendar.ZParameter>(xparamCount);
            for (int paramNum = 0; paramNum < xparamCount; ++paramNum) {
                String paramName;
                Metadata paramMeta = meta.getMap(FN_XPROP_OR_XPARAM + paramNum, true);
                if (paramMeta == null || (paramName = paramMeta.get(FN_NAME, null)) == null) continue;
                String paramValue = paramMeta.get(FN_VALUE, null);
                ZCalendar.ZParameter xparam = new ZCalendar.ZParameter(paramName, paramValue);
                list.add(xparam);
            }
            return list;
        }
        return null;
    }

    public static List<ZCalendar.ZProperty> decodeXPropsFromMetadata(Metadata meta) throws ServiceException {
        int xpropCount = (int)meta.getLong(FN_NUM_XPROPS_OR_XPARAMS, 0L);
        if (xpropCount > 0) {
            ArrayList<ZCalendar.ZProperty> list = new ArrayList<ZCalendar.ZProperty>(xpropCount);
            for (int propNum = 0; propNum < xpropCount; ++propNum) {
                List<ZCalendar.ZParameter> xparams;
                String propName;
                Metadata propMeta = meta.getMap(FN_XPROP_OR_XPARAM + propNum, true);
                if (propMeta == null || (propName = propMeta.get(FN_NAME, null)) == null) continue;
                ZCalendar.ZProperty xprop = new ZCalendar.ZProperty(propName);
                String propValue = propMeta.get(FN_VALUE, null);
                if (propValue != null) {
                    xprop.setValue(propValue);
                }
                if ((xparams = Util.decodeXParamsFromMetadata(propMeta)) != null) {
                    for (ZCalendar.ZParameter xparam : xparams) {
                        xprop.addParameter(xparam);
                    }
                }
                list.add(xprop);
            }
            return list;
        }
        return null;
    }
}

