/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailbox.calendar;

import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.WellKnownTimeZones;
import com.zimbra.cs.mailbox.calendar.ZRecur;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeZoneMap {
    static HashMap<ZRecur.ZWeekDay, Integer> sDayWeekDayMap = new HashMap();
    private Map<String, ICalTimeZone> mTzMap;
    private Map<String, String> mAliasMap;
    private ICalTimeZone mLocalTZ;

    public TimeZoneMap(ICalTimeZone localTZ) {
        this.mTzMap = new HashMap<String, ICalTimeZone>();
        this.mAliasMap = new HashMap<String, String>();
        this.mLocalTZ = localTZ;
    }

    public boolean contains(ICalTimeZone tz) {
        if (tz != null) {
            return this.mTzMap.containsKey(tz.getID());
        }
        return false;
    }

    private TimeZoneMap(Map<String, ICalTimeZone> z, Map<String, String> a, ICalTimeZone localTZ) {
        this.mTzMap = z;
        this.mAliasMap = a;
        this.mLocalTZ = localTZ;
    }

    public ICalTimeZone getTimeZone(String tzid) {
        ICalTimeZone tz = this.mTzMap.get(tzid = this.sanitizeTZID(tzid));
        if (tz == null && (tzid = this.mAliasMap.get(tzid)) != null) {
            tz = this.mTzMap.get(tzid);
        }
        return tz;
    }

    public ICalTimeZone getLocalTimeZone() {
        return this.mLocalTZ;
    }

    public Iterator<ICalTimeZone> tzIterator() {
        return this.mTzMap.values().iterator();
    }

    public Metadata encodeAsMetadata() {
        Metadata meta = new Metadata();
        HashMap<String, Integer> tzIndex = new HashMap<String, Integer>();
        int nextIndex = 0;
        for (Map.Entry<String, ICalTimeZone> entry : this.mTzMap.entrySet()) {
            ICalTimeZone zone;
            String realTzid;
            String tzid = entry.getKey();
            if (tzid == null || tzid.length() < 1 || tzIndex.containsKey(realTzid = (zone = entry.getValue()).getID())) continue;
            meta.put("#" + nextIndex, zone.encodeAsMetadata());
            tzIndex.put(realTzid, nextIndex);
            ++nextIndex;
        }
        for (Map.Entry<String, Object> entry : this.mAliasMap.entrySet()) {
            String alias = entry.getKey();
            String realTzid = (String)entry.getValue();
            if (!tzIndex.containsKey(realTzid)) continue;
            int index = (Integer)tzIndex.get(realTzid);
            meta.put(alias, index);
        }
        return meta;
    }

    public static TimeZoneMap decodeFromMetadata(Metadata meta, ICalTimeZone localTZ) throws ServiceException {
        Map map = meta.asMap();
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        ICalTimeZone[] tzlist = new ICalTimeZone[map.size()];
        for (Map.Entry entry : map.entrySet()) {
            ICalTimeZone tz;
            String key = (String)entry.getKey();
            if (key == null || key.length() <= 0 || key.charAt(0) != '#') continue;
            int idx = Integer.parseInt(key.substring(1));
            Metadata tzMeta = (Metadata)entry.getValue();
            String tzidMeta = tzMeta.get("tzid", null);
            if (tzidMeta == null || (tz = ICalTimeZone.decodeFromMetadata(tzMeta)) == null) continue;
            String tzid = tz.getID();
            if (!DebugConfig.disableCalendarTZMatchByID) {
                tzid = TZIDMapper.canonicalize(tzid);
            }
            if (!tzidMeta.equals(tzid)) {
                aliasMap.put(tzidMeta, tzid);
                tz = WellKnownTimeZones.getTimeZoneById(tzid);
            }
            tzlist[idx] = tz;
        }
        HashMap<String, ICalTimeZone> tzmap = new HashMap<String, ICalTimeZone>();
        for (ICalTimeZone tz : tzlist) {
            if (tz == null) continue;
            tzmap.put(tz.getID(), tz);
        }
        for (Map.Entry entry : map.entrySet()) {
            String realId;
            ICalTimeZone tz;
            String tzid = (String)entry.getKey();
            if (tzid == null || tzid.length() <= 0 || tzid.charAt(0) == '#') continue;
            int idx = -1;
            try {
                idx = Integer.parseInt(entry.getValue().toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (idx < 0 || idx >= tzlist.length || (tz = tzlist[idx]) == null || (realId = tz.getID()).equals(tzid)) continue;
            aliasMap.put(tzid, realId);
        }
        return new TimeZoneMap(tzmap, aliasMap, localTZ);
    }

    public void add(TimeZoneMap other) {
        this.mAliasMap.putAll(other.mAliasMap);
        for (Map.Entry<String, ICalTimeZone> entry : other.mTzMap.entrySet()) {
            ICalTimeZone zone = entry.getValue();
            if (this.mTzMap.containsKey(zone.getID())) continue;
            this.add(zone);
        }
    }

    public void add(ICalTimeZone tz) {
        ICalTimeZone ruleMatch;
        ICalTimeZone canonTz;
        String tzid = tz.getID();
        String canonTzid = null;
        if (!DebugConfig.disableCalendarTZMatchByID && (canonTz = WellKnownTimeZones.getTimeZoneById(canonTzid = TZIDMapper.canonicalize(tzid))) != null) {
            this.mTzMap.put(canonTzid, canonTz);
            if (!tzid.equals(canonTzid)) {
                this.mAliasMap.put(tzid, canonTzid);
            }
            return;
        }
        if (!DebugConfig.disableCalendarTZMatchByRule && (ruleMatch = WellKnownTimeZones.getBestMatch(tz)) != null) {
            String realTzid = ruleMatch.getID();
            this.mTzMap.put(realTzid, ruleMatch);
            if (!tzid.equals(realTzid)) {
                this.mAliasMap.put(tzid, realTzid);
            }
            return;
        }
        this.mTzMap.put(tzid, tz);
    }

    public String sanitizeTZID(String tzid) {
        int len = tzid.length();
        if (len >= 2 && tzid.charAt(0) == '\"' && tzid.charAt(len - 1) == '\"') {
            return tzid.substring(1, len - 1);
        }
        return tzid;
    }

    public ICalTimeZone lookupAndAdd(String tzId) throws ServiceException {
        ICalTimeZone zone;
        if ((tzId = this.sanitizeTZID(tzId)).equals("")) {
            return null;
        }
        if (!DebugConfig.disableCalendarTZMatchByID) {
            tzId = TZIDMapper.canonicalize(tzId);
        }
        if ((zone = this.getTimeZone(tzId)) == null) {
            zone = WellKnownTimeZones.getTimeZoneById(tzId);
            if (zone != null) {
                this.add(zone);
            } else {
                ZimbraLog.calendar.warn("Encountered time zone with no definition: TZID=" + tzId);
            }
        }
        return zone;
    }

    public String toString() {
        String s = "{";
        s = s + "LocalTz = " + this.mLocalTZ + "; others {";
        for (ICalTimeZone i : this.mTzMap.values()) {
            s = s + i + "; ";
        }
        s = s + "} }";
        return s;
    }

    static {
        sDayWeekDayMap.put(ZRecur.ZWeekDay.SU, new Integer(1));
        sDayWeekDayMap.put(ZRecur.ZWeekDay.MO, new Integer(2));
        sDayWeekDayMap.put(ZRecur.ZWeekDay.TU, new Integer(3));
        sDayWeekDayMap.put(ZRecur.ZWeekDay.WE, new Integer(4));
        sDayWeekDayMap.put(ZRecur.ZWeekDay.TH, new Integer(5));
        sDayWeekDayMap.put(ZRecur.ZWeekDay.FR, new Integer(6));
        sDayWeekDayMap.put(ZRecur.ZWeekDay.SA, new Integer(7));
    }
}

